/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class RestApiUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private RestApiUtil() {
    }

    public static <T> List<T> parseRestApiEntries(JSONObject jsonObject, Class<T> clazz) throws Exception {
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertNotNull(clazz);
        ArrayList<T> models = new ArrayList<T>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            T pojoModel = RestApiUtil.parseRestApiEntry(jsonEntry, clazz);
            models.add(pojoModel);
        }
        return models;
    }

    public static <T> T parseRestApiEntry(JSONObject jsonObject, Class<T> clazz) throws Exception {
        return RestApiUtil.parsePojo("entry", jsonObject, clazz);
    }

    public static PublicApiClient.ExpectedPaging parsePaging(JSONObject jsonObject) throws Exception {
        Assert.assertNotNull((Object)jsonObject);
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        return RestApiUtil.parsePojo("pagination", jsonList, PublicApiClient.ExpectedPaging.class);
    }

    public static <T> T parsePojo(String key, JSONObject jsonObject, Class<T> clazz) throws Exception {
        Assert.assertNotNull((Object)jsonObject);
        Assert.assertNotNull(clazz);
        JSONObject pojo = (JSONObject)jsonObject.get((Object)key);
        Object pojoModel = OBJECT_MAPPER.readValue(pojo.toJSONString(), clazz);
        Assert.assertNotNull((Object)pojoModel);
        return (T)pojoModel;
    }

    public static PublicApiClient.ExpectedErrorResponse parseErrorResponse(JSONObject jsonObject) throws Exception {
        return RestApiUtil.parsePojo("error", jsonObject, PublicApiClient.ExpectedErrorResponse.class);
    }

    public static String toJsonAsString(Object object) throws Exception {
        Assert.assertNotNull((Object)object);
        return OBJECT_MAPPER.writeValueAsString(object);
    }

    public static String toJsonAsStringNonNull(Object object) throws IOException {
        Assert.assertNotNull((Object)object);
        ObjectMapper om = new ObjectMapper();
        om.setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL);
        om.configOverride(Map.class).setIncludeAsProperty(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.ALWAYS, (JsonInclude.Include)JsonInclude.Include.ALWAYS));
        return om.writeValueAsString(object);
    }
}

