/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.web.scripts.content.ContentStreamer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.ScriptProcessor;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WebScriptStatus;

public class StreamContent
extends AbstractWebScript {
    private static final Log logger = LogFactory.getLog(StreamContent.class);
    protected PermissionService permissionService;
    protected NodeService nodeService;
    protected MimetypeService mimetypeService;
    protected ContentStreamer delegate;
    protected Repository repository;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDelegate(ContentStreamer delegate) {
        this.delegate = delegate;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        String format = req.getFormat();
        try {
            Status status = new Status();
            Cache cache = new Cache(this.getDescription().getRequiredCache());
            Map<String, Object> model = this.executeImpl(req, status, cache);
            if (model == null) {
                model = new HashMap<String, Object>(8, 1.0f);
            }
            model.put("status", status);
            model.put("cache", cache);
            AbstractWebScript.ScriptDetails executeScript = this.getExecuteScript(req.getContentType());
            if (executeScript != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing script " + executeScript.getContent().getPathDescription()));
                }
                Map scriptModel = this.createScriptParameters(req, res, executeScript, model);
                HashMap<String, Object> returnModel = new HashMap<String, Object>(8, 1.0f);
                scriptModel.put("model", returnModel);
                this.executeScript(executeScript.getContent(), scriptModel);
                this.mergeScriptModelIntoTemplateModel(executeScript.getContent().getPath(), returnModel, model);
            }
            if (status.getRedirect()) {
                Map templateModel = this.createTemplateParameters(req, res, model);
                this.sendStatus(req, res, status, cache, format, templateModel);
            } else {
                String contentPath;
                Boolean attachBoolean = (Boolean)model.get("attach");
                boolean attach = false;
                if (attachBoolean != null) {
                    attach = attachBoolean;
                }
                if ((contentPath = (String)model.get("contentPath")) == null) {
                    NodeRef nodeRef = (NodeRef)model.get("contentNode");
                    if (nodeRef == null) {
                        throw new WebScriptException("The content node was not specified so the content cannot be streamed to the client: " + executeScript.getContent().getPathDescription());
                    }
                    QName propertyQName = null;
                    String contentProperty = (String)model.get("contentProperty");
                    propertyQName = contentProperty == null ? ContentModel.PROP_CONTENT : QName.createQName((String)contentProperty);
                    this.delegate.streamContent(req, res, nodeRef, propertyQName, attach, null, model);
                } else {
                    this.delegate.streamContent(req, res, contentPath, attach, model);
                }
            }
        }
        catch (Throwable e) {
            throw this.createStatusException(e, req, res);
        }
    }

    protected void setAttachment(WebScriptResponse res, boolean attach, String attachFileName) {
        this.delegate.setAttachment(null, res, attach, attachFileName);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, File file) throws IOException {
        this.streamContent(req, res, file, false, null, null);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, File file, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        this.delegate.streamContent(req, res, file, null, attach, attachFileName, model);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, NodeRef nodeRef, QName propertyQName, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        this.delegate.streamContent(req, res, nodeRef, propertyQName, attach, attachFileName, model);
    }

    protected void streamContentImpl(WebScriptRequest req, WebScriptResponse res, ContentReader reader, NodeRef nodeRef, QName propertyQName, boolean attach, Date modified, String eTag, String attachFileName, Map<String, Object> model) throws IOException {
        this.delegate.streamContentImpl(req, res, reader, nodeRef, propertyQName, attach, modified, eTag, attachFileName, model);
    }

    private final void mergeScriptModelIntoTemplateModel(String scriptPath, Map<String, Object> scriptModel, Map<String, Object> templateModel) {
        int i = scriptPath.lastIndexOf(".");
        if (i != -1) {
            String extension = scriptPath.substring(i + 1);
            ScriptProcessor processor = this.getContainer().getScriptProcessorRegistry().getScriptProcessorByExtension(extension);
            if (processor != null) {
                for (Map.Entry<String, Object> entry : scriptModel.entrySet()) {
                    Object value = entry.getValue();
                    Object templateValue = processor.unwrapValue(value);
                    templateModel.put(entry.getKey(), templateValue);
                }
            }
        }
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, WebScriptStatus status) {
        return null;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        return this.executeImpl(req, new WebScriptStatus(status));
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        return this.executeImpl(req, status);
    }

    protected final void renderFormatTemplate(String format, Map<String, Object> model, Writer writer) {
        format = format == null ? "" : format;
        String templatePath = this.getDescription().getId() + "." + format + ".ftl";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rendering template '" + templatePath + "'"));
        }
        this.renderTemplate(templatePath, model, writer);
    }

    protected ObjectReference createObjectReferenceFromUrl(Map<String, String> args, Map<String, String> templateArgs) {
        String objectId = args.get("noderef");
        if (objectId != null) {
            return new ObjectReference(objectId);
        }
        StoreRef storeRef = null;
        String store_type = templateArgs.get("store_type");
        String store_id = templateArgs.get("store_id");
        if (store_type != null && store_id != null) {
            storeRef = new StoreRef(store_type, store_id);
        }
        String id = templateArgs.get("id");
        if (storeRef != null && id != null) {
            return new ObjectReference(storeRef, id);
        }
        String nodepath = templateArgs.get("nodepath");
        if (nodepath == null) {
            nodepath = args.get("nodepath");
        }
        if (storeRef != null && nodepath != null) {
            return new ObjectReference(storeRef, nodepath.split("/"));
        }
        return null;
    }

    class ObjectReference {
        private NodeRef ref;

        ObjectReference(String nodeRef) {
            this.ref = new NodeRef(nodeRef);
        }

        ObjectReference(StoreRef ref, String id) {
            String[] relativePath = id.split("/");
            if (relativePath.length <= 2) {
                if (id.indexOf(47) != -1) {
                    id = id.substring(0, id.indexOf(47));
                }
                this.ref = new NodeRef(ref, id);
            } else {
                String[] reference = new String[relativePath.length + 2];
                reference[0] = ref.getProtocol();
                reference[1] = ref.getIdentifier();
                System.arraycopy(relativePath, 0, reference, 2, relativePath.length);
                this.ref = StreamContent.this.repository.findNodeRef("node", reference);
            }
        }

        ObjectReference(StoreRef ref, String[] path) {
            String[] reference = new String[path.length + 2];
            reference[0] = ref.getProtocol();
            reference[1] = ref.getIdentifier();
            System.arraycopy(path, 0, reference, 2, path.length);
            this.ref = StreamContent.this.repository.findNodeRef("path", reference);
        }

        public NodeRef getNodeRef() {
            return this.ref;
        }

        public String toString() {
            return this.ref != null ? this.ref.toString() : super.toString();
        }
    }
}

