/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.sites;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.Sites;
import org.alfresco.rest.api.model.SiteMember;
import org.alfresco.rest.api.sites.SiteEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="members", entityResource=SiteEntityResource.class, title="Site Members")
public class SiteMembersRelation
implements RelationshipResourceAction.Read<SiteMember>,
RelationshipResourceAction.Delete,
RelationshipResourceAction.Create<SiteMember>,
RelationshipResourceAction.Update<SiteMember>,
RelationshipResourceAction.ReadById<SiteMember>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(SiteMembersRelation.class);
    private Sites sites;

    public void setSites(Sites sites) {
        this.sites = sites;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"sites", (Object)this.sites);
    }

    @Override
    @WebApiDescription(title="A paged list of all the members of the site 'siteId'.")
    public CollectionWithPagingInfo<SiteMember> readAll(String siteId, Parameters parameters) {
        return this.sites.getSiteMembers(siteId, parameters);
    }

    @Override
    @WebApiDescription(title="Adds personId as a member of site siteId.")
    public List<SiteMember> create(String siteId, List<SiteMember> siteMembers, Parameters parameters) {
        ArrayList<SiteMember> result = new ArrayList<SiteMember>(siteMembers.size());
        for (SiteMember siteMember : siteMembers) {
            result.add(this.sites.addSiteMember(siteId, siteMember));
        }
        return result;
    }

    @Override
    @WebApiDescription(title="Removes personId as a member of site siteId.")
    public void delete(String siteId, String personId, Parameters parameters) {
        this.sites.removeSiteMember(personId, siteId);
    }

    @Override
    @WebApiDescription(title="Updates the membership of personId in the site (of which personId must be an existing member).")
    public SiteMember update(String siteId, SiteMember siteMember, Parameters parameters) {
        return this.sites.updateSiteMember(siteId, siteMember);
    }

    @Override
    @WebApiDescription(title="Returns site membership information for personId in siteId.")
    public SiteMember readById(String siteId, String personId, Parameters parameters) {
        return this.sites.getSiteMember(personId, siteId);
    }
}

