/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.FavouriteNode;
import org.alfresco.rest.api.tests.client.data.JSONAble;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class FavouriteDocument
extends FavouriteNode
implements ExpectedComparison,
JSONAble {
    private static final long serialVersionUID = -5890002728061039516L;
    private String mimeType;
    private BigInteger sizeInBytes;
    private String versionLabel;

    public FavouriteDocument(String guid) {
        super(guid);
    }

    public FavouriteDocument(String id, String guid) {
        super(id, guid);
    }

    public static FavouriteDocument getDocument(String id, String guid, Properties props) {
        FavouriteDocument document = new FavouriteDocument(id, guid);
        Map properties = props.getProperties();
        document.setName((String)((PropertyData)properties.get("cmis:name")).getFirstValue());
        document.setTitle((String)((PropertyData)properties.get(ContentModel.PROP_TITLE.toString())).getFirstValue());
        document.setCreatedBy((String)((PropertyData)properties.get("cmis:createdBy")).getFirstValue());
        document.setModifiedBy((String)((PropertyData)properties.get("cmis:lastModifiedBy")).getFirstValue());
        GregorianCalendar modifiedAt = (GregorianCalendar)((PropertyData)properties.get("cmis:lastModificationDate")).getFirstValue();
        document.setModifiedAt(modifiedAt.getTime());
        GregorianCalendar createdAt = (GregorianCalendar)((PropertyData)properties.get("cmis:creationDate")).getFirstValue();
        document.setCreatedAt(createdAt.getTime());
        document.setMimeType((String)((PropertyData)properties.get("cmis:contentStreamMimeType")).getFirstValue());
        document.setSizeInBytes((BigInteger)((PropertyData)properties.get("cmis:contentStreamLength")).getFirstValue());
        document.setVersionLabel((String)((PropertyData)properties.get("cmis:versionLabel")).getFirstValue());
        return document;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public BigInteger getSizeInBytes() {
        return this.sizeInBytes;
    }

    public String getVersionLabel() {
        return this.versionLabel;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setSizeInBytes(BigInteger sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    public void setVersionLabel(String versionLabel) {
        this.versionLabel = versionLabel;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        return json;
    }

    @Override
    public void expected(Object o) {
        super.expected(o);
        Assert.assertTrue((boolean)(o instanceof FavouriteDocument));
        FavouriteDocument other = (FavouriteDocument)o;
        AssertUtil.assertEquals("mimeType", this.mimeType, other.getMimeType());
        AssertUtil.assertEquals("sizeInBytes", this.sizeInBytes, other.getSizeInBytes());
        AssertUtil.assertEquals("versionLabel", this.versionLabel, other.getVersionLabel());
    }

    public static FavouriteDocument parseDocument(JSONObject jsonObject) throws ParseException {
        String id = (String)jsonObject.get((Object)"id");
        String guid = (String)jsonObject.get((Object)"guid");
        String name = (String)jsonObject.get((Object)"name");
        String title = (String)jsonObject.get((Object)"title");
        String description = (String)jsonObject.get((Object)"description");
        Date createdAt = PublicApiDateFormat.getDateFormat().parse((String)jsonObject.get((Object)"createdAt"));
        Date modifiedAt = PublicApiDateFormat.getDateFormat().parse((String)jsonObject.get((Object)"modifiedAt"));
        String createdBy = (String)jsonObject.get((Object)"createdBy");
        String modifiedBy = (String)jsonObject.get((Object)"modifiedBy");
        String mimeType = (String)jsonObject.get((Object)"mimeType");
        Long sizeInBytes = (Long)jsonObject.get((Object)"sizeInBytes");
        String versionLabel = (String)jsonObject.get((Object)"versionLabel");
        FavouriteDocument document = new FavouriteDocument(id, guid);
        document.setName(name);
        document.setTitle(title);
        document.setCreatedBy(createdBy);
        document.setModifiedBy(modifiedBy);
        document.setModifiedAt(modifiedAt);
        document.setCreatedAt(createdAt);
        document.setDescription(description);
        document.setMimeType(mimeType);
        document.setSizeInBytes(BigInteger.valueOf(sizeInBytes));
        document.setVersionLabel(versionLabel);
        document.parseAndSetPath(jsonObject);
        return document;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("FavouriteDocument [nodeId=").append(this.nodeId).append(", guid=").append(this.guid).append(", name=").append(this.name).append(", title=").append(this.title).append(", description=").append(this.description).append(", createdAt=").append(this.createdAt).append(", modifiedAt=").append(this.modifiedAt).append(", createdBy=").append(this.createdBy).append(", modifiedBy=").append(this.modifiedBy).append(", mimeType=").append(this.mimeType).append(", sizeInBytes=").append(this.sizeInBytes).append(", versionLabel=").append(this.versionLabel).append(", path=").append(this.path).append(']');
        return sb.toString();
    }
}

