/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.webdav.WebDAVActivityPoster;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.activities.ActivityPoster;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.sync.repo.Client;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActivityPosterImpl
implements WebDAVActivityPoster {
    private String appTool;
    private ActivityPoster poster;
    protected static Log logger = LogFactory.getLog((String)"org.alfresco.webdav.protocol.activity");

    public ActivityPosterImpl() {
    }

    public ActivityPosterImpl(String appTool, ActivityPoster poster) {
        this.appTool = appTool;
        this.poster = poster;
    }

    @Override
    public void postFileFolderAdded(String siteId, String tenantDomain, String path, FileInfo nodeInfo) throws WebDAVServerException {
        this.postFileFolderActivity(nodeInfo.isFolder() ? "org.alfresco.documentlibrary.folder-added" : "org.alfresco.documentlibrary.file-added", siteId, tenantDomain, nodeInfo.isFolder() ? path : null, null, nodeInfo);
    }

    @Override
    public void postFileFolderUpdated(String siteId, String tenantDomain, FileInfo nodeInfo) throws WebDAVServerException {
        if (!nodeInfo.isFolder()) {
            this.postFileFolderActivity("org.alfresco.documentlibrary.file-updated", siteId, tenantDomain, null, null, nodeInfo);
        }
    }

    @Override
    public void postFileFolderDeleted(String siteId, String tenantDomain, String parentPath, FileInfo parentNodeInfo, FileInfo nodeInfo) throws WebDAVServerException {
        this.postFileFolderActivity(nodeInfo.isFolder() ? "org.alfresco.documentlibrary.folder-deleted" : "org.alfresco.documentlibrary.file-deleted", siteId, tenantDomain, parentPath, parentNodeInfo.getNodeRef(), nodeInfo);
    }

    private void postFileFolderActivity(String activityType, String siteId, String tenantDomain, String path, NodeRef parentNodeRef, FileInfo contentNodeInfo) throws WebDAVServerException {
        String fileName = contentNodeInfo.getName();
        NodeRef nodeRef = contentNodeInfo.getNodeRef();
        try {
            this.poster.postFileFolderActivity(activityType, path, tenantDomain, siteId, parentNodeRef, nodeRef, fileName, this.appTool, Client.asType((Client.ClientType)Client.ClientType.webdav), contentNodeInfo);
        }
        catch (AlfrescoRuntimeException are) {
            logger.error((Object)"Failed to post activity.", (Throwable)are);
            throw new WebDAVServerException(500);
        }
    }

    public void setAppTool(String appTool) {
        this.appTool = appTool;
    }

    public void setPoster(ActivityPoster poster) {
        this.poster = poster;
    }
}

