/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.discussion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.discussion.DiscussionService;
import org.alfresco.service.cmr.discussion.PostInfo;
import org.alfresco.service.cmr.discussion.TopicInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.Pair;
import org.alfresco.util.ScriptPagingDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractDiscussionWebScript
extends DeclarativeWebScript {
    public static final String DISCUSSIONS_SERVICE_ACTIVITY_APP_NAME = "discussions";
    protected static final int MAX_QUERY_ENTRY_COUNT = 1000;
    private static Log logger = LogFactory.getLog(AbstractDiscussionWebScript.class);
    protected static final String KEY_POSTDATA = "postData";
    protected static final String KEY_IS_TOPIC_POST = "isTopicPost";
    protected static final String KEY_TOPIC = "topic";
    protected static final String KEY_POST = "post";
    protected static final String KEY_CAN_EDIT = "canEdit";
    protected static final String KEY_AUTHOR = "author";
    protected NodeService nodeService;
    protected SiteService siteService;
    protected PersonService personService;
    protected ActivityService activityService;
    protected DiscussionService discussionService;
    protected PermissionService permissionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public void setDiscussionService(DiscussionService discussionService) {
        this.discussionService = discussionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected String getOrNull(JSONObject json, String key) {
        if (json.containsKey((Object)key)) {
            return (String)json.get((Object)key);
        }
        return null;
    }

    protected PagingRequest buildPagingRequest(WebScriptRequest req) {
        return new ScriptPagingDetails(req, 1000);
    }

    protected List<String> getTags(JSONObject json) {
        ArrayList<String> tags = null;
        if (json.containsKey((Object)"tags")) {
            if (json.get((Object)"tags") instanceof String) {
                String tagsS = (String)json.get((Object)"tags");
                if ("".equals(tagsS)) {
                    return null;
                }
                logger.warn((Object)("Unexpected tag data: " + tagsS));
                return null;
            }
            tags = new ArrayList<String>();
            JSONArray jsTags = (JSONArray)json.get((Object)"tags");
            for (int i = 0; i < jsTags.size(); ++i) {
                tags.add((String)jsTags.get(i));
            }
        }
        return tags;
    }

    protected void addActivityEntry(String thing, String event, TopicInfo topic, PostInfo post, SiteInfo site, WebScriptRequest req, JSONObject json) {
        String postTitle;
        if (site == null) {
            logger.info((Object)("Unable to add activity entry for " + thing + " " + event + " as no site given"));
            return;
        }
        String page = req.getParameter("page");
        if (page == null && json != null && json.containsKey((Object)"page")) {
            page = (String)json.get((Object)"page");
        }
        if (page == null) {
            page = "discussions-topicview";
        }
        String title = topic.getTitle();
        if (post != null && (postTitle = post.getTitle()) != null && postTitle.length() > 0) {
            title = postTitle;
        }
        try {
            JSONObject params = new JSONObject();
            params.put((Object)"topicId", (Object)topic.getSystemName());
            JSONObject activity = new JSONObject();
            activity.put((Object)"title", (Object)title);
            activity.put((Object)"page", (Object)(page + "?topicId=" + topic.getSystemName()));
            activity.put((Object)"params", (Object)params);
            this.activityService.postActivity("org.alfresco.discussions." + thing + "-" + event, site.getShortName(), DISCUSSIONS_SERVICE_ACTIVITY_APP_NAME, activity.toString());
        }
        catch (Exception e) {
            logger.warn((Object)("Error adding discussions " + thing + " " + event + " to activities feed"), (Throwable)e);
        }
    }

    protected boolean canUserEditPost(PostInfo post, SiteInfo site) {
        AccessStatus canEdit = this.permissionService.hasPermission(post.getNodeRef(), "Write");
        if (canEdit == AccessStatus.ALLOWED) {
            String role;
            String user = AuthenticationUtil.getFullyAuthenticatedUser();
            if (post.getCreator().equals(user)) {
                return true;
            }
            if (site != null && "SiteManager".equals(role = this.siteService.getMembersRole(site.getShortName(), user))) {
                return true;
            }
        }
        return false;
    }

    protected Object buildPerson(String username) {
        String noSuchPersonResponse = "";
        if (username == null || username.length() == 0) {
            return noSuchPersonResponse;
        }
        try {
            NodeRef person = this.personService.getPerson(username);
            return person;
        }
        catch (NoSuchPersonException e) {
            return noSuchPersonResponse;
        }
    }

    protected Map<String, Object> renderPost(PostInfo post, SiteInfo site) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(KEY_IS_TOPIC_POST, false);
        item.put(KEY_POST, post.getNodeRef());
        item.put(KEY_CAN_EDIT, this.canUserEditPost(post, site));
        item.put(KEY_AUTHOR, this.buildPerson(post.getCreator()));
        return item;
    }

    protected Map<String, Object> renderTopic(TopicInfo topic, SiteInfo site) {
        int numReplies;
        PostInfo primaryPost = this.discussionService.getPrimaryPost(topic);
        if (primaryPost == null) {
            throw new WebScriptException(412, "First (primary) post was missing from the topic, can't fetch");
        }
        PostInfo mostRecentPost = this.discussionService.getMostRecentPost(topic);
        if (mostRecentPost.getNodeRef().equals((Object)primaryPost.getNodeRef())) {
            mostRecentPost = null;
            numReplies = 0;
        } else {
            PagingRequest paging = new PagingRequest(1);
            paging.setRequestTotalCountMax(1000);
            PagingResults posts = this.discussionService.listPosts(topic, paging);
            numReplies = (Integer)posts.getTotalResultCount().getFirst() - 1;
        }
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(KEY_IS_TOPIC_POST, true);
        item.put(KEY_TOPIC, topic.getNodeRef());
        item.put(KEY_POST, primaryPost.getNodeRef());
        item.put(KEY_CAN_EDIT, this.canUserEditPost(primaryPost, site));
        item.put(KEY_AUTHOR, this.buildPerson(topic.getCreator()));
        item.put("totalReplyCount", numReplies);
        item.put("site", topic.getShortSiteName());
        if (mostRecentPost != null) {
            item.put("lastReply", mostRecentPost.getNodeRef());
            item.put("lastReplyBy", this.buildPerson(mostRecentPost.getCreator()));
        }
        item.put("tags", topic.getTags());
        return item;
    }

    protected Map<String, Object> renderTopics(PagingResults<TopicInfo> topics, PagingRequest paging, SiteInfo site) {
        return this.renderTopics(topics.getPage(), (Pair<Integer, Integer>)topics.getTotalResultCount(), paging, site);
    }

    protected Map<String, Object> renderTopics(List<TopicInfo> topics, Pair<Integer, Integer> size, PagingRequest paging, SiteInfo site) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("total", size.getFirst());
        model.put("pageSize", paging.getMaxItems());
        model.put("startIndex", paging.getSkipCount());
        model.put("itemCount", topics.size());
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        for (TopicInfo topic : topics) {
            if (null == site && null != topic.getShortSiteName()) {
                String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
                String siteShortName = topic.getShortSiteName();
                boolean isSiteMember = this.siteService.isMember(siteShortName, currentUser);
                if (!isSiteMember) continue;
                items.add(this.renderTopic(topic, site));
                continue;
            }
            items.add(this.renderTopic(topic, site));
        }
        model.put("items", items);
        return model;
    }

    protected Map<String, Object> buildCommonModel(SiteInfo site, TopicInfo topic, PostInfo post, WebScriptRequest req) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(KEY_TOPIC, topic);
        model.put(KEY_POST, post);
        if (site != null) {
            model.put("siteId", site.getShortName());
            model.put("site", site);
        }
        int contentLength = -1;
        String contentLengthS = req.getParameter("contentLength");
        if (contentLengthS != null) {
            try {
                contentLength = Integer.parseInt(contentLengthS);
            }
            catch (NumberFormatException e) {
                logger.info((Object)("Skipping invalid length " + contentLengthS));
            }
        }
        model.put("contentLength", contentLength);
        return model;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            String error = "No parameters supplied";
            throw new WebScriptException(400, error);
        }
        JSONObject json = null;
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if ("application/json".equals(contentType)) {
            JSONParser parser = new JSONParser();
            try {
                json = (JSONObject)parser.parse(req.getContent().getContent());
            }
            catch (IOException io) {
                throw new WebScriptException(400, "Invalid JSON: " + io.getMessage());
            }
            catch (ParseException pe) {
                throw new WebScriptException(400, "Invalid JSON: " + pe.getMessage());
            }
        }
        NodeRef nodeRef = null;
        SiteInfo site = null;
        TopicInfo topic = null;
        PostInfo post = null;
        if (templateVars.containsKey("site")) {
            String siteName = (String)templateVars.get("site");
            site = this.siteService.getSite(siteName);
            if (site == null) {
                String error = "Could not find site: " + siteName;
                throw new WebScriptException(404, error);
            }
            if (templateVars.containsKey("path")) {
                String name = (String)templateVars.get("path");
                topic = this.discussionService.getTopic(site.getShortName(), name);
                if (topic == null) {
                    String error = "Could not find topic '" + name + "' for site '" + site.getShortName() + "'";
                    throw new WebScriptException(404, error);
                }
                nodeRef = topic.getNodeRef();
            } else if (this.siteService.hasContainer(siteName, DISCUSSIONS_SERVICE_ACTIVITY_APP_NAME)) {
                nodeRef = this.siteService.getContainer(siteName, DISCUSSIONS_SERVICE_ACTIVITY_APP_NAME);
            }
        } else if (templateVars.containsKey("store_type") && templateVars.containsKey("store_id") && templateVars.containsKey("id")) {
            NodeRef maybeSite;
            NodeRef container;
            StoreRef store = new StoreRef((String)templateVars.get("store_type"), (String)templateVars.get("store_id"));
            nodeRef = new NodeRef(store, (String)templateVars.get("id"));
            if (!this.nodeService.exists(nodeRef)) {
                String error = "Could not find node: " + String.valueOf(nodeRef);
                throw new WebScriptException(404, error);
            }
            Pair objects = this.discussionService.getForNodeRef(nodeRef);
            if (objects != null) {
                topic = (TopicInfo)objects.getFirst();
                post = (PostInfo)objects.getSecond();
            }
            if (topic != null && (container = topic.getContainerNodeRef()) != null && (maybeSite = this.nodeService.getPrimaryParent(container).getParentRef()) != null) {
                site = this.siteService.getSite(maybeSite);
            }
        } else {
            String error = "Unsupported template parameters found";
            throw new WebScriptException(400, error);
        }
        return this.executeImpl(site, nodeRef, topic, post, req, json, status, cache);
    }

    protected abstract Map<String, Object> executeImpl(SiteInfo var1, NodeRef var2, TopicInfo var3, PostInfo var4, WebScriptRequest var5, JSONObject var6, Status var7, Cache var8);
}

