/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.json.JSONArray;
import org.json.JSONException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

@Experimental
public class ActionParameterConverter {
    static final String ACTION_PARAMETER_SHOULD_NOT_HAVE_EMPTY_OR_NULL_VALUE = "Action parameter should not have empty or null value";
    private final DictionaryService dictionaryService;
    private final ActionService actionService;
    private final NamespaceService namespaceService;
    private final PermissionService permissionService;
    private final Nodes nodes;

    public ActionParameterConverter(DictionaryService dictionaryService, ActionService actionService, NamespaceService namespaceService, PermissionService permissionService, Nodes nodes) {
        this.dictionaryService = dictionaryService;
        this.actionService = actionService;
        this.namespaceService = namespaceService;
        this.permissionService = permissionService;
        this.nodes = nodes;
    }

    public Map<String, Serializable> getConvertedParams(Map<String, Serializable> params, String name) {
        ActionDefinition definition;
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>(params.size());
        try {
            definition = this.actionService.getActionDefinition(name);
            if (definition == null) {
                throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{name});
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{name});
        }
        for (Map.Entry<String, Serializable> param : params.entrySet()) {
            if (Objects.toString(param.getValue(), "").isEmpty()) {
                throw new InvalidArgumentException(ACTION_PARAMETER_SHOULD_NOT_HAVE_EMPTY_OR_NULL_VALUE, new String[]{param.getKey()});
            }
            ParameterDefinition paramDef = definition.getParameterDefintion(param.getKey());
            if (paramDef == null && !definition.getAdhocPropertiesAllowed()) {
                throw new InvalidArgumentException(InvalidArgumentException.DEFAULT_MESSAGE_ID, new String[]{param.getKey(), name});
            }
            if (paramDef != null) {
                QName typeQName = paramDef.getType();
                parameters.put(param.getKey(), this.convertValue(typeQName, param.getValue()));
                continue;
            }
            parameters.put(param.getKey(), (Serializable)((Object)param.getValue().toString()));
        }
        return parameters;
    }

    public Serializable convertParamFromServiceModel(Serializable param) {
        if (param instanceof QName) {
            return ((QName)param).toPrefixString((NamespacePrefixResolver)this.namespaceService);
        }
        if (param instanceof NodeRef) {
            return ((NodeRef)param).getId();
        }
        return param;
    }

    private Serializable convertValue(QName typeQName, Object propertyValue) throws JSONException {
        Object value;
        DataTypeDefinition typeDef = this.dictionaryService.getDataType(typeQName);
        if (typeDef == null) {
            throw new NotFoundException(NotFoundException.DEFAULT_MESSAGE_ID, new String[]{typeQName.toPrefixString()});
        }
        if (propertyValue instanceof JSONArray) {
            String javaClassName = typeDef.getJavaClassName();
            try {
                Class.forName(javaClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DictionaryException("Java class " + javaClassName + " of property type " + String.valueOf(typeDef.getName()) + " is invalid", (Throwable)e);
            }
            int length = ((JSONArray)propertyValue).length();
            ArrayList<Serializable> list = new ArrayList<Serializable>(length);
            for (int i = 0; i < length; ++i) {
                list.add(this.convertValue(typeQName, ((JSONArray)propertyValue).get(i)));
            }
            value = list;
        } else {
            String stringValue = Objects.toString(propertyValue, "");
            if (typeQName.isMatch(DataTypeDefinition.QNAME) && typeQName.toString().contains(":")) {
                value = QName.createQName((String)stringValue, (NamespacePrefixResolver)this.namespaceService);
            } else if (typeQName.isMatch(DataTypeDefinition.NODE_REF)) {
                NodeRef nodeRef = this.nodes.validateOrLookupNode(stringValue);
                if (this.permissionService.hasReadPermission(nodeRef) != AccessStatus.ALLOWED) {
                    throw new EntityNotFoundException(stringValue);
                }
                value = nodeRef;
            } else {
                value = (Serializable)DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(typeQName), propertyValue);
            }
        }
        return value;
    }
}

