/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.Activities;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Activity;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestActivities
extends EnterpriseTestApi {
    private SiteService siteService;
    private RepoService.TestNetwork network1;
    private RepoService.TestNetwork network2;
    private RepoService.TestNetwork defaultNetwork;
    private RepoService.TestPerson person1;
    private RepoService.TestPerson person2;
    private RepoService.TestPerson person3;
    private RepoService.TestPerson person4;
    private RepoService.TestPerson person5;
    private RepoService.TestSite testSite;
    private RepoService.TestSite testSite1;
    private RepoService.TestSite testSite2;
    private RepoService.TestSite testSite3;

    @Override
    @Before
    public void setup() throws Exception {
        this.network1 = this.repoService.createNetworkWithAlias("activitiesNetwork1", true);
        this.network2 = this.repoService.createNetworkWithAlias("activitiesNetwork2", true);
        this.defaultNetwork = this.repoService.createNetwork("", true);
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
        try {
            AuthenticationUtil.pushAuthentication();
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
            this.network1.create();
            this.network2.create();
            this.defaultNetwork.create();
        }
        finally {
            AuthenticationUtil.popAuthentication();
        }
        final ArrayList people = new ArrayList(5);
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestActivities.this.network1.createUser();
                people.add(person);
                person = TestActivities.this.network1.createUser();
                people.add(person);
                return null;
            }
        }, (String)this.network1.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestActivities.this.network2.createUser();
                people.add(person);
                return null;
            }
        }, (String)this.network2.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = TestActivities.this.defaultNetwork.createUser();
                people.add(person);
                person = TestActivities.this.defaultNetwork.createUser();
                people.add(person);
                return null;
            }
        }, (String)this.defaultNetwork.getId());
        this.person1 = (RepoService.TestPerson)people.get(0);
        this.person2 = (RepoService.TestPerson)people.get(1);
        this.person3 = (RepoService.TestPerson)people.get(2);
        this.person4 = (RepoService.TestPerson)people.get(3);
        this.person5 = (RepoService.TestPerson)people.get(4);
        this.testSite = (RepoService.TestSite)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<RepoService.TestSite>(){

            public RepoService.TestSite execute() throws Throwable {
                return (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                    public RepoService.TestSite doWork() throws Exception {
                        RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(GUID.generate(), "", "", SiteVisibility.PUBLIC);
                        RepoService.TestSite site = TestActivities.this.network1.createSite(siteInfo);
                        site.inviteToSite(TestActivities.this.person2.getId(), SiteRole.SiteCollaborator);
                        return site;
                    }
                }, (String)TestActivities.this.person1.getId(), (String)TestActivities.this.network1.getId());
            }
        }, false, true);
        this.testSite1 = (RepoService.TestSite)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<RepoService.TestSite>(){

            public RepoService.TestSite execute() throws Throwable {
                return (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                    public RepoService.TestSite doWork() throws Exception {
                        RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(GUID.generate(), "", "", SiteVisibility.PUBLIC);
                        return TestActivities.this.network1.createSite(siteInfo);
                    }
                }, (String)TestActivities.this.person1.getId(), (String)TestActivities.this.network1.getId());
            }
        }, false, true);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                JSONObject activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite1.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite1.getSiteId(), activityData);
                return null;
            }
        }, (String)this.person1.getId(), (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                JSONObject activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                return null;
            }
        }, (String)this.person2.getId(), (String)this.network1.getId());
        this.testSite2 = (RepoService.TestSite)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<RepoService.TestSite>(){

            public RepoService.TestSite execute() throws Throwable {
                return (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                    public RepoService.TestSite doWork() throws Exception {
                        RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(GUID.generate(), "", "", SiteVisibility.PUBLIC);
                        return TestActivities.this.network2.createSite(siteInfo);
                    }
                }, (String)TestActivities.this.person3.getId(), (String)TestActivities.this.network2.getId());
            }
        }, false, true);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                JSONObject activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite.getSiteId(), activityData);
                return null;
            }
        }, (String)this.person3.getId(), (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                JSONObject activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite2.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite2.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite2.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite2.getSiteId(), activityData);
                activityData = new JSONObject();
                activityData.put((Object)"title", (Object)GUID.generate());
                activityData.put((Object)"nodeRef", (Object)TestActivities.this.testSite2.getContainerNodeRef("documentLibrary").toString());
                TestActivities.this.repoService.postActivity("org.alfresco.documentlibrary.file-added", TestActivities.this.testSite2.getSiteId(), activityData);
                return null;
            }
        }, (String)this.person3.getId(), (String)this.network2.getId());
        this.testSite3 = (RepoService.TestSite)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<RepoService.TestSite>(){

            public RepoService.TestSite execute() throws Throwable {
                return (RepoService.TestSite)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<RepoService.TestSite>(){

                    public RepoService.TestSite doWork() throws Exception {
                        RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(GUID.generate(), "", "", SiteVisibility.PUBLIC);
                        return TestActivities.this.defaultNetwork.createSite(siteInfo);
                    }
                }, (String)TestActivities.this.person4.getId(), (String)TestActivities.this.defaultNetwork.getId());
            }
        }, false, true);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestActivities.this.siteService.setMembership(TestActivities.this.testSite3.getSiteId(), TestActivities.this.person5.getId(), "SiteConsumer");
                return null;
            }
        }, (String)this.person4.getId(), (String)this.defaultNetwork.getId());
        this.repoService.generateFeed();
    }

    @Test
    public void testPersonActivities() throws Exception {
        Map<String, String> params;
        int maxItems;
        PublicApiClient.People peopleProxy = this.publicApiClient.people();
        List expectedActivities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

            public List<Activity> doWork() throws Exception {
                List<Activity> activities = TestActivities.this.repoService.getActivities(TestActivities.this.person5.getId(), null, false, true);
                return activities;
            }
        }, (String)this.person5.getId(), (String)this.defaultNetwork.getId());
        for (Activity activity : expectedActivities) {
            if (activity.getSiteId() != null) continue;
            Assert.fail((String)"SiteId should present in user-joined activity.");
        }
        int skipCount = 0;
        int maxItems2 = expectedActivities.size();
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
        Map<String, String> params2 = this.createParams(paging, null);
        params2.put("who", String.valueOf(Activities.ActivityWho.me));
        this.publicApiClient.setRequestContext(new RequestContext(this.defaultNetwork.getId(), this.person5.getId()));
        PublicApiClient.ListResponse<Activity> response = peopleProxy.getActivities(this.person5.getId(), params2);
        this.checkList(expectedActivities.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), response);
        expectedActivities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

            public List<Activity> doWork() throws Exception {
                List<Activity> activities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), null, false, true);
                return activities;
            }
        }, (String)this.person1.getId(), (String)this.network1.getId());
        skipCount = 0;
        maxItems2 = 2;
        paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
        params2 = this.createParams(paging, null);
        params2.put("who", String.valueOf(Activities.ActivityWho.me));
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
        response = peopleProxy.getActivities(this.person1.getId(), params2);
        this.checkList(expectedActivities.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), response);
        skipCount = 2;
        maxItems2 = expectedActivities.size() - 2;
        Assert.assertTrue((maxItems2 > 0 ? 1 : 0) != 0);
        paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
        params2 = this.createParams(paging, null);
        params2.put("who", String.valueOf(Activities.ActivityWho.me));
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
        response = peopleProxy.getActivities(this.person1.getId(), params2);
        this.checkList(expectedActivities.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), response);
        skipCount = 0;
        maxItems2 = 2;
        paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
        params2 = this.createParams(paging, null);
        params2.put("who", String.valueOf(Activities.ActivityWho.me));
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
        response = peopleProxy.getActivities("-me-", params2);
        this.checkList(expectedActivities.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), response);
        try {
            expectedActivities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

                public List<Activity> doWork() throws Exception {
                    List<Activity> activities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), null, false, true);
                    return activities;
                }
            }, (String)this.person1.getId(), (String)this.network1.getId());
            skipCount = 0;
            maxItems2 = 2;
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
            peopleProxy.getActivities(GUID.generate(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            expectedActivities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

                public List<Activity> doWork() throws Exception {
                    List<Activity> activities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), null, false, true);
                    return activities;
                }
            }, (String)this.person1.getId(), (String)this.network1.getId());
            skipCount = 0;
            maxItems2 = 2;
            paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
            params2 = this.createParams(paging, null);
            params2.put("siteId", GUID.generate());
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.getActivities(GUID.generate(), params2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            expectedActivities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

                public List<Activity> doWork() throws Exception {
                    List<Activity> activities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), null, false, true);
                    return activities;
                }
            }, (String)this.person1.getId(), (String)this.network1.getId());
            skipCount = 0;
            maxItems2 = 2;
            paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person3.getId()));
            peopleProxy.getActivities(this.person1.getId(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            expectedActivities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

                public List<Activity> doWork() throws Exception {
                    List<Activity> activities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), null, false, true);
                    return activities;
                }
            }, (String)this.person1.getId(), (String)this.network1.getId());
            skipCount = 0;
            maxItems2 = 2;
            paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person2.getId()));
            peopleProxy.getActivities(this.person1.getId(), this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            List activities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

                public List<Activity> doWork() throws Exception {
                    List<Activity> activities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), null, false, true);
                    return activities;
                }
            }, (String)this.person1.getId(), (String)this.network1.getId());
            Assert.assertTrue((activities.size() > 0 ? 1 : 0) != 0);
            Activity activity = (Activity)activities.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.remove("people", this.person1.getId(), "activities", String.valueOf(activity.getId()), "Unable to DELETE a person activity");
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        expectedActivities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

            public List<Activity> doWork() throws Exception {
                List<Activity> expectedActivities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), null, true, false);
                return expectedActivities;
            }
        }, (String)this.person1.getId(), (String)this.network1.getId());
        skipCount = 0;
        maxItems2 = 2;
        paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
        params2 = this.createParams(paging, null);
        params2.put("who", String.valueOf(Activities.ActivityWho.others));
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
        response = peopleProxy.getActivities(this.person1.getId(), params2);
        this.checkList(expectedActivities.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), response);
        expectedActivities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

            public List<Activity> doWork() throws Exception {
                List<Activity> expectedActivities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), TestActivities.this.testSite.getSiteId(), false, false);
                return expectedActivities;
            }
        }, (String)this.person1.getId(), (String)this.network1.getId());
        skipCount = 0;
        maxItems2 = 2;
        paging = this.getPaging(skipCount, maxItems2, expectedActivities.size(), null);
        params2 = this.createParams(paging, null);
        params2.put("siteId", this.testSite.getSiteId());
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
        response = peopleProxy.getActivities(this.person1.getId(), params2);
        this.checkList(expectedActivities.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), response);
        try {
            int skipCount2 = 0;
            maxItems = 2;
            PublicApiClient.Paging paging2 = this.getPaging(skipCount2, maxItems);
            params = this.createParams(paging2, null);
            params.put("siteId", GUID.generate());
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.getActivities(this.person1.getId(), params);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount3 = 0;
            maxItems = 2;
            PublicApiClient.Paging paging3 = this.getPaging(skipCount3, maxItems);
            params = this.createParams(paging3, null);
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.getActivities(GUID.generate(), params);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            int skipCount4 = 0;
            maxItems = 2;
            PublicApiClient.Paging paging4 = this.getPaging(skipCount4, maxItems);
            params = this.createParams(paging4, null);
            params.put("who", GUID.generate());
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.getActivities(this.person1.getId(), params);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        List activities = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Activity>>(){

            public List<Activity> doWork() throws Exception {
                List<Activity> activities = TestActivities.this.repoService.getActivities(TestActivities.this.person1.getId(), null, false, false);
                return activities;
            }
        }, (String)this.person1.getId(), (String)this.network1.getId());
        Assert.assertTrue((activities.size() > 0 ? 1 : 0) != 0);
        Activity activity = (Activity)activities.get(0);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.create("people", this.person1.getId(), "activities", null, null, "Unable to POST to activities");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.create("people", this.person1.getId(), "activities", String.valueOf(activity.getId()), null, "Unable to POST to an activity");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.update("people", this.person1.getId(), "activities", null, null, "Unable to PUT activities");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.update("people", this.person1.getId(), "activities", String.valueOf(activity.getId()), null, "Unable to PUT an activity");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.remove("people", this.person1.getId(), "activities", null, "Unable to DELETE activities");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person1.getId()));
            peopleProxy.remove("people", this.person1.getId(), "activities", String.valueOf(activity.getId()), "Unable to DELETE an activity");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testPUBLICAPI23() throws Exception {
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestActivities.this.testSite.updateMember(TestActivities.this.person2.getId(), SiteRole.SiteConsumer);
                TestActivities.this.testSite.removeMember(TestActivities.this.person2.getId());
                return null;
            }
        }, (String)this.person1.getId(), (String)this.network1.getId());
        this.repoService.generateFeed();
        PublicApiClient.People peopleProxy = this.publicApiClient.people();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person2.getId()));
        int skipCount = 0;
        int maxItems = 10;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<Activity> activities = peopleProxy.getActivities(this.person2.getId(), this.createParams(paging, null));
        for (Activity activity : activities.getList()) {
            String activityType = activity.getActivityType();
            if (!activityType.equals("org.alfresco.site.user-left")) continue;
            String role = (String)activity.getSummary().get("role");
            String feedPersonId = activity.getFeedPersonId();
            if (!feedPersonId.equals(this.person2.getId())) continue;
            Assert.assertTrue((role == null ? 1 : 0) != 0);
            break;
        }
    }
}

