/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.Person;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Comment
implements Serializable,
ExpectedComparison,
Comparable<Comment> {
    private static final long serialVersionUID = -1804591941972808543L;
    private String nodeId;
    private String id;
    private String title;
    private String content;
    private Boolean edited;
    private Person createdBy;
    private String createdAt;
    private String modifiedAt;
    private Person modifiedBy;
    private Boolean updated;

    public Comment() {
    }

    public Comment(Comment c) {
        this(c.getNodeId(), c.getId(), c.getTitle(), c.getContent(), c.getCreatedBy(), c.getCreatedAt(), c.getModifiedBy(), c.getModifiedAt(), c.getUpdated(), c.getEdited());
    }

    public Comment(String title, String content, Boolean edited, Boolean updated, Person createdBy, Person modifiedBy) {
        this.title = title;
        this.content = content;
        this.edited = edited;
        this.updated = updated;
        this.createdBy = createdBy;
        this.modifiedBy = modifiedBy;
        DateFormat format = PublicApiDateFormat.getDateFormat();
        this.createdAt = format.format(new Date());
        this.modifiedAt = format.format(new Date());
    }

    public Comment(String title, String content) {
        this.title = title;
        this.content = content;
    }

    public Comment(String nodeId, String id, String title, String content, Person createdBy, String createdAt, Person modifiedBy, String modifiedAt, Boolean updated, Boolean edited) {
        this.nodeId = nodeId;
        this.id = id;
        this.title = title;
        this.content = content;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.modifiedBy = modifiedBy;
        this.modifiedAt = modifiedAt;
        this.updated = updated;
        this.edited = edited;
    }

    public Boolean getEdited() {
        return this.edited;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getContent() {
        return this.content;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Person getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(Person createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(String modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public Person getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(Person modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Boolean getUpdated() {
        return this.updated;
    }

    public void setUpdated(Boolean updated) {
        this.updated = updated;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Boolean isEdited() {
        return this.edited;
    }

    public void setEdited(Boolean edited) {
        this.edited = edited;
    }

    public JSONObject toJSON(boolean createdByVisibility) {
        JSONObject commentJson = new JSONObject();
        commentJson.put((Object)"title", (Object)this.getTitle());
        commentJson.put((Object)"content", (Object)this.getContent());
        return commentJson;
    }

    public String toString() {
        return "Comment [nodeId=" + this.nodeId + ", id=" + this.id + ", title=" + this.title + ", content=" + this.content + ", createdBy=" + String.valueOf(this.createdBy) + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", modifiedBy=" + String.valueOf(this.modifiedBy) + ", updated=" + this.updated + "]";
    }

    public static Comment parseComment(String nodeId, JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String title = (String)jsonObject.get((Object)"title");
        String content = (String)jsonObject.get((Object)"content");
        JSONObject createdByJson = (JSONObject)jsonObject.get((Object)"createdBy");
        Person createdBy = null;
        if (createdByJson != null) {
            createdBy = Person.parsePerson(createdByJson);
        }
        String createdAt = (String)jsonObject.get((Object)"createdAt");
        JSONObject modifiedByJson = (JSONObject)jsonObject.get((Object)"modifiedBy");
        Person modifiedBy = null;
        if (modifiedByJson != null) {
            modifiedBy = Person.parsePerson(modifiedByJson);
        }
        String modifiedAt = (String)jsonObject.get((Object)"modifiedAt");
        Boolean edited = (Boolean)jsonObject.get((Object)"edited");
        Boolean updated = (Boolean)jsonObject.get((Object)"updated");
        Comment comment = new Comment(nodeId, id, title, content, createdBy, createdAt, modifiedBy, modifiedAt, updated, edited);
        return comment;
    }

    public static PublicApiClient.ListResponse<Comment> parseComments(String nodeId, JSONObject jsonObject) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            comments.add(Comment.parseComment(nodeId, entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        return new PublicApiClient.ListResponse<Comment>(paging, comments);
    }

    @Override
    public void expected(Object o) {
        String createdAtStr;
        String modifiedAtStr;
        Assert.assertTrue((boolean)(o instanceof Comment));
        Comment other = (Comment)o;
        AssertUtil.assertEquals("content", this.content, other.getContent());
        AssertUtil.assertEquals("id", this.id, other.getId());
        AssertUtil.assertEquals("title", this.title, other.getTitle());
        AssertUtil.assertEquals("edited", this.edited, other.isEdited());
        if (this.createdBy != null) {
            this.createdBy.expected(other.getCreatedBy());
        }
        if ((modifiedAtStr = this.getModifiedAt()) != null) {
            try {
                Date modifiedAt = PublicApiDateFormat.getDateFormat().parse(modifiedAtStr);
                Date otherModifiedAt = PublicApiDateFormat.getDateFormat().parse(other.getModifiedAt());
                Assert.assertTrue((otherModifiedAt.after(modifiedAt) || otherModifiedAt.equals(modifiedAt) ? 1 : 0) != 0);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if ((createdAtStr = this.getCreatedAt()) != null) {
            try {
                Date createdAt = PublicApiDateFormat.getDateFormat().parse(createdAtStr);
                Date otherCreatedAt = PublicApiDateFormat.getDateFormat().parse(other.getCreatedAt());
                Assert.assertTrue((otherCreatedAt.after(createdAt) || otherCreatedAt.equals(createdAt) ? 1 : 0) != 0);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.modifiedBy != null) {
            this.modifiedBy.expected(other.getModifiedBy());
        }
        AssertUtil.assertEquals("updated", this.updated, other.getUpdated());
    }

    @Override
    public int compareTo(Comment o) {
        return o.getCreatedAt().compareTo(this.createdAt);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Comment other = (Comment)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

