/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.jacksonextensions;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.alfresco.rest.framework.resource.SerializablePagedCollection;

public class SerializerOfCollectionWithPaging
extends StdSerializer<SerializablePagedCollection> {
    protected SerializerOfCollectionWithPaging() {
        super(SerializablePagedCollection.class);
    }

    public void serialize(SerializablePagedCollection pagedCol, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (pagedCol != null) {
            jgen.writeStartObject();
            jgen.writeFieldName("list");
            jgen.writeStartObject();
            this.serializePagination(pagedCol, jgen);
            this.serializeContext(pagedCol, jgen);
            jgen.writeObjectField("entries", pagedCol.getCollection());
            this.serializeIncludedSource(pagedCol, jgen);
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    private void serializeIncludedSource(SerializablePagedCollection pagedCol, JsonGenerator jgen) throws IOException, JsonProcessingException {
        if (pagedCol.getSourceEntity() != null) {
            jgen.writeObjectField("source", pagedCol.getSourceEntity());
        }
    }

    private void serializeContext(SerializablePagedCollection pagedCol, JsonGenerator jgen) throws IOException, JsonProcessingException {
        if (pagedCol.getContext() != null) {
            jgen.writeObjectField("context", (Object)pagedCol.getContext());
        }
    }

    private void serializePagination(SerializablePagedCollection pagedCol, JsonGenerator jgen) throws IOException, JsonProcessingException {
        jgen.writeFieldName("pagination");
        jgen.writeStartObject();
        jgen.writeNumberField("count", pagedCol.getCollection().size());
        jgen.writeBooleanField("hasMoreItems", pagedCol.hasMoreItems());
        Integer totalItems = pagedCol.getTotalItems();
        if (totalItems != null) {
            jgen.writeNumberField("totalItems", totalItems.intValue());
        }
        if (pagedCol.getPaging() != null) {
            jgen.writeNumberField("skipCount", pagedCol.getPaging().getSkipCount());
            jgen.writeNumberField("maxItems", pagedCol.getPaging().getMaxItems());
        }
        jgen.writeEndObject();
    }
}

