/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.model.AuditModelRegistryImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.GetMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={LuceneTests.class})
public class GetMethodRegressionTest
extends TestCase {
    private static final int DOCUMENTS_AMOUNT_FOR_GET_METHOD_TEST = 25;
    private static final String HTTP_METHOD_GET = "GET";
    private static final String TEST_ENCODING = "UTF-8";
    private static final String TEST_MIMETYPE = "text/plain";
    private static final String TEST_WEBDAV_URL_PREFIX = "/";
    private static final String AUDIT_REGISTRY_BEAN_NAME = "Audit";
    private static final String PROP_AUDIT_ALFRESCO_ACCESS_ENABLED = "audit.alfresco-access.enabled";
    private static final String ROOT_TEST_FOLDER_NAME = "TestFolder-" + System.currentTimeMillis();
    private static final String TEST_DOCUMENT_NAME_PATTERN = "TestDocument-%d-%d.pdf";
    private static final String TEXT_DOCUMENT_CONTENT_PATTERN = "Text content for '%s' document";
    private ApplicationContext applicationContext;
    private WebDAVHelper davHelper;
    private AuditService auditService;
    private FileFolderService fileFolderService;
    private AuditModelRegistryImpl auditRegistry;
    private TransactionService transactionService;
    private UserTransaction transaction;
    private GetMethod testingMethod;
    private NodeRef companyHomeNodeRef;
    private NodeRef rootTestFolder;
    private MockHttpServletResponse mockResponse;

    @Before
    public void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        ServiceRegistry registry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.davHelper = (WebDAVHelper)this.applicationContext.getBean("webDAVHelper");
        this.auditRegistry = (AuditModelRegistryImpl)this.applicationContext.getBean(AUDIT_REGISTRY_BEAN_NAME);
        this.auditService = registry.getAuditService();
        this.fileFolderService = registry.getFileFolderService();
        this.transactionService = registry.getTransactionService();
        this.testingMethod = new GetMethod();
        this.mockResponse = new MockHttpServletResponse();
        this.restartTransaction(TransactionActionEnum.ACTION_NONE);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.companyHomeNodeRef = registry.getNodeLocatorService().getNode("companyhome", null, null);
        this.rootTestFolder = this.fileFolderService.create(this.companyHomeNodeRef, ROOT_TEST_FOLDER_NAME, ContentModel.TYPE_FOLDER).getNodeRef();
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.transaction && 4 != this.transaction.getStatus() && 3 != this.transaction.getStatus()) {
            this.transaction.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditRecordsAdditionAsbsence() throws Exception {
        boolean alfrescoAccessEnabled;
        String url = TEST_WEBDAV_URL_PREFIX + ROOT_TEST_FOLDER_NAME;
        MockHttpServletRequest mockRequest = new MockHttpServletRequest(HTTP_METHOD_GET, url);
        this.testingMethod.setDetails((HttpServletRequest)mockRequest, (HttpServletResponse)this.mockResponse, this.davHelper, this.companyHomeNodeRef);
        boolean auditEnabled = this.auditService.isAuditEnabled();
        if (!auditEnabled) {
            this.auditService.setAuditEnabled(true);
        }
        if (!(alfrescoAccessEnabled = Boolean.valueOf(this.auditRegistry.getProperty(PROP_AUDIT_ALFRESCO_ACCESS_ENABLED)).booleanValue())) {
            this.setAuditRegistryProperty(PROP_AUDIT_ALFRESCO_ACCESS_ENABLED, Boolean.TRUE.toString());
        }
        try {
            this.createTestContent(this.rootTestFolder, 25);
            this.restartTransaction(TransactionActionEnum.ACTION_COMMIT);
            Long expectedLastTime = this.getLastAuditRecordTime();
            this.testingMethod.executeImpl();
            GetMethodRegressionTest.assertEquals((int)200, (int)this.mockResponse.getStatus());
            String contentAsString = this.mockResponse.getContentAsString();
            GetMethodRegressionTest.assertNotNull((String)"WebDAV 'GET' method response is empty!", (Object)contentAsString);
            GetMethodRegressionTest.assertTrue((boolean)contentAsString.contains(ROOT_TEST_FOLDER_NAME));
            this.restartTransaction(TransactionActionEnum.ACTION_COMMIT);
            Long actualLastTime = this.getLastAuditRecordTime();
            if (null == expectedLastTime) {
                GetMethodRegressionTest.assertNull((String)"Audit entry table is not empty after 'GetMethod.executeImpl()' invocation. But it is expected to be empty!", (Object)actualLastTime);
            } else {
                GetMethodRegressionTest.assertEquals((Object)expectedLastTime, (Object)actualLastTime);
            }
        }
        finally {
            if (!alfrescoAccessEnabled) {
                this.setAuditRegistryProperty(PROP_AUDIT_ALFRESCO_ACCESS_ENABLED, Boolean.FALSE.toString());
            }
            if (!auditEnabled) {
                this.auditService.setAuditEnabled(false);
            }
        }
    }

    private void setAuditRegistryProperty(String propertyName, String value) {
        GetMethodRegressionTest.assertTrue((String)("'" + propertyName + "' is not updatable!"), (boolean)this.auditRegistry.isUpdateable(propertyName));
        this.auditRegistry.stop();
        this.auditRegistry.setProperty(propertyName, value);
        this.auditRegistry.start();
    }

    private void createTestContent(NodeRef parentNode, int documentsAmount) {
        for (int i = 0; i < documentsAmount; ++i) {
            String testDocumentName = String.format(TEST_DOCUMENT_NAME_PATTERN, i, System.currentTimeMillis());
            FileInfo testDocument = this.fileFolderService.create(parentNode, testDocumentName, ContentModel.TYPE_CONTENT);
            ContentWriter writer = this.fileFolderService.getWriter(testDocument.getNodeRef());
            writer.putContent(String.format(TEXT_DOCUMENT_CONTENT_PATTERN, testDocumentName));
            writer.setMimetype(TEST_MIMETYPE);
            writer.setEncoding(TEST_ENCODING);
        }
    }

    private void restartTransaction(TransactionActionEnum transactionAction) throws Exception {
        if (null != this.transaction && 4 != this.transaction.getStatus() && 3 != this.transaction.getStatus()) {
            if (TransactionActionEnum.ACTION_COMMIT == transactionAction) {
                this.transaction.commit();
            } else if (TransactionActionEnum.ACTION_ROLLBACK == transactionAction) {
                this.transaction.rollback();
            }
        }
        this.transaction = this.transactionService.getUserTransaction();
        this.transaction.begin();
    }

    private Long getLastAuditRecordTime() {
        final Holder lastTime = new Holder();
        AuditQueryParameters parameters = new AuditQueryParameters();
        parameters.setForward(false);
        this.auditService.auditQuery(new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return false;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                return false;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                lastTime.setValue((Object)time);
                return false;
            }
        }, parameters, 1);
        return (Long)lastTime.getValue();
    }

    private static enum TransactionActionEnum {
        ACTION_NONE,
        ACTION_COMMIT,
        ACTION_ROLLBACK;

    }
}

