/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import java.util.Map;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.ResourceDictionaryBuilder;
import org.alfresco.rest.framework.core.ResourceLocator;
import org.alfresco.rest.framework.core.ResourceLookupDictionary;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.AbstractResourceWebScript;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptHelper;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.transaction.TransactionService;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:test-rest-context.xml"})
public abstract class AbstractContextTest {
    @Autowired
    ResourceLookupDictionary locator;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    ResourceWebScriptHelper helper;
    @Autowired
    JacksonHelper jsonHelper;
    @Autowired
    ApiAssistant apiAssistant;
    static Params NOT_USED = Params.valueOf((String)"notUsed", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class)));
    static final Params.RecognizedParams NULL_PARAMS = new Params.RecognizedParams(null, null, null, null, null, null, null, null, false);
    static final WithResponse callBack = new WithResponse(200, ResponseWriter.DEFAULT_JSON_CONTENT, ResponseWriter.CACHE_NEVER);
    static Api api = Api.valueOf((String)"alfrescomock", (String)"private", (String)"1");

    @Before
    public void setUp() throws Exception {
        Map entityResourceBeans = this.applicationContext.getBeansWithAnnotation(EntityResource.class);
        Map relationResourceBeans = this.applicationContext.getBeansWithAnnotation(RelationshipResource.class);
        this.locator.setDictionary(ResourceDictionaryBuilder.build(entityResourceBeans.values(), relationResourceBeans.values()));
        AbstractResourceWebScript executor = (AbstractResourceWebScript)this.applicationContext.getBean("executorOfGets");
        AbstractResourceWebScript postExecutor = (AbstractResourceWebScript)this.applicationContext.getBean("executorOfPost");
        AbstractResourceWebScript putExecutor = (AbstractResourceWebScript)this.applicationContext.getBean("executorOfPut");
        AbstractResourceWebScript deleteExecutor = (AbstractResourceWebScript)this.applicationContext.getBean("executorOfDelete");
        TransactionService transerv = (TransactionService)Mockito.mock(TransactionService.class);
        RetryingTransactionHelper tHelper = (RetryingTransactionHelper)Mockito.mock(RetryingTransactionHelper.class);
        Mockito.when((Object)transerv.getRetryingTransactionHelper()).thenReturn((Object)tHelper);
        Mockito.when((Object)tHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)ArgumentMatchers.any(RetryingTransactionHelper.RetryingTransactionCallback.class), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                RetryingTransactionHelper.RetryingTransactionCallback cb = (RetryingTransactionHelper.RetryingTransactionCallback)args[0];
                return cb.execute();
            }
        });
        executor.setTransactionService(transerv);
        postExecutor.setTransactionService(transerv);
        putExecutor.setTransactionService(transerv);
        deleteExecutor.setTransactionService(transerv);
    }

    protected AbstractResourceWebScript getExecutor() {
        return this.getExecutor("executorOfGets");
    }

    protected AbstractResourceWebScript getExecutor(String beanName) {
        AbstractResourceWebScript executor = (AbstractResourceWebScript)this.applicationContext.getBean(beanName);
        executor.setLocator((ResourceLocator)this.locator);
        executor.setAssistant(this.apiAssistant);
        return executor;
    }
}

