/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.StoreArchiveMap;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class NodeArchiveServiceRestApiTest
extends BaseWebScriptTest {
    private static final String DATA = "data";
    private static final String ARCHIVE_URL_FORMAT = "/api/archive/{0}/{1}";
    private static final String TEST_TITLE = "FooBarTitle";
    private static final String TEST_DESCRIPTION = "This is a FooBar description";
    private static final String USER_ONE = "UserOne";
    private static final String USER_TWO = "UserTwo";
    private NodeRef adminUndeletedTestNode;
    private NodeRef adminDeletedTestNode;
    private NodeRef user1_DeletedTestNode;
    private NodeRef user2_DeletedTestNode;
    private NodeRef workStoreRootNodeRef;
    private NodeService nodeService;
    private NodeArchiveService nodeArchiveService;
    private RetryingTransactionHelper transactionHelper;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private StoreArchiveMap archiveMap;
    private StoreRef nodesOriginalStoreRef;
    private List<StoreRef> createdStores = new ArrayList<StoreRef>();
    private List<NodeRef> createdNodes = new ArrayList<NodeRef>();
    private List<String> createdPeople = new ArrayList<String>(2);

    protected void setUp() throws Exception {
        super.setUp();
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.nodeArchiveService = (NodeArchiveService)this.getServer().getApplicationContext().getBean("nodeArchiveService");
        this.transactionHelper = (RetryingTransactionHelper)this.getServer().getApplicationContext().getBean("retryingTransactionHelper");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.archiveMap = (StoreArchiveMap)this.getServer().getApplicationContext().getBean("storeArchiveMap");
        this.workStoreRootNodeRef = this.createTestStoreAndGetRootNode();
        this.createUser(USER_ONE);
        this.createUser(USER_TWO);
        this.adminUndeletedTestNode = this.createTestNode(AuthenticationUtil.getAdminUserName(), this.createNodeName(), false);
        this.createdNodes.add(this.adminUndeletedTestNode);
        this.nodesOriginalStoreRef = this.adminUndeletedTestNode.getStoreRef();
        this.adminDeletedTestNode = this.createTestNode(AuthenticationUtil.getAdminUserName(), this.createNodeName(), true);
        this.createdNodes.add(this.adminDeletedTestNode);
        this.user1_DeletedTestNode = this.createTestNode(USER_ONE, this.createNodeName(), true);
        this.createdNodes.add(this.user1_DeletedTestNode);
        this.user2_DeletedTestNode = this.createTestNode(USER_TWO, this.createNodeName(), true);
        this.createdNodes.add(this.user2_DeletedTestNode);
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        super.tearDown();
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        for (NodeRef nodeRef : NodeArchiveServiceRestApiTest.this.createdNodes) {
                            if (nodeRef == null || !NodeArchiveServiceRestApiTest.this.nodeService.exists(nodeRef)) continue;
                            NodeArchiveServiceRestApiTest.this.nodeService.deleteNode(nodeRef);
                        }
                        for (StoreRef store : NodeArchiveServiceRestApiTest.this.createdStores) {
                            if (store == null || !NodeArchiveServiceRestApiTest.this.nodeService.exists(store)) continue;
                            NodeArchiveServiceRestApiTest.this.nodeService.deleteStore(store);
                        }
                        return null;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                return null;
            }
        });
        for (String userName : this.createdPeople) {
            this.personService.deletePerson(userName);
        }
        this.createdPeople.clear();
        this.createdNodes.clear();
        this.createdStores.clear();
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testGetDeletedItems() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        JSONObject jsonRsp = this.getArchivedNodes();
        JSONObject dataObj = (JSONObject)jsonRsp.get(DATA);
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONArray deletedNodesArray = (JSONArray)dataObj.get("deletedNodes");
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'deletedNodesArray' object was null", (Object)deletedNodesArray);
        NodeArchiveServiceRestApiTest.assertTrue((String)"Unexpectedly found 0 items in archive store", (0 != deletedNodesArray.length() ? 1 : 0) != 0);
        for (int i = 0; i < deletedNodesArray.length(); ++i) {
            JSONObject nextJSONObj = (JSONObject)deletedNodesArray.get(i);
            String nodeRefString = nextJSONObj.getString("nodeRef");
            if (nodeRefString.equals(this.adminDeletedTestNode.toString())) {
                this.doTest(nextJSONObj, AuthenticationUtil.getAdminUserName());
                continue;
            }
            if (nodeRefString.equals(this.user1_DeletedTestNode.toString())) {
                this.doTest(nextJSONObj, USER_ONE);
                continue;
            }
            if (!nodeRefString.equals(this.user2_DeletedTestNode.toString())) continue;
            this.doTest(nextJSONObj, USER_TWO);
        }
        Date previousDate = null;
        for (int i = 0; i < deletedNodesArray.length(); ++i) {
            JSONObject nextJSONObj = deletedNodesArray.getJSONObject(i);
            String nextArchivedDateString = nextJSONObj.getString("archivedDate");
            Date nextArchivedDate = new DateTime((Object)nextArchivedDateString).toDate();
            if (previousDate != null) {
                NodeArchiveServiceRestApiTest.assertTrue((String)"Archived Dates were not reverse-sorted.", (boolean)nextArchivedDate.before(previousDate));
            }
            previousDate = nextArchivedDate;
        }
    }

    private void doTest(JSONObject deletedNodeToTest, String archivedBy) throws Exception {
        NodeArchiveServiceRestApiTest.assertNotNull((String)"Failed to find an expected NodeRef within the archive store.", (Object)deletedNodeToTest);
        NodeArchiveServiceRestApiTest.assertEquals((String)archivedBy, (String)deletedNodeToTest.getString("archivedBy"));
        NodeArchiveServiceRestApiTest.assertEquals((String)TEST_TITLE, (String)deletedNodeToTest.getString("title"));
        NodeArchiveServiceRestApiTest.assertEquals((String)TEST_DESCRIPTION, (String)deletedNodeToTest.getString("description"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("name"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("nodeRef"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("displayPath"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("archivedDate"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("firstName"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("lastName"));
        NodeArchiveServiceRestApiTest.assertNotNull((Object)deletedNodeToTest.getString("nodeType"));
    }

    public void testGetDeletedItemsAsNonAdminUser() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        JSONObject jsonRsp = this.getArchivedNodes();
        JSONObject dataObj = (JSONObject)jsonRsp.get(DATA);
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        JSONArray deletedNodesArray = (JSONArray)dataObj.get("deletedNodes");
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'deletedNodesArray' object was null", (Object)deletedNodesArray);
        NodeArchiveServiceRestApiTest.assertTrue((String)"Unexpectedly found more than 1 item in the archive store.", (1 == deletedNodesArray.length() ? 1 : 0) != 0);
        JSONObject archivedNode = (JSONObject)deletedNodesArray.get(0);
        NodeArchiveServiceRestApiTest.assertEquals((String)USER_ONE, (String)archivedNode.getString("archivedBy"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        jsonRsp = this.getArchivedNodes();
        dataObj = (JSONObject)jsonRsp.get(DATA);
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        deletedNodesArray = (JSONArray)dataObj.get("deletedNodes");
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'deletedNodesArray' object was null", (Object)deletedNodesArray);
        NodeArchiveServiceRestApiTest.assertTrue((String)"Unexpectedly found more than 1 item in the archive store.", (1 == deletedNodesArray.length() ? 1 : 0) != 0);
        archivedNode = (JSONObject)deletedNodesArray.get(0);
        NodeArchiveServiceRestApiTest.assertEquals((String)USER_TWO, (String)archivedNode.getString("archivedBy"));
    }

    private JSONObject getArchivedNodes() throws IOException, JSONException, UnsupportedEncodingException {
        String url = this.getArchiveUrl(this.nodesOriginalStoreRef);
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        return jsonRsp;
    }

    public void testPurgeDeletedItems() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        JSONObject archivedNodesJson = this.getArchivedNodes();
        JSONObject dataJsonObj = archivedNodesJson.getJSONObject(DATA);
        JSONArray archivedNodesArray = dataJsonObj.getJSONArray("deletedNodes");
        int archivedNodesLength = archivedNodesArray.length();
        NodeArchiveServiceRestApiTest.assertTrue((String)"Insufficient archived nodes for test to run.", (archivedNodesLength > 1 ? 1 : 0) != 0);
        JSONObject requiredNodeInArchive = null;
        for (int i = 0; i < archivedNodesLength; ++i) {
            JSONObject archivedNode = archivedNodesArray.getJSONObject(i);
            if (archivedNode.getString("nodeRef").equals(this.adminDeletedTestNode.toString())) {
                requiredNodeInArchive = archivedNode;
                break;
            }
            if (archivedNode.getString("nodeRef").equals(this.user1_DeletedTestNode.toString())) {
                requiredNodeInArchive = archivedNode;
                break;
            }
            if (!archivedNode.getString("nodeRef").equals(this.user2_DeletedTestNode.toString())) continue;
            requiredNodeInArchive = archivedNode;
            break;
        }
        NodeArchiveServiceRestApiTest.assertNotNull((String)"Expected node not found in archive", requiredNodeInArchive);
        String nodeRefString = requiredNodeInArchive.getString("nodeRef");
        NodeArchiveServiceRestApiTest.assertTrue((String)"nodeRef string is invalid", (boolean)NodeRef.isNodeRef((String)nodeRefString));
        NodeRef nodeRef = new NodeRef(nodeRefString);
        StoreRef currentStoreRef = nodeRef.getStoreRef();
        String deleteUrl = this.getArchiveUrl(currentStoreRef) + "/" + nodeRef.getId();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(deleteUrl), 200);
        JSONObject jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        JSONObject dataObj = jsonRsp.getJSONObject(DATA);
        JSONArray purgedNodesArray = dataObj.getJSONArray("purgedNodes");
        NodeArchiveServiceRestApiTest.assertEquals((String)"Only expected one NodeRef to have been purged.", (int)1, (int)purgedNodesArray.length());
        String deleteAllUrl = this.getArchiveUrl(this.nodesOriginalStoreRef);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(deleteAllUrl), 200);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        dataObj = jsonRsp.getJSONObject(DATA);
        purgedNodesArray = dataObj.getJSONArray("purgedNodes");
        NodeArchiveServiceRestApiTest.assertEquals((String)"Archive store was unexpectedly not empty", (int)0, (int)this.getArchivedNodesCount());
    }

    public void testPurgeDeletedItemsAsNonAdminUser() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        String deleteUrl = this.getArchiveUrl(this.user2_DeletedTestNode.getStoreRef()) + "/" + this.user2_DeletedTestNode.getId();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(deleteUrl), 403);
        NodeArchiveServiceRestApiTest.assertEquals((int)403, (int)rsp.getStatus());
        JSONObject jsonRsp = this.getArchivedNodes();
        JSONObject dataObj = (JSONObject)jsonRsp.get(DATA);
        JSONArray deletedNodesArray = (JSONArray)dataObj.get("deletedNodes");
        NodeArchiveServiceRestApiTest.assertEquals((String)"Unexpectedly found more than 1 item in the archive store.", (int)1, (int)deletedNodesArray.length());
        JSONObject archivedNode = (JSONObject)deletedNodesArray.get(0);
        String nodeRefString = archivedNode.getString("nodeRef");
        NodeArchiveServiceRestApiTest.assertTrue((String)"nodeRef string is invalid", (boolean)NodeRef.isNodeRef((String)nodeRefString));
        NodeRef nodeRef = new NodeRef(nodeRefString);
        deleteUrl = this.getArchiveUrl(nodeRef.getStoreRef()) + "/" + nodeRef.getId();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(deleteUrl), 200);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        dataObj = jsonRsp.getJSONObject(DATA);
        JSONArray purgedNodesArray = dataObj.getJSONArray("purgedNodes");
        NodeArchiveServiceRestApiTest.assertEquals((String)"Only expected one NodeRef to have been purged.", (int)1, (int)purgedNodesArray.length());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        String deleteAllUrl = this.getArchiveUrl(this.nodesOriginalStoreRef);
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(deleteAllUrl), 200);
        jsonRsp = new JSONObject(new JSONTokener(rsp.getContentAsString()));
        dataObj = jsonRsp.getJSONObject(DATA);
        purgedNodesArray = dataObj.getJSONArray("purgedNodes");
        NodeArchiveServiceRestApiTest.assertEquals((String)"Only expected one NodeRef to have been purged.", (int)1, (int)purgedNodesArray.length());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        jsonRsp = this.getArchivedNodes();
        dataObj = (JSONObject)jsonRsp.get(DATA);
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'data' object was null", (Object)dataObj);
        deletedNodesArray = (JSONArray)dataObj.get("deletedNodes");
        NodeArchiveServiceRestApiTest.assertNotNull((String)"JSON 'deletedNodesArray' object was null", (Object)deletedNodesArray);
        NodeArchiveServiceRestApiTest.assertEquals((String)"There is 1 item in the archive store which was deleted by the Admin.", (int)1, (int)deletedNodesArray.length());
    }

    private int getArchivedNodesCount() throws IOException, JSONException, UnsupportedEncodingException {
        JSONObject archiveContents = this.getArchivedNodes();
        JSONObject datatObject = archiveContents.getJSONObject(DATA);
        JSONArray deletedNodesArray = datatObject.getJSONArray("deletedNodes");
        return deletedNodesArray.length();
    }

    public void testRestoreDeletedItems() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        JSONObject archivedNodesJson = this.getArchivedNodes();
        JSONObject dataJsonObj = archivedNodesJson.getJSONObject(DATA);
        JSONArray archivedNodesArray = dataJsonObj.getJSONArray("deletedNodes");
        int archivedNodesLength = archivedNodesArray.length();
        NodeArchiveServiceRestApiTest.assertTrue((String)"Insufficient archived nodes for test to run.", (archivedNodesLength > 1 ? 1 : 0) != 0);
        JSONObject firstArchivedNode = archivedNodesArray.getJSONObject(0);
        String nodeRefString = firstArchivedNode.getString("nodeRef");
        NodeArchiveServiceRestApiTest.assertTrue((String)"nodeRef string is invalid", (boolean)NodeRef.isNodeRef((String)nodeRefString));
        NodeRef nodeRef = new NodeRef(nodeRefString);
        StoreRef currentStoreRef = nodeRef.getStoreRef();
        String restoreUrl = this.getArchiveUrl(currentStoreRef) + "/" + nodeRef.getId();
        int archivedNodesCountBeforeRestore = this.getArchivedNodesCount();
        String jsonString = new JSONStringer().object().key("restoreLocation").value((Object)"").endObject().toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(restoreUrl, jsonString, "application/json"), 200);
        NodeArchiveServiceRestApiTest.assertEquals((String)"Expected archive to shrink by one", (int)(archivedNodesCountBeforeRestore - 1), (int)this.getArchivedNodesCount());
    }

    public void testRestoreDeletedItemsAsNonAdminUser() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        String restoreUrl = this.getArchiveUrl(this.user2_DeletedTestNode.getStoreRef()) + "/" + this.user2_DeletedTestNode.getId();
        String jsonString = new JSONStringer().object().key("restoreLocation").value((Object)"").endObject().toString();
        TestWebScriptServer.Response rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(restoreUrl, jsonString, "application/json"), 403);
        NodeArchiveServiceRestApiTest.assertEquals((int)403, (int)rsp.getStatus());
        JSONObject jsonRsp = this.getArchivedNodes();
        JSONObject dataObj = (JSONObject)jsonRsp.get(DATA);
        JSONArray deletedNodesArray = (JSONArray)dataObj.get("deletedNodes");
        NodeArchiveServiceRestApiTest.assertEquals((String)"Unexpectedly found more than 1 item in the archive store.", (int)1, (int)deletedNodesArray.length());
        JSONObject archivedNode = (JSONObject)deletedNodesArray.get(0);
        String nodeRefString = archivedNode.getString("nodeRef");
        NodeArchiveServiceRestApiTest.assertTrue((String)"nodeRef string is invalid", (boolean)NodeRef.isNodeRef((String)nodeRefString));
        NodeRef nodeRef = new NodeRef(nodeRefString);
        restoreUrl = this.getArchiveUrl(nodeRef.getStoreRef()) + "/" + nodeRef.getId();
        int archivedNodesCountBeforeRestore = this.getArchivedNodesCount();
        jsonString = new JSONStringer().object().key("restoreLocation").value((Object)"").endObject().toString();
        rsp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest(restoreUrl, jsonString, "application/json"), 200);
        NodeArchiveServiceRestApiTest.assertEquals((String)"Expected archive to shrink by one", (int)(archivedNodesCountBeforeRestore - 1), (int)this.getArchivedNodesCount());
    }

    private String getArchiveUrl(StoreRef storeRef) {
        String result = MessageFormat.format(ARCHIVE_URL_FORMAT, storeRef.getProtocol(), storeRef.getIdentifier());
        return result;
    }

    private NodeRef createTestStoreAndGetRootNode() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        StoreRef workStoreRef = this.nodeService.createStore("workspace", this.getName() + System.currentTimeMillis());
        this.workStoreRootNodeRef = this.nodeService.getRootNode(workStoreRef);
        StoreRef archiveStoreRef = this.nodeService.createStore("workspace", "archive" + this.getName() + System.currentTimeMillis());
        this.archiveMap.put(workStoreRef, archiveStoreRef);
        this.createdStores.add(workStoreRef);
        this.createdStores.add(archiveStoreRef);
        return this.workStoreRootNodeRef;
    }

    private void createUser(String userName) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap map = new PropertyMap(5);
            map.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            map.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            map.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            map.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            map.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)map);
            this.createdPeople.add(userName);
        }
    }

    private NodeRef createTestNode(String authenticatedUser, final String cmName, final boolean deleteNode) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)authenticatedUser);
        return (NodeRef)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        HashMap<QName, String> props = new HashMap<QName, String>();
                        props.put(ContentModel.PROP_NAME, cmName);
                        props.put(ContentModel.PROP_TITLE, NodeArchiveServiceRestApiTest.TEST_TITLE);
                        props.put(ContentModel.PROP_DESCRIPTION, NodeArchiveServiceRestApiTest.TEST_DESCRIPTION);
                        NodeRef nodeRef = NodeArchiveServiceRestApiTest.this.nodeService.createNode(NodeArchiveServiceRestApiTest.this.workStoreRootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, props).getChildRef();
                        if (deleteNode) {
                            NodeArchiveServiceRestApiTest.this.nodeService.deleteNode(nodeRef);
                            NodeRef archivedNode = NodeArchiveServiceRestApiTest.this.nodeArchiveService.getArchivedNode(nodeRef);
                            return archivedNode;
                        }
                        return nodeRef;
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        });
    }

    private String createNodeName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis();
    }
}

