/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Comment;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Favourite;
import org.alfresco.rest.api.tests.client.data.FavouriteDocument;
import org.alfresco.rest.api.tests.client.data.FavouriteFolder;
import org.alfresco.rest.api.tests.client.data.FavouriteNode;
import org.alfresco.rest.api.tests.client.data.FavouritesTarget;
import org.alfresco.rest.api.tests.client.data.FileFavouriteTarget;
import org.alfresco.rest.api.tests.client.data.FolderFavouriteTarget;
import org.alfresco.rest.api.tests.client.data.InvalidFavouriteTarget;
import org.alfresco.rest.api.tests.client.data.JSONAble;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.client.data.PathInfo;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteFavouriteTarget;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.client.data.SiteMembershipRequest;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFavourites
extends AbstractBaseApiTest {
    private RepoService.TestNetwork network1;
    private RepoService.TestPerson person10;
    private String person10Id;
    private RepoService.TestPerson person11;
    private String person11Id;
    private RepoService.TestPerson person12;
    private String person12Id;
    private RepoService.TestPerson person14;
    private String person14Id;
    private RepoService.TestPerson person15;
    private String person15Id;
    private RepoService.TestNetwork network2;
    private RepoService.TestPerson person21;
    private String person21Id;
    private List<RepoService.TestSite> personSites = new ArrayList<RepoService.TestSite>();
    private List<RepoService.TestSite> person1PublicSites = new ArrayList<RepoService.TestSite>();
    private List<RepoService.TestSite> person1PrivateSites = new ArrayList<RepoService.TestSite>();
    private List<NodeRef> personDocs = new ArrayList<NodeRef>();
    private List<NodeRef> personFolders = new ArrayList<NodeRef>();
    private List<NodeRef> person1PublicDocs = new ArrayList<NodeRef>();
    private List<NodeRef> person1PublicFolders = new ArrayList<NodeRef>();
    private List<NodeRef> person1PrivateDocs = new ArrayList<NodeRef>();
    private List<NodeRef> person1PrivateFolders = new ArrayList<NodeRef>();
    private PublicApiClient.Favourites favouritesProxy;
    private PublicApiClient.SiteMembershipRequests siteMembershipRequestsProxy;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        final Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().networksIterator();
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void execute() throws Throwable {
                try {
                    AuthenticationUtil.pushAuthentication();
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    TestFavourites.this.network1 = (RepoService.TestNetwork)networksIt.next();
                    String name = GUID.generate();
                    PersonInfo personInfo = new PersonInfo(name, name, name, "password", null, null, null, null, null, null, null);
                    TestFavourites.this.person10 = TestFavourites.this.network1.createUser(personInfo);
                    Assert.assertNotNull((Object)TestFavourites.this.person10);
                    TestFavourites.this.person10Id = TestFavourites.this.person10.getId();
                    name = GUID.generate();
                    personInfo = new PersonInfo(name, name, name, "password", null, null, null, null, null, null, null);
                    TestFavourites.this.person11 = TestFavourites.this.network1.createUser(personInfo);
                    Assert.assertNotNull((Object)TestFavourites.this.person11);
                    TestFavourites.this.person11Id = TestFavourites.this.person11.getId();
                    name = GUID.generate();
                    personInfo = new PersonInfo(name, name, name, "password", null, null, null, null, null, null, null);
                    TestFavourites.this.person12 = TestFavourites.this.network1.createUser(personInfo);
                    Assert.assertNotNull((Object)TestFavourites.this.person12);
                    TestFavourites.this.person12Id = TestFavourites.this.person12.getId();
                    name = GUID.generate();
                    personInfo = new PersonInfo(name, name, name, "password", null, null, null, null, null, null, null);
                    TestFavourites.this.person14 = TestFavourites.this.network1.createUser(personInfo);
                    Assert.assertNotNull((Object)TestFavourites.this.person14);
                    TestFavourites.this.person14Id = TestFavourites.this.person14.getId();
                    name = GUID.generate();
                    personInfo = new PersonInfo(name, name, name, "password", null, null, null, null, null, null, null);
                    TestFavourites.this.person15 = TestFavourites.this.network1.createUser(personInfo);
                    Assert.assertNotNull((Object)TestFavourites.this.person15);
                    TestFavourites.this.person15Id = TestFavourites.this.person15.getId();
                    TestFavourites.this.network2 = (RepoService.TestNetwork)networksIt.next();
                    name = GUID.generate();
                    personInfo = new PersonInfo(name, name, name, "password", null, null, null, null, null, null, null);
                    TestFavourites.this.person21 = TestFavourites.this.network2.createUser(personInfo);
                    Assert.assertNotNull((Object)TestFavourites.this.person21);
                    TestFavourites.this.person21Id = TestFavourites.this.person21.getId();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    AuthenticationUtil.popAuthentication();
                }
            }
        }, false, true);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + GUID.generate();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = TestFavourites.this.network1.createSite(siteInfo);
                TestFavourites.this.person1PublicSites.add(site);
                NodeRef nodeRef = TestFavourites.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc1", "Test Doc1 Title", "Test Doc1 Description", "Test Content");
                TestFavourites.this.person1PublicDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder1", "Test Folder1 Title", "Test Folder1 Description");
                TestFavourites.this.person1PublicFolders.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createDocument(nodeRef, "Test Doc2", "Test Doc2 Title", "Test Doc2 Description", "Test Content");
                TestFavourites.this.person1PublicDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder2", "Test Folder2 Title", "Test Folder2 Description");
                TestFavourites.this.person1PublicFolders.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc3", "Test Doc3 Title", "Test Doc3 Description", "Test Content");
                TestFavourites.this.person1PublicDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder3", "Test Folder3 Title", "Test Folder3 Description");
                TestFavourites.this.person1PublicFolders.add(nodeRef);
                siteName = "site" + GUID.generate();
                siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                site = TestFavourites.this.network1.createSite(siteInfo);
                TestFavourites.this.person1PublicSites.add(site);
                siteName = "site" + GUID.generate();
                siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PRIVATE);
                site = TestFavourites.this.network1.createSite(siteInfo);
                TestFavourites.this.person1PrivateSites.add(site);
                nodeRef = TestFavourites.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc1", "Test Doc1 Title", "Test Doc1 Description", "Test Content");
                TestFavourites.this.person1PrivateDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder1", "Test Folder1 Title", "Test Folder1 Description");
                TestFavourites.this.person1PrivateFolders.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createDocument(nodeRef, "Test Doc2", "Test Doc2 Title", "Test Doc2 Description", "Test Content");
                TestFavourites.this.person1PrivateDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder2", "Test Folder2 Title", "Test Folder2 Description");
                TestFavourites.this.person1PrivateFolders.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc3", "Test Doc3 Title", "Test Doc3 Description", "Test Content");
                TestFavourites.this.person1PrivateDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder3", "Test Folder3 Title", "Test Folder3 Description");
                TestFavourites.this.person1PrivateFolders.add(nodeRef);
                return null;
            }
        }, (String)this.person11Id, (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + System.currentTimeMillis();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = TestFavourites.this.network1.createSite(siteInfo);
                TestFavourites.this.person1PublicSites.add(site);
                NodeRef nodeRef = TestFavourites.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc1", "Test Content");
                TestFavourites.this.personDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder1");
                TestFavourites.this.personFolders.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc2", "Test Content");
                TestFavourites.this.personDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder2");
                TestFavourites.this.personFolders.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc3", "Test Content");
                TestFavourites.this.personDocs.add(nodeRef);
                nodeRef = TestFavourites.this.repoService.createFolder(site.getContainerNodeRef("documentLibrary"), "Test Folder3");
                TestFavourites.this.personFolders.add(nodeRef);
                return null;
            }
        }, (String)this.person10Id, (String)this.network1.getId());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                String siteName = "site" + GUID.generate();
                RepoService.SiteInformation siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                RepoService.TestSite site = TestFavourites.this.network1.createSite(siteInfo);
                TestFavourites.this.personSites.add(site);
                site.inviteToSite(TestFavourites.this.person11Id, SiteRole.SiteCollaborator);
                siteName = "site" + GUID.generate();
                siteInfo = new RepoService.SiteInformation(siteName, siteName, siteName, SiteVisibility.PUBLIC);
                site = TestFavourites.this.network1.createSite(siteInfo);
                TestFavourites.this.personSites.add(site);
                return null;
            }
        }, (String)this.person10Id, (String)this.network1.getId());
        this.favouritesProxy = this.publicApiClient.favourites();
        this.siteMembershipRequestsProxy = this.publicApiClient.siteMembershipRequests();
    }

    private void sort(List<Favourite> favourites, final List<Pair<FavouritesService.SortFields, Boolean>> sortProps) {
        Comparator<Favourite> comparator = new Comparator<Favourite>(){

            @Override
            public int compare(Favourite o1, Favourite o2) {
                int ret = 0;
                for (Pair sort : sortProps) {
                    FavouritesService.SortFields field = (FavouritesService.SortFields)sort.getFirst();
                    Boolean ascending = (Boolean)sort.getSecond();
                    if (field.equals((Object)FavouritesService.SortFields.username)) {
                        if (ascending.booleanValue()) {
                            if (o1.getUsername() != null && o2.getUsername() != null) {
                                ret = TestFavourites.this.collator.compare(o1.getUsername(), o2.getUsername());
                            }
                        } else if (o1.getUsername() != null && o2.getUsername() != null) {
                            ret = o2.getUsername().compareTo(o1.getUsername());
                        }
                        if (ret == 0) continue;
                        break;
                    }
                    if (!(field.equals((Object)FavouritesService.SortFields.type) ? (ret = ascending != false ? o1.getType().compareTo((Enum)o2.getType()) : o2.getType().compareTo((Enum)o1.getType())) != 0 : field.equals((Object)FavouritesService.SortFields.createdAt) && (ret = ascending != false ? o1.getCreatedAt().compareTo(o2.getCreatedAt()) : o2.getCreatedAt().compareTo(o1.getCreatedAt())) != 0)) continue;
                    break;
                }
                return ret;
            }
        };
        Collections.sort(favourites, comparator);
    }

    private ArrayList<Favourite> filter(List<Favourite> favourites, final Set<FavouritesService.Type> types) {
        Predicate<Favourite> predicate = new Predicate<Favourite>(){

            public boolean apply(Favourite other) {
                FavouritesService.Type type = null;
                if (other.getTarget() instanceof FileFavouriteTarget) {
                    type = FavouritesService.Type.FILE;
                } else if (other.getTarget() instanceof FolderFavouriteTarget) {
                    type = FavouritesService.Type.FOLDER;
                } else if (other.getTarget() instanceof SiteFavouriteTarget) {
                    type = FavouritesService.Type.SITE;
                }
                boolean ret = type != null && types.contains(type);
                return ret;
            }
        };
        ArrayList ret = Lists.newArrayList((Iterable)Collections2.filter(favourites, (Predicate)predicate));
        return ret;
    }

    private void updateFavourite(String networkId, String runAsUserId, String personId, TARGET_TYPE type) throws Exception {
        List<Favourite> favourites;
        PublicApiClient.ListResponse<Favourite> resp;
        int size2 = 0;
        try {
            resp = this.getFavourites(networkId, runAsUserId, personId, 0, Integer.MAX_VALUE, null, null, type);
            favourites = resp.getList();
            size2 = favourites.size();
            Assert.assertTrue((size2 > 0 ? 1 : 0) != 0);
            Favourite favourite = favourites.get(0);
            this.favouritesProxy.update("people", personId, "favorites", favourite.getTargetGuid(), favourite.toJSON().toString(), "Unable to update favourite");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        resp = this.getFavourites(networkId, runAsUserId, personId, 0, Integer.MAX_VALUE, null, null, type);
        favourites = resp.getList();
        Assert.assertEquals((long)size2, (long)favourites.size());
    }

    private Favourite deleteFavourite(String networkId, String runAsUserId, String personId, TARGET_TYPE type) throws Exception {
        PublicApiException e = null;
        this.publicApiClient.setRequestContext(new RequestContext(networkId, runAsUserId));
        PublicApiClient.ListResponse<Favourite> resp = this.getFavourites(networkId, runAsUserId, personId, 0, Integer.MAX_VALUE, null, null, type);
        List<Favourite> favourites = resp.getList();
        int size2 = favourites.size();
        Assert.assertTrue((size2 > 0 ? 1 : 0) != 0);
        Favourite favourite = favourites.get(0);
        try {
            this.favouritesProxy.removeFavourite(personId, favourite.getTargetGuid());
        }
        catch (PublicApiException exc) {
            e = exc;
        }
        resp = this.getFavourites(networkId, runAsUserId, personId, 0, Integer.MAX_VALUE, null, null, type);
        favourites = resp.getList();
        boolean stillExists = false;
        for (Favourite f : favourites) {
            if (!f.getTargetGuid().equals(favourite.getTargetGuid())) continue;
            stillExists = true;
            break;
        }
        Assert.assertFalse((boolean)stillExists);
        if (e != null) {
            throw e;
        }
        return favourite;
    }

    private PublicApiClient.ListResponse<Favourite> getFavourites(String networkId, String runAsUserId, String personId, int skipCount, int maxItems, Integer total, Integer expectedTotal, TARGET_TYPE type) throws PublicApiException, ParseException {
        this.publicApiClient.setRequestContext(new RequestContext(networkId, runAsUserId));
        PublicApiClient.Paging paging = null;
        paging = total == null && expectedTotal == null ? this.getPaging(skipCount, maxItems) : this.getPaging(skipCount, maxItems, total, expectedTotal);
        Map<String, CallSite> params = null;
        if (type != null) {
            params = Collections.singletonMap("where", "(EXISTS(target/" + String.valueOf((Object)type) + "))");
        }
        PublicApiClient.ListResponse<Favourite> resp = this.favouritesProxy.getFavourites(personId, this.createParams(paging, params));
        return resp;
    }

    private Favourite makeFolderFavourite(String targetGuid) throws ParseException {
        FavouriteFolder folder = new FavouriteFolder(targetGuid);
        FolderFavouriteTarget target = new FolderFavouriteTarget(folder);
        Date creationData = new Date();
        Favourite favourite = new Favourite(creationData, null, (FavouritesTarget)target, null);
        return favourite;
    }

    private Favourite makeFileFavourite(String targetGuid) throws ParseException {
        FavouriteDocument document = new FavouriteDocument(targetGuid);
        FileFavouriteTarget target = new FileFavouriteTarget(document);
        Date creationData = new Date();
        Favourite favourite = new Favourite(creationData, null, (FavouritesTarget)target, null);
        return favourite;
    }

    private Favourite makeSiteFavourite(Site site) throws ParseException {
        SiteFavouriteTarget target = new SiteFavouriteTarget(site);
        Date creationDate = new Date();
        Favourite favourite = new Favourite(creationDate, null, (FavouritesTarget)target, null);
        return favourite;
    }

    @Test
    public void testInvalidRequests() throws Exception {
        Favourite favourite;
        InvalidFavouriteTarget target;
        Favourite ret;
        Favourite favourite2;
        FavouriteFolder folder;
        FavouriteFolder folder2;
        Favourite ret2;
        String siteGuid;
        Favourite favourite3;
        InvalidFavouriteTarget target2;
        Site site;
        Object document;
        Favourite ret3;
        Favourite favourite4;
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            favourite4 = this.makeSiteFavourite(this.person1PublicSites.get(0));
            ret3 = this.favouritesProxy.createFavourite(this.person11Id, favourite4);
            favourite4.expected(ret3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2468");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            document = this.personDocs.get(0);
            NodeRef comment = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){
                final /* synthetic */ NodeRef val$document;
                {
                    this.val$document = nodeRef;
                }

                public NodeRef doWork() throws Exception {
                    NodeRef comment = TestFavourites.this.repoService.createComment(this.val$document, new Comment("Title", "Content"));
                    return comment;
                }
            }, (String)this.person10Id, (String)this.network1.getId());
            final String guid = comment.getId();
            JSONAble commentJSON = new JSONAble(){

                @Override
                public JSONObject toJSON() {
                    JSONObject json = new JSONObject();
                    json.put((Object)"guid", (Object)guid);
                    return json;
                }
            };
            InvalidFavouriteTarget target3 = new InvalidFavouriteTarget("comment", commentJSON, guid);
            Favourite favourite5 = new Favourite(target3);
            this.favouritesProxy.createFavourite(this.person10Id, favourite5);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2468");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            site = this.person1PublicSites.get(0);
            target2 = new InvalidFavouriteTarget(GUID.generate(), site, site.getGuid());
            favourite3 = new Favourite(target2);
            this.favouritesProxy.createFavourite(this.person10Id, favourite3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            siteGuid = this.person1PublicSites.get(0).getGuid();
            FavouriteDocument document2 = new FavouriteDocument(siteGuid);
            favourite3 = this.makeFileFavourite(document2.getGuid());
            ret2 = this.favouritesProxy.createFavourite(this.person10Id, favourite3);
            favourite3.expected(ret2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            siteGuid = this.person1PublicSites.get(0).getGuid();
            folder2 = new FavouriteFolder(siteGuid);
            favourite3 = this.makeFolderFavourite(folder2.getGuid());
            ret2 = this.favouritesProxy.createFavourite(this.person10Id, favourite3);
            favourite3.expected(ret2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            folder = new FavouriteFolder(this.person1PublicDocs.get(0).getId());
            favourite2 = this.makeFolderFavourite(folder.getGuid());
            ret = this.favouritesProxy.createFavourite(this.person10Id, favourite2);
            favourite2.expected(ret);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            document = new FavouriteDocument(this.person1PublicFolders.get(0).getId());
            favourite2 = this.makeFileFavourite(((FavouriteNode)document).getGuid());
            ret = this.favouritesProxy.createFavourite(this.person10Id, favourite2);
            favourite2.expected(ret);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2471");
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            document = new FavouriteDocument(this.person1PublicDocs.get(0).getId());
            favourite2 = this.makeFileFavourite(((FavouriteNode)document).getGuid());
            this.favouritesProxy.createFavourite(this.person11Id, favourite2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        PublicApiClient.ListResponse<Favourite> response = this.favouritesProxy.getFavourites(this.person11Id, this.createParams(null, null));
        Assert.assertEquals((long)0L, (long)response.getList().size());
        try {
            this.log("cloud-2469");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            favourite4 = this.makeSiteFavourite(this.personSites.get(0));
            ret3 = this.favouritesProxy.createFavourite(GUID.generate(), favourite4);
            favourite4.expected(ret3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2465");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            this.favouritesProxy.getFavourites(this.person11Id, null);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.log("cloud-2464");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            this.favouritesProxy.getFavourites(GUID.generate(), null);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2480");
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            site = new SiteImpl();
            ((SiteImpl)site).setGuid(GUID.generate());
            favourite2 = this.makeSiteFavourite(site);
            this.favouritesProxy.createFavourite(this.person10Id, favourite2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        response = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(null, null));
        Assert.assertEquals((long)0L, (long)response.getList().size());
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            document = new FavouriteDocument(GUID.generate());
            favourite2 = this.makeFileFavourite(((FavouriteNode)document).getGuid());
            this.favouritesProxy.createFavourite(this.person10Id, favourite2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        response = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(null, null));
        Assert.assertEquals((long)0L, (long)response.getList().size());
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            folder = new FavouriteFolder(GUID.generate());
            favourite2 = this.makeFolderFavourite(folder.getGuid());
            this.favouritesProxy.createFavourite(this.person10Id, favourite2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        response = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(null, null));
        Assert.assertEquals((long)0L, (long)response.getList().size());
        this.log("cloud-2470");
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            site = this.person1PublicSites.get(0);
            target2 = new InvalidFavouriteTarget("folder", site, site.getGuid());
            favourite3 = new Favourite(target2);
            this.favouritesProxy.createFavourite(this.person10Id, favourite3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            site = this.person1PublicSites.get(0);
            target2 = new InvalidFavouriteTarget("file", site, site.getGuid());
            favourite3 = new Favourite(target2);
            this.favouritesProxy.createFavourite(this.person10Id, favourite3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        document = new FavouriteDocument(this.person1PublicDocs.get(0).getId());
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            target2 = new InvalidFavouriteTarget("site", document, ((FavouriteNode)document).getGuid());
            favourite3 = new Favourite(target2);
            this.favouritesProxy.createFavourite(this.person10Id, favourite3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            target2 = new InvalidFavouriteTarget("folder", document, ((FavouriteNode)document).getGuid());
            favourite3 = new Favourite(target2);
            this.favouritesProxy.createFavourite(this.person10Id, favourite3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        folder2 = new FavouriteFolder(this.person1PublicFolders.get(0).getId());
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            target = new InvalidFavouriteTarget("site", folder2, folder2.getGuid());
            favourite = new Favourite(target);
            this.favouritesProxy.createFavourite(this.person10Id, favourite);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            target = new InvalidFavouriteTarget("file", folder2, folder2.getGuid());
            favourite = new Favourite(target);
            this.favouritesProxy.createFavourite(this.person10Id, favourite);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        PublicApiClient.ListResponse<Favourite> response2 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(null, null));
        Assert.assertEquals((long)0L, (long)response2.getList().size());
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        try {
            favourite4 = new Favourite(null);
            this.favouritesProxy.update("people", "-me-", "favorites", null, favourite4.toJSON().toString(), "Unable to PUT favourites");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orderBy", "invalid ASC");
            this.favouritesProxy.getFavourites(this.person10Id, this.createParams(null, params));
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testValidRequests() throws Exception {
        Favourite favourite;
        ArrayList<Favourite> expectedFavourites = new ArrayList<Favourite>();
        this.log("cloud-2467");
        Favourite siteFavourite1 = this.makeSiteFavourite(this.person1PublicSites.get(0));
        FavouriteDocument document = this.repoService.getDocument(this.network1.getId(), this.person1PublicDocs.get(0));
        Favourite fileFavourite1 = this.makeFileFavourite(document.getGuid());
        FavouriteFolder folder = this.repoService.getFolder(this.network1.getId(), this.person1PublicFolders.get(0));
        Favourite folderFavourite1 = this.makeFolderFavourite(folder.getGuid());
        Favourite siteFavourite2 = this.makeSiteFavourite(this.person1PublicSites.get(1));
        document = this.repoService.getDocument(this.network1.getId(), this.person1PublicDocs.get(1));
        Favourite fileFavourite2 = this.makeFileFavourite(document.getGuid());
        folder = this.repoService.getFolder(this.network1.getId(), this.person1PublicFolders.get(1));
        Favourite folderFavourite2 = this.makeFolderFavourite(folder.getGuid());
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        Favourite ret = this.favouritesProxy.createFavourite(this.person10Id, siteFavourite1);
        expectedFavourites.add(ret);
        siteFavourite1.expected(ret);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ret = this.favouritesProxy.createFavourite(this.person10Id, fileFavourite1);
        expectedFavourites.add(ret);
        fileFavourite1.expected(ret);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ret = this.favouritesProxy.createFavourite(this.person10Id, folderFavourite1);
        expectedFavourites.add(ret);
        folderFavourite1.expected(ret);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ret = this.favouritesProxy.createFavourite(this.person10Id, siteFavourite2);
        expectedFavourites.add(ret);
        siteFavourite2.expected(ret);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ret = this.favouritesProxy.createFavourite(this.person10Id, fileFavourite2);
        expectedFavourites.add(ret);
        fileFavourite2.expected(ret);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ret = this.favouritesProxy.createFavourite(this.person10Id, folderFavourite2);
        expectedFavourites.add(ret);
        folderFavourite2.expected(ret);
        this.log("cloud-2472");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ret = this.favouritesProxy.createFavourite(this.person10Id, siteFavourite1);
        siteFavourite1.expected(ret);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ret = this.favouritesProxy.createFavourite(this.person10Id, folderFavourite1);
        folderFavourite1.expected(ret);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ret = this.favouritesProxy.createFavourite(this.person10Id, fileFavourite1);
        fileFavourite1.expected(ret);
        ArrayList<Favourite> person21ExpectedFavourites = new ArrayList<Favourite>();
        this.log("cloud-2498");
        this.log("cloud-2499");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person21Id));
        Favourite favourite2 = this.makeSiteFavourite(this.person1PrivateSites.get(0));
        try {
            this.favouritesProxy.createFavourite("-me-", favourite2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        int skipCount = 0;
        int maxItems = 10;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, person21ExpectedFavourites.size(), person21ExpectedFavourites.size());
        try {
            this.favouritesProxy.getFavourites("-me-", this.createParams(paging, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person21Id));
        FavouriteDocument document1 = new FavouriteDocument(this.person1PrivateDocs.get(0).getId());
        Favourite favourite3 = this.makeFileFavourite(document1.getGuid());
        try {
            this.favouritesProxy.createFavourite("-me-", favourite3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.sort(person21ExpectedFavourites, FavouritesService.DEFAULT_SORT_PROPS);
        int skipCount2 = 0;
        int maxItems2 = 10;
        PublicApiClient.Paging paging2 = this.getPaging(skipCount2, maxItems2, person21ExpectedFavourites.size(), person21ExpectedFavourites.size());
        try {
            this.favouritesProxy.getFavourites("-me-", this.createParams(paging2, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person21Id));
        FavouriteFolder folder1 = new FavouriteFolder(this.person1PrivateFolders.get(0).getId());
        favourite3 = this.makeFolderFavourite(folder1.getGuid());
        try {
            this.favouritesProxy.createFavourite("-me-", favourite3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.sort(person21ExpectedFavourites, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount = 0;
        maxItems2 = 10;
        paging2 = this.getPaging(skipCount, maxItems2, person21ExpectedFavourites.size(), person21ExpectedFavourites.size());
        try {
            this.favouritesProxy.getFavourites("-me-", this.createParams(paging2, null));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2458");
        this.log("cloud-2461");
        this.log("cloud-2462");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        ArrayList<Favourite> expected = new ArrayList<Favourite>(expectedFavourites);
        this.sort(expected, FavouritesService.DEFAULT_SORT_PROPS);
        int skipCount3 = 0;
        int maxItems3 = 2;
        PublicApiClient.Paging paging3 = this.getPaging(skipCount3, maxItems3, expectedFavourites.size(), expectedFavourites.size());
        PublicApiClient.ListResponse<Favourite> resp = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging3, null));
        this.checkList(expected.subList(skipCount3, skipCount3 + paging3.getExpectedPaging().getCount()), paging3.getExpectedPaging(), resp);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        expected = new ArrayList(expectedFavourites);
        this.sort(expected, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount3 = 2;
        maxItems3 = 4;
        paging3 = this.getPaging(skipCount3, maxItems3, expectedFavourites.size(), expectedFavourites.size());
        resp = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging3, null));
        this.checkList(expected.subList(skipCount3, skipCount3 + paging3.getExpectedPaging().getCount()), paging3.getExpectedPaging(), resp);
        this.log("cloud-2466");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        expected = new ArrayList(expectedFavourites);
        this.sort(expected, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount3 = 0;
        maxItems3 = Integer.MAX_VALUE;
        paging3 = this.getPaging(skipCount3, maxItems3, expectedFavourites.size(), expectedFavourites.size());
        resp = this.favouritesProxy.getFavourites("-me-", this.createParams(paging3, null));
        this.checkList(expected.subList(skipCount3, skipCount3 + paging3.getExpectedPaging().getCount()), paging3.getExpectedPaging(), resp);
        this.log("cloud-2459");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
        int skipCount4 = 0;
        int maxItems4 = Integer.MAX_VALUE;
        PublicApiClient.Paging paging4 = this.getPaging(skipCount4, maxItems4, 0, 0);
        PublicApiClient.ListResponse<Favourite> resp2 = this.favouritesProxy.getFavourites(this.person11Id, this.createParams(paging4, null));
        List empty = Collections.emptyList();
        this.checkList(empty, paging4.getExpectedPaging(), resp2);
        this.log("cloud-2460");
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        HashSet<FavouritesService.Type> types = new HashSet<FavouritesService.Type>(Arrays.asList(FavouritesService.Type.FILE));
        ArrayList<Favourite> expected2 = this.filter(expectedFavourites, types);
        this.sort(expected2, FavouritesService.DEFAULT_SORT_PROPS);
        int skipCount5 = 0;
        int maxItems5 = Integer.MAX_VALUE;
        PublicApiClient.Paging paging5 = this.getPaging(skipCount5, maxItems5, expected2.size(), expected2.size());
        Map<String, String> params = Collections.singletonMap("where", "(EXISTS(target/file))");
        PublicApiClient.ListResponse<Favourite> resp3 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging5, params));
        this.checkList(expected2.subList(skipCount5, skipCount5 + paging5.getExpectedPaging().getCount()), paging5.getExpectedPaging(), resp3);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        types = new HashSet<FavouritesService.Type>(Arrays.asList(FavouritesService.Type.FOLDER));
        expected2 = this.filter(expectedFavourites, types);
        this.sort(expected2, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount5 = 0;
        maxItems5 = Integer.MAX_VALUE;
        paging5 = this.getPaging(skipCount5, maxItems5, expected2.size(), expected2.size());
        params = Collections.singletonMap("where", "(EXISTS(target/folder))");
        resp3 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging5, params));
        this.checkList(expected2.subList(skipCount5, skipCount5 + paging5.getExpectedPaging().getCount()), paging5.getExpectedPaging(), resp3);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        types = new HashSet<FavouritesService.Type>(Arrays.asList(FavouritesService.Type.FILE));
        expected2 = this.filter(expectedFavourites, types);
        this.sort(expected2, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount5 = 0;
        maxItems5 = Integer.MAX_VALUE;
        paging5 = this.getPaging(skipCount5, maxItems5, expected2.size(), expected2.size());
        params = Collections.singletonMap("where", "(EXISTS(target/file))");
        resp3 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging5, params));
        this.checkList(expected2.subList(skipCount5, skipCount5 + paging5.getExpectedPaging().getCount()), paging5.getExpectedPaging(), resp3);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        types = new HashSet<FavouritesService.Type>(Arrays.asList(FavouritesService.Type.FOLDER));
        expected2 = this.filter(expectedFavourites, types);
        this.sort(expected2, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount5 = 0;
        maxItems5 = Integer.MAX_VALUE;
        paging5 = this.getPaging(skipCount5, maxItems5, expected2.size(), expected2.size());
        params = Collections.singletonMap("where", "(EXISTS(target/folder))");
        resp3 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging5, params));
        this.checkList(expected2.subList(skipCount5, skipCount5 + paging5.getExpectedPaging().getCount()), paging5.getExpectedPaging(), resp3);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        types = new HashSet<FavouritesService.Type>(Arrays.asList(FavouritesService.Type.SITE));
        expected2 = this.filter(expectedFavourites, types);
        this.sort(expected2, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount5 = 0;
        maxItems5 = Integer.MAX_VALUE;
        paging5 = this.getPaging(skipCount5, maxItems5, expected2.size(), expected2.size());
        params = Collections.singletonMap("where", "(EXISTS(target/site))");
        resp3 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging5, params));
        this.checkList(expected2.subList(skipCount5, skipCount5 + paging5.getExpectedPaging().getCount()), paging5.getExpectedPaging(), resp3);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        types = new HashSet<FavouritesService.Type>(Arrays.asList(FavouritesService.Type.FOLDER, FavouritesService.Type.FILE));
        expected2 = this.filter(expectedFavourites, types);
        this.sort(expected2, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount5 = 0;
        maxItems5 = Integer.MAX_VALUE;
        paging5 = this.getPaging(skipCount5, maxItems5, expected2.size(), expected2.size());
        params = Collections.singletonMap("where", "(EXISTS(target/file) OR EXISTS(target/folder))");
        resp3 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging5, params));
        this.checkList(expected2.subList(skipCount5, skipCount5 + paging5.getExpectedPaging().getCount()), paging5.getExpectedPaging(), resp3);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        types = new HashSet<FavouritesService.Type>(Arrays.asList(FavouritesService.Type.SITE, FavouritesService.Type.FILE));
        expected2 = this.filter(expectedFavourites, types);
        this.sort(expected2, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount5 = 0;
        maxItems5 = Integer.MAX_VALUE;
        paging5 = this.getPaging(skipCount5, maxItems5, expected2.size(), expected2.size());
        params = Collections.singletonMap("where", "(EXISTS(target/file) OR EXISTS(target/site))");
        resp3 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging5, params));
        this.checkList(expected2.subList(skipCount5, skipCount5 + paging5.getExpectedPaging().getCount()), paging5.getExpectedPaging(), resp3);
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        types = new HashSet<FavouritesService.Type>(Arrays.asList(FavouritesService.Type.SITE, FavouritesService.Type.FOLDER));
        expected2 = this.filter(expectedFavourites, types);
        this.sort(expected2, FavouritesService.DEFAULT_SORT_PROPS);
        skipCount5 = 0;
        maxItems5 = Integer.MAX_VALUE;
        paging5 = this.getPaging(skipCount5, maxItems5, expected2.size(), expected2.size());
        params = Collections.singletonMap("where", "(EXISTS(target/site) OR EXISTS(target/folder))");
        resp3 = this.favouritesProxy.getFavourites(this.person10Id, this.createParams(paging5, params));
        this.checkList(expected2.subList(skipCount5, skipCount5 + paging5.getExpectedPaging().getCount()), paging5.getExpectedPaging(), resp3);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            this.favouritesProxy.getFavourite(this.person10Id, GUID.generate());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            favourite = (Favourite)expectedFavourites.get(0);
            this.favouritesProxy.getFavourite(GUID.generate(), favourite.getTargetGuid());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        favourite = (Favourite)expectedFavourites.get(0);
        Favourite resp4 = this.favouritesProxy.getFavourite(this.person10Id, favourite.getTargetGuid());
        favourite.expected(resp4);
        this.log("cloud-2479.1");
        this.updateFavourite(this.network1.getId(), this.person10Id, this.person10Id, TARGET_TYPE.site);
        this.log("cloud-2479.2");
        this.updateFavourite(this.network1.getId(), this.person10Id, this.person10Id, TARGET_TYPE.file);
        this.log("cloud-2479.3");
        this.updateFavourite(this.network1.getId(), this.person10Id, this.person10Id, TARGET_TYPE.folder);
        try {
            this.log("cloud-2474");
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            this.favouritesProxy.removeFavourite(GUID.generate(), GUID.generate());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2475");
        NodeRef doc = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef containerNodeRef = TestFavourites.this.person1PublicSites.get(0).getContainerNodeRef("documentLibrary");
                NodeRef doc = TestFavourites.this.repoService.createDocument(containerNodeRef, GUID.generate(), "");
                return doc;
            }
        }, (String)this.person11Id, (String)this.network1.getId());
        String favouriteId = doc.getId();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
        PublicApiClient.ListResponse<Favourite> before = this.getFavourites(this.network1.getId(), this.person10Id, this.person10Id, 0, Integer.MAX_VALUE, null, null, null);
        List<Favourite> beforeList = before.getList();
        Assert.assertTrue((beforeList.size() > 0 ? 1 : 0) != 0);
        try {
            this.favouritesProxy.removeFavourite(this.person10Id, favouriteId);
            Assert.fail((String)"Should be a 404");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        PublicApiClient.ListResponse<Favourite> after = this.getFavourites(this.network1.getId(), this.person10Id, this.person10Id, 0, Integer.MAX_VALUE, null, null, null);
        Assert.assertEquals((long)beforeList.size(), (long)after.getList().size());
        this.log("cloud-2473.1");
        this.deleteFavourite(this.network1.getId(), this.person10Id, this.person10Id, TARGET_TYPE.site);
        this.log("cloud-2473.2");
        this.deleteFavourite(this.network1.getId(), this.person10Id, this.person10Id, TARGET_TYPE.file);
        this.log("cloud-2473.3");
        favourite = this.deleteFavourite(this.network1.getId(), this.person10Id, this.person10Id, TARGET_TYPE.folder);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person10Id));
            this.favouritesProxy.removeFavourite(this.person10Id, favourite.getTargetGuid());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        this.log("cloud-2476");
        PublicApiClient.ListResponse<Favourite> before2 = this.getFavourites(this.network1.getId(), this.person10Id, this.person10Id, 0, Integer.MAX_VALUE, null, null, null);
        Assert.assertTrue((before2.getList().size() > 0 ? 1 : 0) != 0);
        Favourite favourite4 = before2.getList().get(0);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person11Id));
            this.favouritesProxy.removeFavourite(this.person10Id, favourite4.getTargetGuid());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        PublicApiClient.ListResponse<Favourite> after2 = this.getFavourites(this.network1.getId(), this.person10Id, this.person10Id, 0, Integer.MAX_VALUE, null, null, null);
        Assert.assertEquals((long)before2.getList().size(), (long)after2.getList().size());
    }

    @Test
    public void testPUBLICAPI141() throws Exception {
        final RepoService.TestSite publicSite = this.person1PublicSites.get(0);
        final RepoService.TestSite publicSite1 = this.person1PublicSites.get(1);
        final RepoService.TestSite privateSite = this.person1PrivateSites.get(0);
        final NodeRef folderNodeRef = this.person1PublicFolders.get(0);
        NodeRef nodeRef = this.person1PublicDocs.get(1);
        ArrayList<Favourite> expectedFavourites = new ArrayList<Favourite>();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person12Id));
        SiteMembershipRequest siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(publicSite.getSiteId());
        siteMembershipRequest.setMessage("Please can I join your site?");
        this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person12Id, siteMembershipRequest);
        Favourite folderFavourite = this.makeFolderFavourite(folderNodeRef.getId());
        this.favouritesProxy.createFavourite(this.person12Id, folderFavourite);
        Favourite fileFavourite = this.makeFileFavourite(nodeRef.getId());
        this.favouritesProxy.createFavourite(this.person12Id, fileFavourite);
        Favourite siteFavourite = this.makeSiteFavourite(publicSite);
        this.favouritesProxy.createFavourite(this.person12Id, siteFavourite);
        expectedFavourites.add(siteFavourite);
        Favourite siteFavourite1 = this.makeSiteFavourite(publicSite1);
        this.favouritesProxy.createFavourite(this.person12Id, siteFavourite1);
        expectedFavourites.add(siteFavourite1);
        this.sort(expectedFavourites, FavouritesService.DEFAULT_SORT_PROPS);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                NodeRef documentLibraryNodeRef = privateSite.getContainerNodeRef("documentLibrary");
                TestFavourites.this.repoService.moveNode(folderNodeRef, documentLibraryNodeRef);
                return null;
            }
        }, (String)this.person11Id, (String)this.network1.getId());
        try {
            this.favouritesProxy.getFavourite(this.person12Id, folderFavourite.getTargetGuid());
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.favouritesProxy.getFavourite(this.person12Id, fileFavourite.getTargetGuid());
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        int skipCount = 0;
        int maxItems = Integer.MAX_VALUE;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedFavourites.size(), expectedFavourites.size());
        PublicApiClient.ListResponse<Favourite> resp = this.favouritesProxy.getFavourites(this.person12Id, this.createParams(paging, null));
        this.checkList(this.sublist(expectedFavourites, skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                publicSite.setSiteVisibility(SiteVisibility.PRIVATE);
                publicSite1.setSiteVisibility(SiteVisibility.PRIVATE);
                return null;
            }
        }, (String)this.person11Id, (String)this.network1.getId());
        expectedFavourites.remove(siteFavourite1);
        Favourite actual = this.favouritesProxy.getFavourite(this.person12Id, siteFavourite.getTargetGuid());
        siteFavourite.expected(actual);
        try {
            this.favouritesProxy.getFavourite(this.person12Id, siteFavourite1.getTargetGuid());
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        int skipCount2 = 0;
        int maxItems2 = Integer.MAX_VALUE;
        PublicApiClient.Paging paging2 = this.getPaging(skipCount2, maxItems2, expectedFavourites.size(), expectedFavourites.size());
        PublicApiClient.ListResponse<Favourite> resp2 = this.favouritesProxy.getFavourites(this.person12Id, this.createParams(paging2, null));
        this.checkList(this.sublist(expectedFavourites, skipCount2, skipCount2 + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), resp2);
    }

    @Test
    public void testPUBLICAPI156() throws Exception {
        RepoService.TestSite publicSite = this.person1PublicSites.get(0);
        RepoService.TestSite publicSite1 = this.person1PublicSites.get(1);
        final NodeRef folderNodeRef = this.person1PublicFolders.get(0);
        final NodeRef nodeRef = this.person1PublicDocs.get(1);
        ArrayList<Favourite> expectedFavourites = new ArrayList<Favourite>();
        this.publicApiClient.setRequestContext(new RequestContext(this.network1.getId(), this.person14Id));
        SiteMembershipRequest siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(publicSite.getSiteId());
        siteMembershipRequest.setMessage("Please can I join your site?");
        this.siteMembershipRequestsProxy.createSiteMembershipRequest(this.person14Id, siteMembershipRequest);
        Favourite folderFavourite = this.makeFolderFavourite(folderNodeRef.getId());
        this.favouritesProxy.createFavourite(this.person14Id, folderFavourite);
        expectedFavourites.add(folderFavourite);
        Favourite fileFavourite = this.makeFileFavourite(nodeRef.getId());
        this.favouritesProxy.createFavourite(this.person14Id, fileFavourite);
        expectedFavourites.add(fileFavourite);
        Favourite siteFavourite = this.makeSiteFavourite(publicSite);
        this.favouritesProxy.createFavourite(this.person14Id, siteFavourite);
        expectedFavourites.add(siteFavourite);
        Favourite siteFavourite1 = this.makeSiteFavourite(publicSite1);
        this.favouritesProxy.createFavourite(this.person14Id, siteFavourite1);
        expectedFavourites.add(siteFavourite1);
        this.sort(expectedFavourites, FavouritesService.DEFAULT_SORT_PROPS);
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                TestFavourites.this.repoService.deleteNode(nodeRef);
                TestFavourites.this.repoService.deleteNode(folderNodeRef);
                return null;
            }
        }, (String)this.person11Id, (String)this.network1.getId());
        expectedFavourites.remove(folderFavourite);
        expectedFavourites.remove(fileFavourite);
        this.sort(expectedFavourites, FavouritesService.DEFAULT_SORT_PROPS);
        try {
            this.favouritesProxy.getFavourite(this.person14Id, folderFavourite.getTargetGuid());
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.favouritesProxy.getFavourite(this.person14Id, fileFavourite.getTargetGuid());
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        int skipCount = 0;
        int maxItems = Integer.MAX_VALUE;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, expectedFavourites.size(), expectedFavourites.size());
        PublicApiClient.ListResponse<Favourite> resp = this.favouritesProxy.getFavourites(this.person14Id, this.createParams(paging, null));
        this.checkList(this.sublist(expectedFavourites, skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
    }

    @Test
    public void testGetFavouritesWithPath() throws Exception {
        this.setRequestContext(this.network1.getId(), this.person12Id, "password");
        NodeRef folderNodeRef = this.person1PublicFolders.get(0);
        NodeRef nodeRef = this.person1PublicDocs.get(1);
        RepoService.TestSite publicSite = this.person1PublicSites.get(0);
        Favourite fileFavourite = this.makeFileFavourite(nodeRef.getId());
        this.favouritesProxy.createFavourite(this.person12Id, fileFavourite);
        Favourite folderFavourite = this.makeFolderFavourite(folderNodeRef.getId());
        this.favouritesProxy.createFavourite(this.person12Id, folderFavourite);
        Favourite siteFavourite = this.makeSiteFavourite(publicSite);
        this.favouritesProxy.createFavourite(this.person12Id, siteFavourite);
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        Map<String, String> otherParams = Collections.singletonMap("include", "path");
        PublicApiClient.ListResponse<Favourite> resp = this.favouritesProxy.getFavourites(this.person12Id, this.createParams(paging, otherParams));
        List<Favourite> actualFavouritesList = resp.getList();
        Assert.assertEquals((String)"Incorrect number of entries returned", (long)3L, (long)actualFavouritesList.size());
        actualFavouritesList.forEach(fav -> {
            switch (fav.getType()) {
                case FILE: {
                    FavouriteDocument node = ((FileFavouriteTarget)fav.getTarget()).getDocument();
                    Assert.assertNotNull((String)"node is null.", (Object)node);
                    this.assertPathInfo(node.getPath(), "/Company Home/Sites/" + publicSite.getSiteId() + "/documentLibrary/Test Folder1", true);
                    break;
                }
                case FOLDER: {
                    FavouriteFolder node = ((FolderFavouriteTarget)fav.getTarget()).getFolder();
                    Assert.assertNotNull((String)"node is null.", (Object)node);
                    this.assertPathInfo(node.getPath(), "/Company Home/Sites/" + publicSite.getSiteId() + "/documentLibrary", true);
                    break;
                }
                case SITE: {
                    JSONObject siteJsonObject = fav.getTarget().toJSON();
                    Assert.assertNotNull((String)"There should be a site JSON object.", (Object)siteJsonObject);
                    Assert.assertNull((String)"Path info should not be returned for sites.", (Object)siteJsonObject.get((Object)"path"));
                    break;
                }
            }
        });
        resp = this.favouritesProxy.getFavourites(this.person12Id, this.createParams(paging, null));
        actualFavouritesList = resp.getList();
        Assert.assertEquals((String)"Incorrect number of entries returned", (long)3L, (long)actualFavouritesList.size());
        actualFavouritesList.forEach(fav -> {
            switch (fav.getType()) {
                case FILE: {
                    FavouriteDocument node = ((FileFavouriteTarget)fav.getTarget()).getDocument();
                    Assert.assertNotNull((String)"node is null.", (Object)node);
                    Assert.assertNull((String)"Path info should not be returned by default", (Object)node.getPath());
                    break;
                }
                case FOLDER: {
                    FavouriteFolder node = ((FolderFavouriteTarget)fav.getTarget()).getFolder();
                    Assert.assertNotNull((String)"node is null.", (Object)node);
                    Assert.assertNull((String)"Path info should not be returned by default", (Object)node.getPath());
                    break;
                }
                case SITE: {
                    JSONObject siteJsonObject = fav.getTarget().toJSON();
                    Assert.assertNotNull((String)"There should be a site JSON object.", (Object)siteJsonObject);
                    Assert.assertNull((String)"Path info should not be returned for sites.", (Object)siteJsonObject.get((Object)"path"));
                    break;
                }
            }
        });
    }

    @Test
    public void testCreateAndGetFavouriteWithIncludeProperties() throws Exception {
        this.setRequestContext(this.network1.getId(), this.person11Id, "password");
        NodeRef nodeRef1 = this.person1PublicDocs.get(0);
        Favourite file1Favourite = this.makeFileFavourite(nodeRef1.getId());
        Favourite file1FavouriteResponse = this.favouritesProxy.createFavourite(this.person11Id, file1Favourite, null);
        Assert.assertNull((String)"Properties should be null because they wasn't requested via include=properties", file1FavouriteResponse.getProperties());
        file1FavouriteResponse = this.favouritesProxy.getFavourite(this.person11Id, file1FavouriteResponse.getTargetGuid(), null);
        Assert.assertNull((String)"Properties should be null because they wasn't requested via include=properties", file1FavouriteResponse.getProperties());
        Map<String, String> include = Collections.singletonMap("include", "properties");
        file1FavouriteResponse = this.favouritesProxy.createFavourite(this.person11Id, file1Favourite, include);
        Assert.assertNull((String)"Properties should be null because all of the properties are already in the favourite target and will not be listed twice!", file1FavouriteResponse.getProperties());
        file1FavouriteResponse = this.favouritesProxy.getFavourite(this.person11Id, file1FavouriteResponse.getTargetGuid(), include);
        Assert.assertNull((String)"Properties should be null because all of the properties are already in the favourite target and will not be listed twice!", file1FavouriteResponse.getProperties());
        TenantUtil.runAsUserTenant(() -> {
            this.repoService.lockNode(nodeRef1);
            return null;
        }, (String)this.person11Id, (String)this.network1.getId());
        file1FavouriteResponse = this.favouritesProxy.createFavourite(this.person11Id, file1Favourite, include);
        Assert.assertNotNull((String)"Properties shouldn't be null because we created some properties while locking the file", file1FavouriteResponse.getProperties());
        file1FavouriteResponse = this.favouritesProxy.getFavourite(this.person11Id, file1FavouriteResponse.getTargetGuid(), include);
        Assert.assertNotNull((String)"Properties shouldn't be null because we created some properties while locking the file", file1FavouriteResponse.getProperties());
    }

    @Test
    public void testCreateAndGetFavouriteWithIncludeEmptyPropertiesFile() throws Exception {
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        Map<String, String> include = Collections.singletonMap("include", "properties");
        String f0Id = this.createFolder("-root-", "f0-testCreateEmptyFile-" + this.RUNID).getId();
        String postUrl = this.getNodeChildrenUrl(f0Id);
        Document d1 = new Document();
        d1.setName("d1.txt");
        d1.setNodeType("cm:content");
        HttpResponse response = this.post(postUrl, RestApiUtil.toJsonAsStringNonNull(d1), 201);
        Document documentResp = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Favourite file1Favourite = this.makeFileFavourite(documentResp.getId());
        Favourite file1FavouriteResponse = this.favouritesProxy.createFavourite(networkAdmin, file1Favourite, null);
        file1FavouriteResponse = this.favouritesProxy.getFavourite(networkAdmin, file1FavouriteResponse.getTargetGuid(), include);
        Assert.assertNull((String)"Properties should be null, created document is empty", file1FavouriteResponse.getProperties());
        int favouriteStatusCode = this.favouritesProxy.getSingle("people", networkAdmin, "favorites", file1FavouriteResponse.getTargetGuid(), include, "Failed to get favourite " + file1FavouriteResponse.getTargetGuid(), 200).getStatusCode();
        Assert.assertTrue((String)"Status code should be within the success range", (200 <= favouriteStatusCode && favouriteStatusCode <= 299 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateAndGetFavouriteWithPath() throws Exception {
        Map<String, String> includePath = Collections.singletonMap("include", "path");
        this.setRequestContext(this.network1.getId(), this.person12Id, "password");
        NodeRef folderNodeRef = this.person1PublicFolders.get(0);
        NodeRef nodeRef1 = this.person1PublicDocs.get(0);
        NodeRef nodeRef2 = this.person1PublicDocs.get(1);
        RepoService.TestSite publicSite = this.person1PublicSites.get(0);
        Favourite file1Favourite = this.makeFileFavourite(nodeRef1.getId());
        file1Favourite = this.favouritesProxy.createFavourite(this.person12Id, file1Favourite, includePath);
        FavouriteNode node = ((FileFavouriteTarget)file1Favourite.getTarget()).getDocument();
        this.assertPathInfo(node.getPath(), "/Company Home/Sites/" + publicSite.getSiteId() + "/documentLibrary", true);
        Assert.assertEquals((Object)"Test Doc1", (Object)node.getName());
        Assert.assertEquals((Object)"Test Doc1 Title", (Object)node.getTitle());
        Assert.assertEquals((Object)"Test Doc1 Description", (Object)node.getDescription());
        Favourite file2Favourite = this.makeFileFavourite(nodeRef2.getId());
        file2Favourite = this.favouritesProxy.createFavourite(this.person12Id, file2Favourite);
        node = ((FileFavouriteTarget)file2Favourite.getTarget()).getDocument();
        Assert.assertNull((String)"Path info should not be returned by default", (Object)node.getPath());
        Favourite folderFavourite = this.makeFolderFavourite(folderNodeRef.getId());
        folderFavourite = this.favouritesProxy.createFavourite(this.person12Id, folderFavourite, includePath);
        node = ((FolderFavouriteTarget)folderFavourite.getTarget()).getFolder();
        this.assertPathInfo(node.getPath(), "/Company Home/Sites/" + publicSite.getSiteId() + "/documentLibrary", true);
        Favourite siteFavourite = this.makeSiteFavourite(publicSite);
        siteFavourite = this.favouritesProxy.createFavourite(this.person12Id, siteFavourite);
        JSONObject siteJsonObject = siteFavourite.getTarget().toJSON();
        Assert.assertNotNull((String)"There should be a site JSON object.", (Object)siteJsonObject);
        Assert.assertNull((String)"Path info should not be returned for sites.", (Object)siteJsonObject.get((Object)"path"));
        Favourite favouriteResp = this.favouritesProxy.getFavourite(this.person12Id, file2Favourite.getTargetGuid(), includePath);
        node = ((FileFavouriteTarget)favouriteResp.getTarget()).getDocument();
        this.assertPathInfo(node.getPath(), "/Company Home/Sites/" + publicSite.getSiteId() + "/documentLibrary/Test Folder1", true);
        favouriteResp = this.favouritesProxy.getFavourite(this.person12Id, folderFavourite.getTargetGuid(), includePath);
        node = ((FolderFavouriteTarget)favouriteResp.getTarget()).getFolder();
        this.assertPathInfo(node.getPath(), "/Company Home/Sites/" + publicSite.getSiteId() + "/documentLibrary", true);
        favouriteResp = this.favouritesProxy.getFavourite(this.person12Id, siteFavourite.getTargetGuid(), includePath);
        siteJsonObject = favouriteResp.getTarget().toJSON();
        Assert.assertNotNull((String)"There should be a site JSON object.", (Object)siteJsonObject);
        Assert.assertNull((String)"Path info should not be returned for sites.", (Object)siteJsonObject.get((Object)"path"));
    }

    @Test
    public void testVerifyFavorite() throws Exception {
        this.setRequestContext(this.network1.getId(), this.person12Id, "password");
        NodeRef folderNodeRef = this.person1PublicFolders.get(0);
        NodeRef nodeRef1 = this.person1PublicDocs.get(0);
        NodeRef nodeRef2 = this.person1PublicDocs.get(1);
        Favourite file1Favourite = this.makeFileFavourite(nodeRef1.getId());
        this.favouritesProxy.createFavourite(this.person12Id, file1Favourite);
        Favourite file2Favourite = this.makeFileFavourite(nodeRef2.getId());
        this.favouritesProxy.createFavourite(this.person12Id, file2Favourite);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("include", "isFavorite");
        HttpResponse response = this.getAll(this.getNodeChildrenUrl(folderNodeRef.getId()), null, params, 200);
        List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertTrue((nodes.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)nodes.get(0).getIsFavorite());
        response = this.getAll(this.getNode(nodeRef1.getId()), null, params, 200);
        Node node1 = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Node.class);
        Assert.assertTrue((boolean)node1.getIsFavorite());
    }

    @Test
    public void testSortFavourites() throws Exception {
        this.setRequestContext(this.network1.getId(), this.person15Id, "password");
        NodeRef folderNodeRef1 = this.person1PublicFolders.get(0);
        NodeRef folderNodeRef2 = this.person1PublicFolders.get(1);
        NodeRef folderNodeRef3 = this.person1PublicFolders.get(2);
        NodeRef nodeRef1 = this.person1PublicDocs.get(0);
        NodeRef nodeRef2 = this.person1PublicDocs.get(1);
        Favourite folder1Favourite = this.makeFolderFavourite(folderNodeRef1.getId());
        this.favouritesProxy.createFavourite(this.person15Id, folder1Favourite);
        Favourite folder2Favourite = this.makeFolderFavourite(folderNodeRef2.getId());
        this.favouritesProxy.createFavourite(this.person15Id, folder2Favourite);
        Favourite folder3Favourite = this.makeFolderFavourite(folderNodeRef3.getId());
        this.favouritesProxy.createFavourite(this.person15Id, folder3Favourite);
        Favourite file1Favourite = this.makeFileFavourite(nodeRef1.getId());
        this.favouritesProxy.createFavourite(this.person15Id, file1Favourite);
        Favourite file2Favourite = this.makeFileFavourite(nodeRef2.getId());
        this.favouritesProxy.createFavourite(this.person15Id, file2Favourite);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderBy", "title ASC");
        List<Favourite> favourites = this.favouritesProxy.getFavourites(this.person15Id, this.createParams(null, params)).getList();
        Assert.assertTrue((favourites.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)favourites.get(0).getTargetGuid().equals(nodeRef1.getId()));
        Assert.assertTrue((boolean)favourites.get(1).getTargetGuid().equals(nodeRef2.getId()));
        Assert.assertTrue((boolean)favourites.get(2).getTargetGuid().equals(folderNodeRef1.getId()));
        Assert.assertTrue((boolean)favourites.get(3).getTargetGuid().equals(folderNodeRef2.getId()));
        Assert.assertTrue((boolean)favourites.get(4).getTargetGuid().equals(folderNodeRef3.getId()));
        params = new HashMap();
        params.put("orderBy", "type DESC, title DESC");
        favourites = this.favouritesProxy.getFavourites(this.person15Id, this.createParams(null, params)).getList();
        Assert.assertTrue((favourites.size() == 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)favourites.get(0).getTargetGuid().equals(folderNodeRef3.getId()));
        Assert.assertTrue((boolean)favourites.get(1).getTargetGuid().equals(folderNodeRef2.getId()));
        Assert.assertTrue((boolean)favourites.get(2).getTargetGuid().equals(folderNodeRef1.getId()));
        Assert.assertTrue((boolean)favourites.get(3).getTargetGuid().equals(nodeRef2.getId()));
        Assert.assertTrue((boolean)favourites.get(4).getTargetGuid().equals(nodeRef1.getId()));
    }

    private void assertPathInfo(PathInfo expectedPathInfo, String expectedPathName, boolean expectedIsComplete) {
        Assert.assertNotNull((String)"Path info was requested.", (Object)expectedPathInfo);
        Assert.assertEquals((String)"IsComplete should have been true.", (Object)expectedIsComplete, (Object)expectedPathInfo.getIsComplete());
        Assert.assertEquals((String)"Incorrect path name.", (Object)expectedPathName, (Object)expectedPathInfo.getName());
        List<String> expectedPathElements = Arrays.asList(expectedPathName.substring(1).split("/"));
        Assert.assertEquals((String)"Incorrect number of path elements.", (long)expectedPathElements.size(), (long)expectedPathInfo.getElements().size());
        AtomicInteger i = new AtomicInteger(0);
        expectedPathElements.forEach(path -> Assert.assertEquals((String)"Incorrect path element.", (Object)path, (Object)expectedPathInfo.getElements().get(i.getAndIncrement()).getName()));
    }

    @Override
    public String getScope() {
        return "public";
    }

    private static enum TARGET_TYPE {
        file,
        folder,
        site;

    }
}

