/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.Collections;
import java.util.List;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.impl.rules.RuleLoader;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.Rule;
import org.alfresco.rest.api.model.rules.RuleTrigger;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RuleLoaderTest {
    private static final String NODE_ID = "node-id";
    private static final NodeRef NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "node-id");
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final boolean ENABLED = true;
    private static final boolean INHERITABLE = true;
    private static final boolean EXECUTE_ASYNCHRONOUSLY = false;
    private static final List<String> TRIGGERS = List.of("update", "outbound");
    private static final NodeRef RULE_SET_NODE = new NodeRef("rule://set/");
    @Mock
    private RuleService ruleServiceMock;
    @Mock
    private NodeValidator nodeValidatorMock;
    @Mock
    private RestModelMapper<Rule, org.alfresco.service.cmr.rule.Rule> ruleMapperMock;
    private org.alfresco.service.cmr.rule.Rule serviceRule = this.createServiceRule();
    @InjectMocks
    private RuleLoader ruleLoader;

    @Test
    public void testLoadRule() {
        Rule restModelRule = this.getRestModelRule();
        BDDMockito.given((Object)((Rule)this.ruleMapperMock.toRestModel((Object)this.serviceRule))).willReturn((Object)restModelRule);
        Rule rule = this.ruleLoader.loadRule(this.serviceRule, Collections.emptyList());
        Rule expected = Rule.builder().id(NODE_ID).name(TITLE).description(DESCRIPTION).isEnabled(true).isInheritable(true).isAsynchronous(false).triggers(List.of(RuleTrigger.UPDATE, RuleTrigger.OUTBOUND)).create();
        Assertions.assertThat((Object)rule).isEqualTo((Object)expected);
    }

    @Test
    public void testLoadRule_noExceptionWithNullInclude() {
        this.ruleLoader.loadRule(this.serviceRule, null);
        ((RestModelMapper)BDDMockito.then(this.ruleMapperMock).should()).toRestModel((Object)this.serviceRule);
        BDDMockito.then(this.ruleMapperMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testLoadRule_includeIsShared() {
        Rule restModelRule = this.getRestModelRule();
        BDDMockito.given((Object)this.ruleServiceMock.getRuleSetNode(NODE_REF)).willReturn((Object)RULE_SET_NODE);
        BDDMockito.given((Object)this.nodeValidatorMock.isRuleSetNotNullAndShared(RULE_SET_NODE)).willReturn((Object)true);
        BDDMockito.given((Object)((Rule)this.ruleMapperMock.toRestModel((Object)this.serviceRule))).willReturn((Object)restModelRule);
        Rule rule = this.ruleLoader.loadRule(this.serviceRule, List.of("isShared"));
        ((RestModelMapper)BDDMockito.then(this.ruleMapperMock).should()).toRestModel((Object)this.serviceRule);
        BDDMockito.then(this.ruleMapperMock).shouldHaveNoMoreInteractions();
        ((RuleService)BDDMockito.then((Object)this.ruleServiceMock).should()).getRuleSetNode(NODE_REF);
        BDDMockito.then((Object)this.ruleServiceMock).shouldHaveNoMoreInteractions();
        ((NodeValidator)BDDMockito.then((Object)this.nodeValidatorMock).should()).isRuleSetNotNullAndShared(RULE_SET_NODE);
        BDDMockito.then((Object)this.nodeValidatorMock).shouldHaveNoMoreInteractions();
        Assertions.assertThat((Object)rule).extracting("isShared").isEqualTo((Object)true);
    }

    private org.alfresco.service.cmr.rule.Rule createServiceRule() {
        org.alfresco.service.cmr.rule.Rule rule = new org.alfresco.service.cmr.rule.Rule();
        rule.setNodeRef(NODE_REF);
        rule.setTitle(TITLE);
        rule.setDescription(DESCRIPTION);
        rule.setRuleDisabled(false);
        rule.applyToChildren(true);
        rule.setExecuteAsynchronously(false);
        rule.setRuleTypes(TRIGGERS);
        return rule;
    }

    private Rule getRestModelRule() {
        return Rule.builder().id(NODE_ID).name(TITLE).description(DESCRIPTION).isEnabled(true).isInheritable(true).isAsynchronous(false).triggers(List.of(RuleTrigger.UPDATE, RuleTrigger.OUTBOUND)).create();
    }
}

