/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bulkimport.copy;

import java.io.File;
import java.util.Map;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.MultiThreadedBulkFilesystemImporter;
import org.alfresco.repo.bulkimport.impl.StreamingNodeImporterFactory;
import org.alfresco.repo.web.scripts.bulkimport.AbstractBulkFileSystemImportWebScript;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BulkFilesystemImportWebScript
extends AbstractBulkFileSystemImportWebScript {
    private MultiThreadedBulkFilesystemImporter bulkImporter;
    private StreamingNodeImporterFactory nodeImporterFactory;

    public void setBulkImporter(MultiThreadedBulkFilesystemImporter bulkImporter) {
        this.bulkImporter = bulkImporter;
    }

    public void setNodeImporterFactory(StreamingNodeImporterFactory nodeImporterFactory) {
        this.nodeImporterFactory = nodeImporterFactory;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest request, Status status, Cache cache) {
        AbstractBulkFileSystemImportWebScript.MultithreadedImportWebScriptLogic importLogic = new AbstractBulkFileSystemImportWebScript.MultithreadedImportWebScriptLogic(this, this.bulkImporter, () -> this.createNodeImporter(request), request, status, cache);
        return importLogic.executeImport();
    }

    private NodeImporter createNodeImporter(WebScriptRequest request) {
        String sourceDirectoryStr = request.getParameter("sourceDirectory");
        if (sourceDirectoryStr == null || sourceDirectoryStr.trim().length() == 0) {
            throw new WebScriptException("Error: mandatory parameter 'sourceDirectory' was not provided.");
        }
        File sourceDirectory = new File(sourceDirectoryStr.trim());
        return this.nodeImporterFactory.getNodeImporter(sourceDirectory);
    }
}

