/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.site;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.site.AbstractSiteServiceTest;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class SiteExportServiceTest
extends AbstractSiteServiceTest {
    private static final String USER_FROM_LDAP = "SiteUserLdap";
    private static final String USER_ONE = "SiteUser";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.createUser(USER_ONE);
        this.createPerson(USER_FROM_LDAP);
        this.authenticationComponent.setCurrentUser("admin");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.deleteUser(USER_ONE);
        this.deleteUser(USER_FROM_LDAP);
        this.deleteSites();
    }

    public void testExportSiteWithMutipleUsers() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.addSiteMember(USER_FROM_LDAP, shortName);
        this.addSiteMember(USER_ONE, shortName);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getExportUrl(shortName)), 200);
        List<String> entries = this.getEntries(new ZipInputStream(new ByteArrayInputStream(response.getContentAsByteArray())));
        SiteExportServiceTest.assertFalse((boolean)entries.contains("No_Users_In_Site.txt"));
        SiteExportServiceTest.assertFalse((boolean)entries.contains("No_Persons_In_Site.txt"));
        SiteExportServiceTest.assertTrue((boolean)entries.contains("People.acp"));
        SiteExportServiceTest.assertTrue((boolean)entries.contains(shortName + "-people.xml"));
        SiteExportServiceTest.assertTrue((boolean)entries.contains("Users.acp"));
        SiteExportServiceTest.assertTrue((boolean)entries.contains(shortName + "-users.xml"));
    }

    public void testExportSiteWithOneLDAPUser() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        this.addSiteMember(USER_FROM_LDAP, shortName);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getExportUrl(shortName)), 200);
        List<String> entries = this.getEntries(new ZipInputStream(new ByteArrayInputStream(response.getContentAsByteArray())));
        SiteExportServiceTest.assertFalse((boolean)entries.contains("Users.acp"));
        SiteExportServiceTest.assertTrue((boolean)entries.contains("No_Users_In_Site.txt"));
        SiteExportServiceTest.assertTrue((boolean)entries.contains("People.acp"));
        SiteExportServiceTest.assertTrue((boolean)entries.contains(shortName + "-people.xml"));
    }

    public void testExportSiteWithNoUsers() throws Exception {
        String shortName = GUID.generate();
        this.createSite("myPreset", shortName, "myTitle", "myDescription", SiteVisibility.PUBLIC, 200);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(this.getExportUrl(shortName)), 200);
        List<String> entries = this.getEntries(new ZipInputStream(new ByteArrayInputStream(response.getContentAsByteArray())));
        SiteExportServiceTest.assertTrue((boolean)entries.contains("No_Users_In_Site.txt"));
        SiteExportServiceTest.assertTrue((boolean)entries.contains("No_Persons_In_Site.txt"));
        SiteExportServiceTest.assertFalse((boolean)entries.contains("Users.acp"));
        SiteExportServiceTest.assertFalse((boolean)entries.contains("People.acp"));
    }

    private List<String> getEntries(ZipInputStream zipStream) throws Exception {
        ZipEntry entry = null;
        ArrayList entries = Lists.newArrayList();
        while ((entry = zipStream.getNextEntry()) != null) {
            if (entry.getName().endsWith("acp")) {
                entries.addAll(this.getAcpEntries(zipStream));
            }
            entries.add(entry.getName());
            zipStream.closeEntry();
        }
        zipStream.close();
        return entries;
    }

    private List<String> getAcpEntries(InputStream inputStream) throws Exception {
        ArrayList entries = Lists.newArrayList();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry entry = null;
        try {
            while ((entry = zipInputStream.getNextEntry()) != null) {
                entries.add(entry.getName());
            }
        }
        catch (ZipException zipException) {
            // empty catch block
        }
        return entries;
    }

    private String getExportUrl(String shortName) {
        return "/api/sites/" + shortName + "/export";
    }
}

