/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.model;

import java.util.List;
import org.alfresco.rest.api.model.CustomAspect;
import org.alfresco.rest.api.model.CustomModelConstraint;
import org.alfresco.rest.api.model.CustomType;
import org.alfresco.service.cmr.dictionary.CustomModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;

public class CustomModel
implements Comparable<CustomModel> {
    private String name;
    private String author;
    private String description;
    private ModelStatus status;
    private String namespaceUri;
    private String namespacePrefix;
    private List<CustomType> types;
    private List<CustomAspect> aspects;
    private List<CustomModelConstraint> constraints;

    public CustomModel() {
    }

    public CustomModel(CustomModelDefinition modelDefinition) {
        this(modelDefinition, null, null, null);
    }

    public CustomModel(CustomModelDefinition modelDefinition, List<CustomType> types, List<CustomAspect> aspects, List<CustomModelConstraint> constraints) {
        this.name = modelDefinition.getName().getLocalName();
        this.author = modelDefinition.getAuthor();
        this.description = modelDefinition.getDescription();
        this.status = modelDefinition.isActive() ? ModelStatus.ACTIVE : ModelStatus.DRAFT;
        NamespaceDefinition nsd = (NamespaceDefinition)modelDefinition.getNamespaces().iterator().next();
        this.namespaceUri = nsd.getUri();
        this.namespacePrefix = nsd.getPrefix();
        this.types = types;
        this.aspects = aspects;
        this.constraints = constraints;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ModelStatus getStatus() {
        return this.status;
    }

    public void setStatus(ModelStatus status) {
        this.status = status;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefix(String namespacePrefix) {
        this.namespacePrefix = namespacePrefix;
    }

    public List<CustomType> getTypes() {
        return this.types;
    }

    public void setTypes(List<CustomType> types) {
        this.types = types;
    }

    public List<CustomAspect> getAspects() {
        return this.aspects;
    }

    public void setAspects(List<CustomAspect> aspects) {
        this.aspects = aspects;
    }

    public List<CustomModelConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<CustomModelConstraint> constraints) {
        this.constraints = constraints;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModel)) {
            return false;
        }
        CustomModel other = (CustomModel)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(CustomModel customModel) {
        return this.name.compareTo(customModel.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("CustomModel [name=").append(this.name).append(", author=").append(this.author).append(", description=").append(this.description).append(", status=").append((Object)this.status).append(", namespaceUri=").append(this.namespaceUri).append(", namespacePrefix=").append(this.namespacePrefix).append(']');
        return builder.toString();
    }

    public static enum ModelStatus {
        ACTIVE,
        DRAFT;

    }
}

