/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.download;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.alfresco.repo.web.scripts.download.AbstractDownloadWebscript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class DownloadPost
extends AbstractDownloadWebscript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            String error = "No parameters supplied";
            throw new WebScriptException(400, error);
        }
        JSONArray json = null;
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        LinkedList<NodeRef> nodes = new LinkedList<NodeRef>();
        if ("application/json".equals(contentType)) {
            JSONParser parser = new JSONParser();
            try {
                json = (JSONArray)parser.parse(req.getContent().getContent());
                for (int i = 0; i < json.size(); ++i) {
                    JSONObject obj = (JSONObject)json.get(i);
                    String nodeRefString = (String)obj.get((Object)"nodeRef");
                    if (nodeRefString == null) continue;
                    nodes.add(new NodeRef(nodeRefString));
                }
            }
            catch (IOException io) {
                throw new WebScriptException(500, "Unexpected IOException", (Throwable)io);
            }
            catch (ParseException je) {
                throw new WebScriptException(400, "Unexpected ParseException", (Throwable)je);
            }
        }
        if (nodes.size() <= 0) {
            throw new WebScriptException(400, "No nodeRefs provided");
        }
        NodeRef downloadNode = this.downloadService.createDownload(nodes.toArray(new NodeRef[nodes.size()]), true);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("downloadNodeRef", downloadNode);
        return model;
    }
}

