/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.rules;

import org.alfresco.rest.api.RuleSettings;
import org.alfresco.rest.api.model.rules.RuleSetting;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.service.Experimental;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="rule-settings", entityResource=NodesEntityResource.class, title="Folder rule settings")
@Experimental
public class NodeRuleSettingsRelation
implements RelationshipResourceAction.ReadById<RuleSetting>,
RelationshipResourceAction.Update<RuleSetting>,
InitializingBean {
    private RuleSettings ruleSettings;

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"ruleSettings", (Object)this.ruleSettings);
    }

    @Override
    @WebApiDescription(title="Get a folder node rule setting", description="Returns the specified rule setting for the given folder", successStatus=200)
    public RuleSetting readById(String folderId, String ruleSettingKey, Parameters parameters) throws RelationshipResourceNotFoundException {
        return this.ruleSettings.getRuleSetting(folderId, ruleSettingKey);
    }

    @Override
    @WebApiDescription(title="Update folder node rule setting", description="Update a rule setting for given node", successStatus=200)
    public RuleSetting update(String folderId, RuleSetting ruleSetting, Parameters parameters) {
        return this.ruleSettings.setRuleSetting(folderId, ruleSetting);
    }

    public void setRuleSettings(RuleSettings ruleSettings) {
        this.ruleSettings = ruleSettings;
    }
}

