/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.util.paging;

import junit.framework.TestCase;
import org.alfresco.repo.web.util.paging.Cursor;
import org.alfresco.repo.web.util.paging.Page;
import org.alfresco.repo.web.util.paging.Paging;

public class PagingTest
extends TestCase {
    protected Paging paging;

    protected void setUp() throws Exception {
        this.paging = new Paging();
    }

    public void testZeroBasedBooleans() {
        PagingTest.assertFalse((boolean)this.paging.isZeroBasedPage());
        this.paging.setZeroBasedPage(true);
        PagingTest.assertTrue((boolean)this.paging.isZeroBasedPage());
        PagingTest.assertTrue((boolean)this.paging.isZeroBasedRow());
        this.paging.setZeroBasedRow(false);
        PagingTest.assertFalse((boolean)this.paging.isZeroBasedRow());
    }

    public void testCreatePage() {
        Page page = this.paging.createPage(1, 10);
        PagingTest.assertNotNull((Object)page);
        PagingTest.assertEquals((Object)Paging.PageType.PAGE, (Object)page.getType());
        PagingTest.assertFalse((boolean)page.isZeroBasedIdx());
        PagingTest.assertEquals((int)1, (int)page.getNumber());
        PagingTest.assertEquals((int)10, (int)page.getSize());
        Page window = this.paging.createWindow(1, 10);
        PagingTest.assertNotNull((Object)window);
        PagingTest.assertEquals((Object)Paging.PageType.WINDOW, (Object)window.getType());
        PagingTest.assertTrue((boolean)window.isZeroBasedIdx());
        PagingTest.assertEquals((int)1, (int)window.getNumber());
        PagingTest.assertEquals((int)10, (int)window.getSize());
    }

    public void testZeroRowsPage() {
        Cursor cursor = this.paging.createCursor(0, this.paging.createPage(1, 10));
        PagingTest.assertNotNull((Object)cursor);
        PagingTest.assertEquals((int)0, (int)cursor.getTotalRows());
        PagingTest.assertEquals((int)0, (int)cursor.getTotalPages());
        PagingTest.assertEquals((int)10, (int)cursor.getPageSize());
        PagingTest.assertFalse((boolean)cursor.isInRange());
        PagingTest.assertEquals((int)1, (int)cursor.getCurrentPage());
        PagingTest.assertEquals((int)-1, (int)cursor.getFirstPage());
        PagingTest.assertEquals((int)-1, (int)cursor.getLastPage());
        PagingTest.assertEquals((int)-1, (int)cursor.getPrevPage());
        PagingTest.assertEquals((int)-1, (int)cursor.getNextPage());
        PagingTest.assertEquals((int)0, (int)cursor.getStartRow());
        PagingTest.assertEquals((int)-1, (int)cursor.getEndRow());
        PagingTest.assertEquals((int)0, (int)cursor.getRowCount());
    }

    public void testOutOfBoundsPage() {
        Cursor cursor1 = this.paging.createCursor(1, this.paging.createPage(1, 1));
        PagingTest.assertNotNull((Object)cursor1);
        PagingTest.assertTrue((boolean)cursor1.isInRange());
        Cursor cursor2 = this.paging.createCursor(1, this.paging.createPage(2, 1));
        PagingTest.assertNotNull((Object)cursor2);
        PagingTest.assertFalse((boolean)cursor2.isInRange());
        Cursor cursor3 = this.paging.createCursor(1, this.paging.createPage(1, 2));
        PagingTest.assertNotNull((Object)cursor3);
        PagingTest.assertTrue((boolean)cursor3.isInRange());
        Cursor cursor4 = this.paging.createCursor(10, this.paging.createPage(5, 2));
        PagingTest.assertNotNull((Object)cursor4);
        PagingTest.assertTrue((boolean)cursor4.isInRange());
        Cursor cursor5 = this.paging.createCursor(10, this.paging.createPage(6, 2));
        PagingTest.assertNotNull((Object)cursor5);
        PagingTest.assertFalse((boolean)cursor5.isInRange());
        Cursor cursor6 = this.paging.createCursor(11, this.paging.createPage(5, 2));
        PagingTest.assertNotNull((Object)cursor6);
        PagingTest.assertTrue((boolean)cursor6.isInRange());
        Cursor cursor7 = this.paging.createCursor(11, this.paging.createPage(6, 2));
        PagingTest.assertNotNull((Object)cursor7);
        PagingTest.assertTrue((boolean)cursor7.isInRange());
        Cursor cursor8 = this.paging.createCursor(11, this.paging.createPage(0, 2));
        PagingTest.assertNotNull((Object)cursor8);
        PagingTest.assertFalse((boolean)cursor8.isInRange());
        this.paging.setZeroBasedPage(true);
        Cursor cursor10 = this.paging.createCursor(1, this.paging.createPage(0, 1));
        PagingTest.assertNotNull((Object)cursor10);
        PagingTest.assertTrue((boolean)cursor10.isInRange());
        Cursor cursor11 = this.paging.createCursor(1, this.paging.createPage(1, 1));
        PagingTest.assertNotNull((Object)cursor11);
        PagingTest.assertFalse((boolean)cursor11.isInRange());
        Cursor cursor12 = this.paging.createCursor(1, this.paging.createPage(0, 2));
        PagingTest.assertNotNull((Object)cursor12);
        PagingTest.assertTrue((boolean)cursor12.isInRange());
        Cursor cursor13 = this.paging.createCursor(10, this.paging.createPage(4, 2));
        PagingTest.assertNotNull((Object)cursor13);
        PagingTest.assertTrue((boolean)cursor13.isInRange());
        Cursor cursor14 = this.paging.createCursor(10, this.paging.createPage(5, 2));
        PagingTest.assertNotNull((Object)cursor14);
        PagingTest.assertFalse((boolean)cursor14.isInRange());
        Cursor cursor15 = this.paging.createCursor(11, this.paging.createPage(4, 2));
        PagingTest.assertNotNull((Object)cursor15);
        PagingTest.assertTrue((boolean)cursor15.isInRange());
        Cursor cursor16 = this.paging.createCursor(11, this.paging.createPage(5, 2));
        PagingTest.assertNotNull((Object)cursor16);
        PagingTest.assertTrue((boolean)cursor16.isInRange());
        Cursor cursor17 = this.paging.createCursor(11, this.paging.createPage(-1, 2));
        PagingTest.assertNotNull((Object)cursor17);
        PagingTest.assertFalse((boolean)cursor17.isInRange());
    }

    public void testTotalPage() {
        Cursor cursor1 = this.paging.createCursor(10, this.paging.createPage(1, 1));
        PagingTest.assertEquals((int)10, (int)cursor1.getTotalRows());
        PagingTest.assertEquals((int)10, (int)cursor1.getTotalPages());
        Cursor cursor2 = this.paging.createCursor(10, this.paging.createPage(1, 10));
        PagingTest.assertEquals((int)10, (int)cursor2.getTotalRows());
        PagingTest.assertEquals((int)1, (int)cursor2.getTotalPages());
        Cursor cursor3 = this.paging.createCursor(9, this.paging.createPage(1, 10));
        PagingTest.assertEquals((int)9, (int)cursor3.getTotalRows());
        PagingTest.assertEquals((int)1, (int)cursor3.getTotalPages());
        Cursor cursor4 = this.paging.createCursor(11, this.paging.createPage(1, 10));
        PagingTest.assertEquals((int)11, (int)cursor4.getTotalRows());
        PagingTest.assertEquals((int)2, (int)cursor4.getTotalPages());
        Cursor cursor5 = this.paging.createCursor(20, this.paging.createPage(1, 10));
        PagingTest.assertEquals((int)20, (int)cursor5.getTotalRows());
        PagingTest.assertEquals((int)2, (int)cursor5.getTotalPages());
    }

    public void testCursorPage() {
        Cursor cursor1 = this.paging.createCursor(10, this.paging.createPage(1, 1));
        PagingTest.assertEquals((int)1, (int)cursor1.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor1.getFirstPage());
        PagingTest.assertEquals((int)10, (int)cursor1.getLastPage());
        PagingTest.assertEquals((int)-1, (int)cursor1.getPrevPage());
        PagingTest.assertEquals((int)2, (int)cursor1.getNextPage());
        PagingTest.assertEquals((int)0, (int)cursor1.getStartRow());
        PagingTest.assertEquals((int)0, (int)cursor1.getEndRow());
        PagingTest.assertEquals((int)1, (int)cursor1.getRowCount());
        Cursor cursor2 = this.paging.createCursor(10, this.paging.createPage(2, 1));
        PagingTest.assertEquals((int)2, (int)cursor2.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor2.getFirstPage());
        PagingTest.assertEquals((int)10, (int)cursor2.getLastPage());
        PagingTest.assertEquals((int)1, (int)cursor2.getPrevPage());
        PagingTest.assertEquals((int)3, (int)cursor2.getNextPage());
        PagingTest.assertEquals((int)1, (int)cursor2.getStartRow());
        PagingTest.assertEquals((int)1, (int)cursor2.getEndRow());
        PagingTest.assertEquals((int)1, (int)cursor2.getRowCount());
        Cursor cursor3 = this.paging.createCursor(10, this.paging.createPage(1, 10));
        PagingTest.assertEquals((int)1, (int)cursor3.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor3.getFirstPage());
        PagingTest.assertEquals((int)1, (int)cursor3.getLastPage());
        PagingTest.assertEquals((int)-1, (int)cursor3.getPrevPage());
        PagingTest.assertEquals((int)-1, (int)cursor3.getNextPage());
        PagingTest.assertEquals((int)0, (int)cursor3.getStartRow());
        PagingTest.assertEquals((int)9, (int)cursor3.getEndRow());
        PagingTest.assertEquals((int)10, (int)cursor3.getRowCount());
        Cursor cursor4 = this.paging.createCursor(9, this.paging.createPage(1, 10));
        PagingTest.assertEquals((int)1, (int)cursor4.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor4.getFirstPage());
        PagingTest.assertEquals((int)1, (int)cursor4.getLastPage());
        PagingTest.assertEquals((int)-1, (int)cursor4.getPrevPage());
        PagingTest.assertEquals((int)-1, (int)cursor4.getNextPage());
        PagingTest.assertEquals((int)0, (int)cursor4.getStartRow());
        PagingTest.assertEquals((int)8, (int)cursor4.getEndRow());
        PagingTest.assertEquals((int)9, (int)cursor4.getRowCount());
        Cursor cursor5 = this.paging.createCursor(11, this.paging.createPage(1, 10));
        PagingTest.assertEquals((int)1, (int)cursor5.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor5.getFirstPage());
        PagingTest.assertEquals((int)2, (int)cursor5.getLastPage());
        PagingTest.assertEquals((int)-1, (int)cursor5.getPrevPage());
        PagingTest.assertEquals((int)2, (int)cursor5.getNextPage());
        PagingTest.assertEquals((int)0, (int)cursor5.getStartRow());
        PagingTest.assertEquals((int)9, (int)cursor5.getEndRow());
        PagingTest.assertEquals((int)10, (int)cursor5.getRowCount());
        Cursor cursor6 = this.paging.createCursor(20, this.paging.createPage(1, 10));
        PagingTest.assertEquals((int)1, (int)cursor6.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor6.getFirstPage());
        PagingTest.assertEquals((int)2, (int)cursor6.getLastPage());
        PagingTest.assertEquals((int)-1, (int)cursor6.getPrevPage());
        PagingTest.assertEquals((int)2, (int)cursor6.getNextPage());
        PagingTest.assertEquals((int)0, (int)cursor6.getStartRow());
        PagingTest.assertEquals((int)9, (int)cursor6.getEndRow());
        PagingTest.assertEquals((int)10, (int)cursor6.getRowCount());
        Cursor cursor7 = this.paging.createCursor(20, this.paging.createPage(2, 10));
        PagingTest.assertEquals((int)2, (int)cursor7.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor7.getFirstPage());
        PagingTest.assertEquals((int)2, (int)cursor7.getLastPage());
        PagingTest.assertEquals((int)1, (int)cursor7.getPrevPage());
        PagingTest.assertEquals((int)-1, (int)cursor7.getNextPage());
        PagingTest.assertEquals((int)10, (int)cursor7.getStartRow());
        PagingTest.assertEquals((int)19, (int)cursor7.getEndRow());
        PagingTest.assertEquals((int)10, (int)cursor7.getRowCount());
        Cursor cursor8 = this.paging.createCursor(11, this.paging.createPage(2, 10));
        PagingTest.assertEquals((int)2, (int)cursor8.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor8.getFirstPage());
        PagingTest.assertEquals((int)2, (int)cursor8.getLastPage());
        PagingTest.assertEquals((int)1, (int)cursor8.getPrevPage());
        PagingTest.assertEquals((int)-1, (int)cursor8.getNextPage());
        PagingTest.assertEquals((int)10, (int)cursor8.getStartRow());
        PagingTest.assertEquals((int)10, (int)cursor8.getEndRow());
        PagingTest.assertEquals((int)1, (int)cursor8.getRowCount());
    }

    public void testUnlimitedPage() {
        Cursor cursor1 = this.paging.createCursor(100, this.paging.createPage(1, -1));
        PagingTest.assertTrue((boolean)cursor1.isInRange());
        PagingTest.assertEquals((int)1, (int)cursor1.getCurrentPage());
        PagingTest.assertEquals((int)1, (int)cursor1.getFirstPage());
        PagingTest.assertEquals((int)1, (int)cursor1.getLastPage());
        PagingTest.assertEquals((int)-1, (int)cursor1.getPrevPage());
        PagingTest.assertEquals((int)-1, (int)cursor1.getNextPage());
        PagingTest.assertEquals((int)0, (int)cursor1.getStartRow());
        PagingTest.assertEquals((int)99, (int)cursor1.getEndRow());
        Cursor cursor2 = this.paging.createCursor(100, this.paging.createPage(2, -1));
        PagingTest.assertFalse((boolean)cursor2.isInRange());
    }

    public void testScrollPage() {
        int count = 0;
        long[] coll = new long[100];
        Cursor cursor = this.paging.createCursor(coll.length, this.paging.createPage(1, 10));
        while (cursor.isInRange()) {
            for (long i = (long)cursor.getStartRow(); i <= (long)cursor.getEndRow(); ++i) {
                coll[(int)i] = i;
                ++count;
            }
            cursor = this.paging.createCursor(coll.length, this.paging.createPage(cursor.getNextPage(), cursor.getPageSize()));
        }
        PagingTest.assertEquals((int)100, (int)count);
        for (int test = 0; test < count; ++test) {
            PagingTest.assertEquals((long)test, (long)coll[test]);
        }
    }

    public void testZeroRowsWindow() {
        Cursor rows = this.paging.createCursor(0, this.paging.createWindow(0, 10));
        PagingTest.assertNotNull((Object)rows);
        PagingTest.assertEquals((int)0, (int)rows.getTotalRows());
        PagingTest.assertFalse((boolean)rows.isInRange());
        PagingTest.assertEquals((int)10, (int)rows.getPageSize());
        PagingTest.assertEquals((int)0, (int)rows.getStartRow());
        PagingTest.assertEquals((int)-1, (int)rows.getEndRow());
        PagingTest.assertEquals((int)0, (int)rows.getRowCount());
        PagingTest.assertEquals((int)-1, (int)rows.getNextPage());
    }

    public void testOutOfBoundsWindow() {
        Cursor cursor1 = this.paging.createCursor(1, this.paging.createWindow(0, 1));
        PagingTest.assertNotNull((Object)cursor1);
        PagingTest.assertTrue((boolean)cursor1.isInRange());
        Cursor cursor2 = this.paging.createCursor(1, this.paging.createWindow(1, 1));
        PagingTest.assertNotNull((Object)cursor2);
        PagingTest.assertFalse((boolean)cursor2.isInRange());
        Cursor cursor3 = this.paging.createCursor(1, this.paging.createWindow(0, -1));
        PagingTest.assertNotNull((Object)cursor3);
        PagingTest.assertTrue((boolean)cursor3.isInRange());
    }

    public void testTotalWindow() {
        Cursor cursor1 = this.paging.createCursor(10, this.paging.createWindow(1, 1));
        PagingTest.assertEquals((int)10, (int)cursor1.getTotalRows());
    }

    public void testCursorWindow() {
        Cursor cursor1 = this.paging.createCursor(10, this.paging.createWindow(0, 1));
        PagingTest.assertEquals((int)0, (int)cursor1.getStartRow());
        PagingTest.assertEquals((int)0, (int)cursor1.getEndRow());
        PagingTest.assertEquals((int)1, (int)cursor1.getRowCount());
        PagingTest.assertEquals((int)1, (int)cursor1.getNextPage());
        Cursor cursor2 = this.paging.createCursor(10, this.paging.createWindow(0, 7));
        PagingTest.assertEquals((int)0, (int)cursor2.getStartRow());
        PagingTest.assertEquals((int)6, (int)cursor2.getEndRow());
        PagingTest.assertEquals((int)7, (int)cursor2.getRowCount());
        PagingTest.assertEquals((int)7, (int)cursor2.getNextPage());
        Cursor cursor3 = this.paging.createCursor(10, this.paging.createWindow(7, 7));
        PagingTest.assertEquals((int)7, (int)cursor3.getStartRow());
        PagingTest.assertEquals((int)9, (int)cursor3.getEndRow());
        PagingTest.assertEquals((int)3, (int)cursor3.getRowCount());
        PagingTest.assertEquals((int)-1, (int)cursor3.getNextPage());
        Cursor cursor4 = this.paging.createCursor(10, this.paging.createWindow(0, 10));
        PagingTest.assertEquals((int)0, (int)cursor4.getStartRow());
        PagingTest.assertEquals((int)9, (int)cursor4.getEndRow());
        PagingTest.assertEquals((int)10, (int)cursor4.getRowCount());
        PagingTest.assertEquals((int)-1, (int)cursor4.getNextPage());
        Cursor cursor5 = this.paging.createCursor(10, this.paging.createWindow(0, 11));
        PagingTest.assertEquals((int)0, (int)cursor5.getStartRow());
        PagingTest.assertEquals((int)9, (int)cursor5.getEndRow());
        PagingTest.assertEquals((int)10, (int)cursor5.getRowCount());
        PagingTest.assertEquals((int)-1, (int)cursor5.getNextPage());
    }

    public void testUnlimitedWindow() {
        Cursor cursor1 = this.paging.createCursor(100, this.paging.createWindow(0, -1));
        PagingTest.assertTrue((boolean)cursor1.isInRange());
        PagingTest.assertEquals((int)0, (int)cursor1.getStartRow());
        PagingTest.assertEquals((int)99, (int)cursor1.getEndRow());
        PagingTest.assertEquals((int)100, (int)cursor1.getRowCount());
        PagingTest.assertEquals((int)-1, (int)cursor1.getNextPage());
    }

    public void testScrollWindow() {
        int count = 0;
        long[] coll = new long[100];
        Cursor cursor = this.paging.createCursor(coll.length, this.paging.createWindow(0, 10));
        while (cursor.isInRange()) {
            for (long i = (long)cursor.getStartRow(); i <= (long)cursor.getEndRow(); ++i) {
                coll[(int)i] = i;
                ++count;
            }
            cursor = this.paging.createCursor(coll.length, this.paging.createWindow(cursor.getNextPage(), cursor.getPageSize()));
        }
        PagingTest.assertEquals((int)100, (int)count);
        for (int test = 0; test < count; ++test) {
            PagingTest.assertEquals((long)test, (long)coll[test]);
        }
    }
}

