/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.tests;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.FavouriteDocument;
import org.alfresco.rest.api.tests.client.data.MemberOfSite;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.workflow.api.model.ProcessInfo;
import org.alfresco.rest.workflow.api.model.Variable;
import org.alfresco.rest.workflow.api.tests.EnterpriseWorkflowTestApi;
import org.alfresco.rest.workflow.api.tests.WorkflowApiClient;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ISO8601DateFormat;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.http.HttpStatus;

@Category(value={OwnJVMTestsCategory.class})
public class ProcessWorkflowApiTest
extends EnterpriseWorkflowTestApi {
    @Test
    public void testCreateProcessInstanceWithId() throws Exception {
        final RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessDefinition processDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("@" + requestContext.getNetworkId() + "@activitiAdhoc").singleResult();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject createProcessObject = new JSONObject();
        createProcessObject.put((Object)"processDefinitionId", (Object)processDefinition.getId());
        final JSONObject variablesObject = new JSONObject();
        variablesObject.put((Object)"bpm_dueDate", (Object)ISO8601DateFormat.format((Date)new Date()));
        variablesObject.put((Object)"bpm_priority", (Object)1);
        variablesObject.put((Object)"bpm_description", (Object)"test description");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                variablesObject.put((Object)"bpm_assignee", (Object)requestContext.getRunAsUser());
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        createProcessObject.put((Object)"variables", (Object)variablesObject);
        ProcessInfo processRest = processesClient.createProcess(createProcessObject.toJSONString());
        Assert.assertNotNull((Object)processRest);
        Assert.assertNotNull((Object)processRest.getId());
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processRest.getId()).singleResult();
        Assert.assertEquals((Object)processInstance.getId(), (Object)processRest.getId());
        Assert.assertEquals((Object)processInstance.getStartActivityId(), (Object)processRest.getStartActivityId());
        Assert.assertEquals((Object)processInstance.getStartUserId(), (Object)processRest.getStartUserId());
        Assert.assertEquals((Object)processInstance.getStartTime(), (Object)processRest.getStartedAt());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)processRest.getProcessDefinitionId());
        Assert.assertEquals((Object)"activitiAdhoc", (Object)processRest.getProcessDefinitionKey());
        Assert.assertNull((Object)processRest.getBusinessKey());
        Assert.assertNull((Object)processRest.getDeleteReason());
        Assert.assertNull((Object)processRest.getDurationInMs());
        Assert.assertNull((Object)processRest.getEndActivityId());
        Assert.assertNull((Object)processRest.getEndedAt());
        Assert.assertNull((Object)processRest.getSuperProcessInstanceId());
        Map variables = this.activitiProcessEngine.getRuntimeService().getVariables(processRest.getId());
        Assert.assertEquals((Object)"test description", variables.get("bpm_description"));
        Assert.assertEquals((Object)1, variables.get("bpm_priority"));
        this.cleanupProcessInstance(processRest.getId());
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        this.publicApiClient.setRequestContext(new RequestContext(requestContext.getNetworkId(), tenantAdmin));
        processRest = processesClient.createProcess(createProcessObject.toJSONString());
        Assert.assertNotNull((Object)processRest);
        variables = this.activitiProcessEngine.getRuntimeService().getVariables(processRest.getId());
        Assert.assertEquals((Object)"test description", variables.get("bpm_description"));
        Assert.assertEquals((Object)1, variables.get("bpm_priority"));
        this.cleanupProcessInstance(processRest.getId());
        this.publicApiClient.setRequestContext(requestContext);
        createProcessObject = new JSONObject();
        createProcessObject.put((Object)"processDefinitionId", (Object)"unexisting");
        try {
            processesClient.createProcess(createProcessObject.toJSONString());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            this.assertErrorSummary("No workflow definition could be found with id 'unexisting'.", e.getHttpResponse());
        }
    }

    @Test
    public void testCreateProcessInstanceWithKey() throws Exception {
        final RequestContext requestContext = this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject createProcessObject = new JSONObject();
        createProcessObject.put((Object)"processDefinitionKey", (Object)"activitiAdhoc");
        final JSONObject variablesObject = new JSONObject();
        variablesObject.put((Object)"bpm_dueDate", (Object)"2013-09-30T00:00:00.000+0300");
        variablesObject.put((Object)"bpm_priority", (Object)1);
        variablesObject.put((Object)"bpm_description", (Object)"test description");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                variablesObject.put((Object)"bpm_assignee", (Object)requestContext.getRunAsUser());
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        createProcessObject.put((Object)"variables", (Object)variablesObject);
        ProcessInfo processRest = processesClient.createProcess(createProcessObject.toJSONString());
        Assert.assertNotNull((Object)processRest);
        Map variables = this.activitiProcessEngine.getRuntimeService().getVariables(processRest.getId());
        Assert.assertEquals((Object)"test description", variables.get("bpm_description"));
        Assert.assertEquals((Object)1, variables.get("bpm_priority"));
        this.cleanupProcessInstance(processRest.getId());
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        this.publicApiClient.setRequestContext(new RequestContext(requestContext.getNetworkId(), tenantAdmin));
        processRest = processesClient.createProcess(createProcessObject.toJSONString());
        Assert.assertNotNull((Object)processRest);
        variables = this.activitiProcessEngine.getRuntimeService().getVariables(processRest.getId());
        Assert.assertEquals((Object)"test description", variables.get("bpm_description"));
        Assert.assertEquals((Object)1, variables.get("bpm_priority"));
        this.cleanupProcessInstance(processRest.getId());
        this.publicApiClient.setRequestContext(requestContext);
        createProcessObject = new JSONObject();
        createProcessObject.put((Object)"processDefinitionKey", (Object)"activitiAdhoc2");
        try {
            processRest = processesClient.createProcess(createProcessObject.toJSONString());
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            this.assertErrorSummary("No workflow definition could be found with key 'activitiAdhoc2'.", e.getHttpResponse());
        }
    }

    @Test
    public void testCreateProcessInstanceWithNoParams() throws Exception {
        this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject createProcessObject = new JSONObject();
        try {
            processesClient.createProcess(createProcessObject.toJSONString());
            Assert.fail((String)"Exception excpected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMethodNotAllowedURIs() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        HttpResponse response = this.publicApiClient.get("public", "processes", null, null, null, null);
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        response = this.publicApiClient.put("public", "processes", null, null, null, null, null);
        Assert.assertEquals((long)405L, (long)response.getStatusCode());
        ProcessInfo processInfo = this.startAdhocProcess(requestContext, null);
        try {
            response = this.publicApiClient.get("public", "processes", processInfo.getId(), null, null, null);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = this.publicApiClient.post("public", "processes", processInfo.getId(), null, null, null);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = this.publicApiClient.put("public", "processes", processInfo.getId(), null, null, null, null);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = this.publicApiClient.get("public", "processes", processInfo.getId(), "activities", null, null);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = this.publicApiClient.post("public", "processes", processInfo.getId(), "activities", null, null);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = this.publicApiClient.delete("public", "processes", processInfo.getId(), "activities", null);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = this.publicApiClient.put("public", "processes", processInfo.getId(), "activities", null, null, null);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = this.publicApiClient.get("public", "processes", processInfo.getId(), "tasks", null, null);
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = this.publicApiClient.post("public", "processes", processInfo.getId(), "tasks", null, null);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = this.publicApiClient.delete("public", "processes", processInfo.getId(), "tasks", null);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
            response = this.publicApiClient.put("public", "processes", processInfo.getId(), "tasks", null, null, null);
            Assert.assertEquals((long)405L, (long)response.getStatusCode());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInfo.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInfo.getId());
    }

    @Test
    public void testCreateProcessInstanceForPooledReview() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processInfo = this.startReviewPooledProcess(requestContext);
        Assert.assertNotNull((Object)processInfo);
        Assert.assertNotNull((Object)processInfo.getId());
        this.cleanupProcessInstance(processInfo.getId());
    }

    @Test
    public void testCreateProcessInstanceForParallelReview() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processInfo = this.startParallelReviewProcess(requestContext);
        Assert.assertNotNull((Object)processInfo);
        Assert.assertNotNull((Object)processInfo.getId());
        this.cleanupProcessInstance(processInfo.getId());
    }

    @Test
    public void testCreateProcessInstanceFromOtherNetwork() throws Exception {
        final RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessDefinition processDefinition = (ProcessDefinition)this.activitiProcessEngine.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("@" + requestContext.getNetworkId() + "@activitiAdhoc").singleResult();
        RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
        RequestContext otherContext = new RequestContext(anotherNetwork.getId(), tenantAdmin);
        this.publicApiClient.setRequestContext(otherContext);
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject createProcessObject = new JSONObject();
        createProcessObject.put((Object)"processDefinitionId", (Object)processDefinition.getId());
        final JSONObject variablesObject = new JSONObject();
        variablesObject.put((Object)"bpm_dueDate", (Object)ISO8601DateFormat.format((Date)new Date()));
        variablesObject.put((Object)"bpm_priority", (Object)1);
        variablesObject.put((Object)"bpm_description", (Object)"test description");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                variablesObject.put((Object)"bpm_assignee", (Object)requestContext.getRunAsUser());
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        createProcessObject.put((Object)"variables", (Object)variablesObject);
        try {
            processesClient.createProcess(createProcessObject.toJSONString());
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testCreateProcessInstanceWithItems() throws Exception {
        final RequestContext requestContext = this.initApiClientWithTestUser();
        NodeRef[] docNodeRefs = this.createTestDocuments(requestContext);
        final ProcessInfo processRest = this.startAdhocProcess(requestContext, docNodeRefs);
        Assert.assertNotNull((Object)processRest);
        Map variables = this.activitiProcessEngine.getRuntimeService().getVariables(processRest.getId());
        Assert.assertEquals((Object)1, variables.get("bpm_priority"));
        final ActivitiScriptNode packageScriptNode = (ActivitiScriptNode)variables.get("bpm_package");
        Assert.assertNotNull((Object)packageScriptNode);
        final HashMap documentMap = new HashMap();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                List documentList = ProcessWorkflowApiTest.this.nodeService.getChildAssocs(packageScriptNode.getNodeRef());
                for (ChildAssociationRef childAssociationRef : documentList) {
                    FavouriteDocument doc = ProcessWorkflowApiTest.this.getTestFixture().getRepoService().getDocument(requestContext.getNetworkId(), childAssociationRef.getChildRef());
                    documentMap.put(doc.getName(), doc);
                }
                Task task = (Task)((TaskQuery)ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processRest.getId())).singleResult();
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)task.getAssignee());
                ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                Task task2 = (Task)((TaskQuery)ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processRest.getId())).singleResult();
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)task2.getAssignee());
                ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task2.getId());
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        Assert.assertEquals((long)2L, (long)documentMap.size());
        Assert.assertTrue((boolean)documentMap.containsKey("Test Doc1"));
        FavouriteDocument doc = (FavouriteDocument)documentMap.get("Test Doc1");
        Assert.assertEquals((Object)"Test Doc1", (Object)doc.getName());
        Assert.assertEquals((Object)"Test Doc1 Title", (Object)doc.getTitle());
        Assert.assertTrue((boolean)documentMap.containsKey("Test Doc2"));
        doc = (FavouriteDocument)documentMap.get("Test Doc2");
        Assert.assertEquals((Object)"Test Doc2", (Object)doc.getName());
        Assert.assertEquals((Object)"Test Doc2 Title", (Object)doc.getTitle());
        this.cleanupProcessInstance(processRest.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcessInstanceById() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        final ProcessInfo process = this.startAdhocProcess(requestContext, null);
        try {
            ProcessInfo processInfo = processesClient.findProcessById(process.getId());
            Assert.assertNotNull((Object)processInfo);
            Map variables = this.activitiProcessEngine.getRuntimeService().getVariables(processInfo.getId());
            Assert.assertEquals((Object)1, variables.get("bpm_priority"));
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInfo.getId()).singleResult();
            Assert.assertNotNull((Object)processInfo.getId());
            Assert.assertEquals((Object)processInstance.getId(), (Object)processInfo.getId());
            Assert.assertNotNull((Object)processInfo.getStartActivityId());
            Assert.assertEquals((Object)processInstance.getStartActivityId(), (Object)processInfo.getStartActivityId());
            Assert.assertNotNull((Object)processInfo.getStartUserId());
            Assert.assertEquals((Object)processInstance.getStartUserId(), (Object)processInfo.getStartUserId());
            Assert.assertNotNull((Object)processInfo.getStartedAt());
            Assert.assertEquals((Object)processInstance.getStartTime(), (Object)processInfo.getStartedAt());
            Assert.assertNotNull((Object)processInfo.getProcessDefinitionId());
            Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)processInfo.getProcessDefinitionId());
            Assert.assertNotNull((Object)processInfo.getProcessDefinitionKey());
            Assert.assertEquals((Object)"activitiAdhoc", (Object)processInfo.getProcessDefinitionKey());
            Assert.assertNull((Object)processInfo.getBusinessKey());
            Assert.assertNull((Object)processInfo.getDeleteReason());
            Assert.assertNull((Object)processInfo.getDurationInMs());
            Assert.assertNull((Object)processInfo.getEndActivityId());
            Assert.assertNull((Object)processInfo.getEndedAt());
            Assert.assertNull((Object)processInfo.getSuperProcessInstanceId());
            Assert.assertFalse((boolean)processInfo.isCompleted());
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    Task task = (Task)((TaskQuery)ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(process.getId())).singleResult();
                    ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                    task = (Task)((TaskQuery)ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(process.getId())).singleResult();
                    ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            processInstance = (HistoricProcessInstance)this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInfo.getId()).singleResult();
            processInfo = processesClient.findProcessById(processInfo.getId());
            Assert.assertNotNull((Object)processInfo.getId());
            Assert.assertEquals((Object)processInstance.getId(), (Object)processInfo.getId());
            Assert.assertNotNull((Object)processInfo.getStartActivityId());
            Assert.assertEquals((Object)processInstance.getStartActivityId(), (Object)processInfo.getStartActivityId());
            Assert.assertNotNull((Object)processInfo.getStartUserId());
            Assert.assertEquals((Object)processInstance.getStartUserId(), (Object)processInfo.getStartUserId());
            Assert.assertNotNull((Object)processInfo.getStartedAt());
            Assert.assertEquals((Object)processInstance.getStartTime(), (Object)processInfo.getStartedAt());
            Assert.assertNotNull((Object)processInfo.getProcessDefinitionId());
            Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)processInfo.getProcessDefinitionId());
            Assert.assertNotNull((Object)processInfo.getProcessDefinitionKey());
            Assert.assertEquals((Object)"activitiAdhoc", (Object)processInfo.getProcessDefinitionKey());
            Assert.assertNull((Object)processInfo.getBusinessKey());
            Assert.assertNull((Object)processInfo.getDeleteReason());
            Assert.assertNotNull((Object)processInfo.getDurationInMs());
            Assert.assertEquals((Object)processInstance.getDurationInMillis(), (Object)processInfo.getDurationInMs());
            Assert.assertNotNull((Object)processInfo.getEndActivityId());
            Assert.assertEquals((Object)processInstance.getEndActivityId(), (Object)processInfo.getEndActivityId());
            Assert.assertNotNull((Object)processInfo.getEndedAt());
            Assert.assertEquals((Object)processInstance.getEndTime(), (Object)processInfo.getEndedAt());
            Assert.assertNull((Object)processInfo.getSuperProcessInstanceId());
            Assert.assertTrue((boolean)processInfo.isCompleted());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process.getId());
    }

    @Test
    public void testGetProcessInstanceByIdUnexisting() throws Exception {
        this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        try {
            processesClient.findProcessById("unexisting");
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
            this.assertErrorSummary("The entity with id: unexisting was not found", expected.getHttpResponse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteProcessInstanceById() throws Exception {
        HistoricProcessInstance deletedInstance;
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
        tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
        RequestContext otherContext = new RequestContext(anotherNetwork.getId(), tenantAdmin);
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        ProcessInfo process = this.startAdhocProcess(requestContext, null);
        try {
            processesClient.deleteProcessById(process.getId());
            Assert.assertNull((Object)this.activitiProcessEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(process.getId()).singleResult());
            deletedInstance = (HistoricProcessInstance)this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(process.getId()).singleResult();
            Assert.assertNotNull((Object)deletedInstance);
            Assert.assertNotNull((Object)deletedInstance.getEndTime());
            Assert.assertEquals((Object)"deleted through REST API call", (Object)deletedInstance.getDeleteReason());
            try {
                processesClient.deleteProcessById(process.getId());
                Assert.fail((String)"expected exeception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process.getId());
        process = this.startAdhocProcess(requestContext, null);
        try {
            this.publicApiClient.setRequestContext(adminContext);
            processesClient.deleteProcessById(process.getId());
            Assert.assertNull((Object)this.activitiProcessEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(process.getId()).singleResult());
            deletedInstance = (HistoricProcessInstance)this.activitiProcessEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(process.getId()).singleResult();
            Assert.assertNotNull((Object)deletedInstance);
            Assert.assertNotNull((Object)deletedInstance.getEndTime());
            Assert.assertEquals((Object)"deleted through REST API call", (Object)deletedInstance.getDeleteReason());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process.getId());
        process = this.startAdhocProcess(requestContext, null);
        try {
            this.publicApiClient.setRequestContext(otherContext);
            processesClient.deleteProcessById(process.getId());
            Assert.fail((String)"Expect permission exception");
        }
        catch (PublicApiException e) {
            try {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)e.getHttpResponse().getStatusCode());
            }
            catch (Throwable throwable) {
                this.cleanupProcessInstance(process.getId());
                throw throwable;
            }
            this.cleanupProcessInstance(process.getId());
        }
        this.cleanupProcessInstance(process.getId());
    }

    @Test
    public void testDeleteProcessInstanceByIdUnexisting() throws Exception {
        this.initApiClientWithTestUser();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        try {
            processesClient.deleteProcessById("unexisting");
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
            this.assertErrorSummary("The entity with id: unexisting was not found", expected.getHttpResponse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcessInstances() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo process1 = this.startAdhocProcess(requestContext, null);
        ProcessInfo process2 = this.startAdhocProcess(requestContext, null);
        ProcessInfo process3 = this.startAdhocProcess(requestContext, null);
        try {
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            PublicApiClient.ListResponse<ProcessInfo> processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            HashMap<String, ProcessInfo> processMap = new HashMap<String, ProcessInfo>();
            for (ProcessInfo processRest : processList.getList()) {
                processMap.put(processRest.getId(), processRest);
            }
            Assert.assertTrue((boolean)processMap.containsKey(process1.getId()));
            Assert.assertTrue((boolean)processMap.containsKey(process2.getId()));
            Assert.assertTrue((boolean)processMap.containsKey(process3.getId()));
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            Assert.assertNull((Object)processList.getList().get(0).getProcessVariables());
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc2')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)0L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc')");
            paramMap.put("maxItems", "2");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)2L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc')");
            paramMap.put("maxItems", "3");
            paramMap.put("skipCount", "1");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)2L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc')");
            paramMap.put("maxItems", "5");
            paramMap.put("skipCount", "2");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)1L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc')");
            paramMap.put("maxItems", "5");
            paramMap.put("skipCount", "5");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)0L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(status = 'completed')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)0L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(status = 'any')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(status = 'active')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(status = 'active2')");
            try {
                processList = processesClient.getProcesses(paramMap);
                Assert.fail();
            }
            catch (PublicApiException publicApiException) {
                // empty catch block
            }
            paramMap = new HashMap();
            paramMap.put("where", "(variables/bpm_priority = 'd_int 1')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(variables/bpm_priority = 'd:int 1')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(variables/bpm_priority > 'd:int 1')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)0L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(variables/bpm_priority >= 'd:int 1')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(variables/bpm_priority < 'd:int 5')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(variables/bpm_priority <= 'd:int 4')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(variables/bpm_priority = 'd_int 5')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)0L, (long)processList.getList().size());
            Calendar dateCal = Calendar.getInstance();
            HashMap<String, Date> variablesToSet = new HashMap<String, Date>();
            variablesToSet.put("testVarDate", dateCal.getTime());
            this.activitiProcessEngine.getRuntimeService().setVariables(process1.getId(), variablesToSet);
            paramMap = new HashMap();
            paramMap.put("where", "(variables/testVarDate = 'd_datetime " + ISO8601DateFormat.format((Date)dateCal.getTime()) + "')");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)1L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(includeVariables=true)");
            paramMap.put("maxItems", "1");
            paramMap.put("skipCount", "0");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)1L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc' AND includeVariables = true)");
            paramMap.put("maxItems", "1");
            paramMap.put("skipCount", "0");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)1L, (long)processList.getList().size());
            ProcessInfo processInfo = processList.getList().get(0);
            Assert.assertNotNull((Object)processInfo.getProcessVariables());
            boolean foundDescription = false;
            boolean foundAssignee = false;
            for (Variable variable : processInfo.getProcessVariables()) {
                if ("bpm_description".equals(variable.getName())) {
                    Assert.assertEquals((Object)"d:text", (Object)variable.getType());
                    Assert.assertNull((Object)variable.getValue());
                    foundDescription = true;
                    continue;
                }
                if (!"bpm_assignee".equals(variable.getName())) continue;
                Assert.assertEquals((Object)"cm:person", (Object)variable.getType());
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)variable.getValue());
                foundAssignee = true;
            }
            Assert.assertTrue((boolean)foundDescription);
            Assert.assertTrue((boolean)foundAssignee);
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc' AND includeVariables = true)");
            paramMap.put("maxItems", "3");
            paramMap.put("skipCount", "1");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)2L, (long)processList.getList().size());
            processInfo = processList.getList().get(0);
            Assert.assertNotNull((Object)processInfo.getProcessVariables());
            foundDescription = false;
            foundAssignee = false;
            for (Variable variable : processInfo.getProcessVariables()) {
                if ("bpm_description".equals(variable.getName())) {
                    Assert.assertEquals((Object)"d:text", (Object)variable.getType());
                    Assert.assertNull((Object)variable.getValue());
                    foundDescription = true;
                    continue;
                }
                if (!"bpm_assignee".equals(variable.getName())) continue;
                Assert.assertEquals((Object)"cm:person", (Object)variable.getType());
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)variable.getValue());
                foundAssignee = true;
            }
            Assert.assertTrue((boolean)foundDescription);
            Assert.assertTrue((boolean)foundAssignee);
            paramMap = new HashMap();
            paramMap.put("where", "(processDefinitionKey = 'activitiAdhoc' AND includeVariables = true)");
            paramMap.put("maxItems", "4");
            paramMap.put("skipCount", "5");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)0L, (long)processList.getList().size());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process1.getId(), process2.getId(), process3.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process1.getId(), process2.getId(), process3.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcessInstancesWithDifferentProcessDefs() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo process1 = this.startAdhocProcess(requestContext, null);
        ProcessInfo process2 = this.startParallelReviewProcess(requestContext);
        ProcessInfo process3 = this.startReviewPooledProcess(requestContext);
        try {
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            PublicApiClient.ListResponse<ProcessInfo> processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            paramMap = new HashMap();
            paramMap.put("where", "(includeVariables=true)");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process1.getId(), process2.getId(), process3.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process1.getId(), process2.getId(), process3.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcessInstancesWithPaging() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo process1 = this.startAdhocProcess(requestContext, null);
        ProcessInfo process2 = this.startAdhocProcess(requestContext, null);
        ProcessInfo process3 = this.startAdhocProcess(requestContext, null);
        try {
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("processDefinitionId", process1.getProcessDefinitionId());
            JSONObject processListJSONObject = processesClient.getProcessesJSON(params);
            Assert.assertNotNull((Object)processListJSONObject);
            JSONObject paginationJSON = (JSONObject)processListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
            JSONArray jsonEntries = (JSONArray)processListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)3L, (long)jsonEntries.size());
            params.clear();
            params.put("maxItems", "2");
            params.put("processDefinitionId", process1.getProcessDefinitionId());
            processListJSONObject = processesClient.getProcessesJSON(params);
            Assert.assertNotNull((Object)processListJSONObject);
            paginationJSON = (JSONObject)processListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)true, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)processListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)2L, (long)jsonEntries.size());
            params.clear();
            params.put("skipCount", "1");
            params.put("processDefinitionId", process1.getProcessDefinitionId());
            processListJSONObject = processesClient.getProcessesJSON(params);
            Assert.assertNotNull((Object)processListJSONObject);
            paginationJSON = (JSONObject)processListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)1L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)processListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)2L, (long)jsonEntries.size());
            params.clear();
            params.put("maxItems", "3");
            params.put("skipCount", "2");
            params.put("processDefinitionId", process1.getProcessDefinitionId());
            processListJSONObject = processesClient.getProcessesJSON(params);
            Assert.assertNotNull((Object)processListJSONObject);
            paginationJSON = (JSONObject)processListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)1L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)processListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)1L, (long)jsonEntries.size());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process1.getId(), process2.getId(), process3.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process1.getId(), process2.getId(), process3.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcessInstancesWithSorting() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo process1 = this.startAdhocProcess(requestContext, null, "akey");
        ProcessInfo process2 = this.startAdhocProcess(requestContext, null, "bkey");
        ProcessInfo process3 = this.startAdhocProcess(requestContext, null, "aakey");
        try {
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("orderBy", "businessKey ASC");
            PublicApiClient.ListResponse<ProcessInfo> processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            Assert.assertEquals((Object)process3.getId(), (Object)processList.getList().get(0).getId());
            Assert.assertEquals((Object)process1.getId(), (Object)processList.getList().get(1).getId());
            Assert.assertEquals((Object)process2.getId(), (Object)processList.getList().get(2).getId());
            paramMap.put("orderBy", "businessKey DESC");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            Assert.assertEquals((long)3L, (long)processList.getList().size());
            Assert.assertEquals((Object)process2.getId(), (Object)processList.getList().get(0).getId());
            Assert.assertEquals((Object)process1.getId(), (Object)processList.getList().get(1).getId());
            Assert.assertEquals((Object)process3.getId(), (Object)processList.getList().get(2).getId());
            paramMap.put("orderBy", "startedAt ASC");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            paramMap.put("orderBy", "endedAt ASC");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            paramMap.put("orderBy", "durationInMillis ASC");
            processList = processesClient.getProcesses(paramMap);
            Assert.assertNotNull(processList);
            paramMap.put("orderBy", "startedAt, endedAt");
            try {
                processList = processesClient.getProcesses(paramMap);
                Assert.fail();
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
            paramMap.put("orderBy", "businessKey2 ASC");
            try {
                processList = processesClient.getProcesses(paramMap);
                Assert.fail();
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
            try {
                paramMap.put("orderBy", "businessKey ASC2");
                processList = processesClient.getProcesses(paramMap);
                Assert.fail((String)"forbidden expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process1.getId(), process2.getId(), process3.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process1.getId(), process2.getId(), process3.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcessTasks() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
        tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
        RequestContext otherContext = new RequestContext(anotherNetwork.getId(), tenantAdmin);
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherPersonContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        ProcessInfo process1 = this.startAdhocProcess(requestContext, null);
        try {
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            JSONObject tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
            Assert.assertNotNull((Object)tasksJSON);
            JSONArray entriesJSON = (JSONArray)tasksJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 1 ? 1 : 0) != 0);
            JSONObject taskJSONObject = (JSONObject)((JSONObject)entriesJSON.get(0)).get((Object)"entry");
            Assert.assertNotNull((Object)taskJSONObject.get((Object)"id"));
            Assert.assertEquals((Object)process1.getId(), (Object)taskJSONObject.get((Object)"processId"));
            Assert.assertEquals((Object)process1.getProcessDefinitionId(), (Object)taskJSONObject.get((Object)"processDefinitionId"));
            Assert.assertEquals((Object)"adhocTask", (Object)taskJSONObject.get((Object)"activityDefinitionId"));
            Assert.assertEquals((Object)"Adhoc Task", (Object)taskJSONObject.get((Object)"name"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"assignee"));
            Assert.assertEquals((Object)2L, (Object)taskJSONObject.get((Object)"priority"));
            Assert.assertEquals((Object)"wf:adhocTask", (Object)taskJSONObject.get((Object)"formResourceKey"));
            Assert.assertNull((Object)taskJSONObject.get((Object)"endedAt"));
            Assert.assertNull((Object)taskJSONObject.get((Object)"durationInMs"));
            paramMap = new HashMap();
            paramMap.put("status", "active");
            tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
            Assert.assertNotNull((Object)tasksJSON);
            entriesJSON = (JSONArray)tasksJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 1 ? 1 : 0) != 0);
            paramMap = new HashMap();
            paramMap.put("status", "completed");
            tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
            Assert.assertNotNull((Object)tasksJSON);
            entriesJSON = (JSONArray)tasksJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 0 ? 1 : 0) != 0);
            paramMap = new HashMap();
            try {
                processesClient.getTasks("fakeid", paramMap);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The entity with id: fakeid was not found", expected.getHttpResponse());
            }
            this.publicApiClient.setRequestContext(adminContext);
            paramMap = new HashMap();
            tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
            Assert.assertNotNull((Object)tasksJSON);
            entriesJSON = (JSONArray)tasksJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 1 ? 1 : 0) != 0);
            this.publicApiClient.setRequestContext(otherContext);
            paramMap = new HashMap();
            try {
                tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
                Assert.fail((String)"forbidden expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(otherPersonContext);
            paramMap = new HashMap();
            try {
                tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
                Assert.fail((String)"forbidden expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)e.getHttpResponse().getStatusCode());
            }
            final Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(process1.getId())).singleResult();
            this.activitiProcessEngine.getTaskService().addCandidateUser(task.getId(), otherPersonContext.getRunAsUser());
            this.publicApiClient.setRequestContext(otherPersonContext);
            paramMap = new HashMap();
            tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
            Assert.assertNotNull((Object)tasksJSON);
            entriesJSON = (JSONArray)tasksJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 1 ? 1 : 0) != 0);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            this.publicApiClient.setRequestContext(requestContext);
            paramMap = new HashMap();
            paramMap.put("status", "any");
            tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
            Assert.assertNotNull((Object)tasksJSON);
            entriesJSON = (JSONArray)tasksJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
            this.publicApiClient.setRequestContext(otherPersonContext);
            paramMap = new HashMap();
            paramMap.put("status", "any");
            tasksJSON = processesClient.getTasks(process1.getId(), paramMap);
            Assert.assertNotNull((Object)tasksJSON);
            entriesJSON = (JSONArray)tasksJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process1.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process1.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcessActivities() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
        tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
        RequestContext otherContext = new RequestContext(anotherNetwork.getId(), tenantAdmin);
        ProcessInfo process1 = this.startAdhocProcess(requestContext, null);
        try {
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            JSONObject activitiesJSON = processesClient.getActivities(process1.getId(), paramMap);
            Assert.assertNotNull((Object)activitiesJSON);
            JSONArray entriesJSON = (JSONArray)activitiesJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
            HashMap<String, JSONObject> activitiesMap = new HashMap<String, JSONObject>();
            for (Object entry : entriesJSON) {
                JSONObject jsonEntry = (JSONObject)entry;
                JSONObject activityJSONObject = (JSONObject)jsonEntry.get((Object)"entry");
                activitiesMap.put((String)activityJSONObject.get((Object)"activityDefinitionId"), activityJSONObject);
            }
            JSONObject activityJSONObject = (JSONObject)activitiesMap.get("start");
            Assert.assertNotNull((Object)activityJSONObject);
            Assert.assertNotNull((Object)activityJSONObject.get((Object)"id"));
            Assert.assertEquals((Object)"start", (Object)activityJSONObject.get((Object)"activityDefinitionId"));
            Assert.assertNull((Object)activityJSONObject.get((Object)"activityDefinitionName"));
            Assert.assertEquals((Object)"startEvent", (Object)activityJSONObject.get((Object)"activityDefinitionType"));
            Assert.assertNotNull((Object)activityJSONObject.get((Object)"startedAt"));
            Assert.assertNotNull((Object)activityJSONObject.get((Object)"endedAt"));
            Assert.assertNotNull((Object)activityJSONObject.get((Object)"durationInMs"));
            activityJSONObject = (JSONObject)activitiesMap.get("adhocTask");
            Assert.assertNotNull((Object)activityJSONObject);
            Assert.assertNotNull((Object)activityJSONObject.get((Object)"id"));
            Assert.assertEquals((Object)"adhocTask", (Object)activityJSONObject.get((Object)"activityDefinitionId"));
            Assert.assertEquals((Object)"Adhoc Task", (Object)activityJSONObject.get((Object)"activityDefinitionName"));
            Assert.assertEquals((Object)"userTask", (Object)activityJSONObject.get((Object)"activityDefinitionType"));
            Assert.assertNotNull((Object)activityJSONObject.get((Object)"startedAt"));
            Assert.assertNull((Object)activityJSONObject.get((Object)"endedAt"));
            Assert.assertNull((Object)activityJSONObject.get((Object)"durationInMs"));
            paramMap = new HashMap();
            paramMap.put("status", "active");
            activitiesJSON = processesClient.getActivities(process1.getId(), paramMap);
            Assert.assertNotNull((Object)activitiesJSON);
            entriesJSON = (JSONArray)activitiesJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 1 ? 1 : 0) != 0);
            paramMap = new HashMap();
            paramMap.put("status", "completed");
            activitiesJSON = processesClient.getActivities(process1.getId(), paramMap);
            Assert.assertNotNull((Object)activitiesJSON);
            entriesJSON = (JSONArray)activitiesJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 1 ? 1 : 0) != 0);
            paramMap = new HashMap();
            try {
                processesClient.getActivities("fakeid", paramMap);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The entity with id: fakeid was not found", expected.getHttpResponse());
            }
            this.publicApiClient.setRequestContext(adminContext);
            paramMap = new HashMap();
            activitiesJSON = processesClient.getActivities(process1.getId(), paramMap);
            Assert.assertNotNull((Object)activitiesJSON);
            entriesJSON = (JSONArray)activitiesJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
            this.publicApiClient.setRequestContext(otherContext);
            paramMap = new HashMap();
            try {
                processesClient.getActivities(process1.getId(), paramMap);
                Assert.fail((String)"forbidden expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(process1.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(process1.getId());
    }

    @Test
    public void getProcessImage() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processRest = this.startAdhocProcess(requestContext, null);
        HttpResponse response = this.publicApiClient.processesClient().getImage(processRest.getId());
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        this.cleanupProcessInstance(processRest.getId());
        try {
            response = this.publicApiClient.processesClient().getImage("fakeId");
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMNT12382() throws Exception {
        this.currentNetwork = this.getTestFixture().getRandomNetwork();
        RepoService.TestPerson initiator = this.currentNetwork.getPeople().get(0);
        RequestContext requestContext = new RequestContext(this.currentNetwork.getId(), initiator.getId());
        this.publicApiClient.setRequestContext(requestContext);
        ProcessInfo processInfo = this.startReviewPooledProcess(requestContext);
        final List persons = (List)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<RepoService.TestPerson>>(){

            public List<RepoService.TestPerson> execute() throws Throwable {
                ArrayList<RepoService.TestPerson> persons = new ArrayList<RepoService.TestPerson>();
                persons.add(ProcessWorkflowApiTest.this.currentNetwork.createUser(new PersonInfo("Maxim0", "Bobyleu0", "maxim0.bobyleu0", "password", null, "skype", "location", "telephone", "mob", "instant", "google")));
                persons.add(ProcessWorkflowApiTest.this.currentNetwork.createUser(new PersonInfo("Maxim1", "Bobyleu1", "maxim1.bobyleu1", "password", null, "skype", "location", "telephone", "mob", "instant", "google")));
                persons.add(ProcessWorkflowApiTest.this.currentNetwork.createUser(new PersonInfo("Maxim2", "Bobyleu2", "maxim2.bobyleu2", "password", null, "skype", "location", "telephone", "mob", "instant", "google")));
                return persons;
            }
        }, false, true);
        final MemberOfSite memberOfSite = this.currentNetwork.getSiteMemberships(initiator.getId()).get(0);
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RepoService.TestSite initiatorSite = (RepoService.TestSite)memberOfSite.getSite();
                        initiatorSite.inviteToSite(((RepoService.TestPerson)persons.get(0)).getId(), memberOfSite.getRole());
                        initiatorSite.inviteToSite(((RepoService.TestPerson)persons.get(1)).getId(), memberOfSite.getRole());
                        initiatorSite.inviteToSite(((RepoService.TestPerson)persons.get(2)).getId(), SiteRole.SiteConsumer == memberOfSite.getRole() ? SiteRole.SiteCollaborator : SiteRole.SiteConsumer);
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName(), (String)ProcessWorkflowApiTest.this.currentNetwork.getId());
                return null;
            }
        }, false, true);
        String processId = processInfo.getId();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject initiatorItems = processesClient.findProcessItems(processId);
        requestContext = new RequestContext(this.currentNetwork.getId(), ((RepoService.TestPerson)persons.get(0)).getId());
        this.publicApiClient.setRequestContext(requestContext);
        JSONObject items1 = processesClient.findProcessItems(processId);
        Assert.assertEquals((Object)initiatorItems.toJSONString(), (Object)items1.toJSONString());
        requestContext = new RequestContext(this.currentNetwork.getId(), ((RepoService.TestPerson)persons.get(2)).getId());
        this.publicApiClient.setRequestContext(requestContext);
        try {
            JSONObject items2 = processesClient.findProcessItems(processId);
            Assert.fail((String)"User not from group should not see items.");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        TaskService taskService = this.activitiProcessEngine.getTaskService();
        Task task = (Task)((TaskQuery)taskService.createTaskQuery().processInstanceId(processId)).singleResult();
        RepoService.TestPerson assignee = (RepoService.TestPerson)persons.get(1);
        taskService.setAssignee(task.getId(), assignee.getId());
        requestContext = new RequestContext(this.currentNetwork.getId(), assignee.getId());
        this.publicApiClient.setRequestContext(requestContext);
        JSONObject items3 = processesClient.findProcessItems(processId);
        Assert.assertEquals((Object)initiatorItems.toJSONString(), (Object)items3.toJSONString());
        requestContext = new RequestContext(this.currentNetwork.getId(), ((RepoService.TestPerson)persons.get(0)).getId());
        this.publicApiClient.setRequestContext(requestContext);
        try {
            JSONObject items4 = processesClient.findProcessItems(processId);
            Assert.fail((String)"User from group should not see items for claimed task by another user.");
        }
        catch (PublicApiException e) {
            try {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
            catch (Throwable throwable) {
                this.cleanupProcessInstance(processId);
                throw throwable;
            }
            this.cleanupProcessInstance(processId);
        }
        this.cleanupProcessInstance(processId);
    }

    @Test
    public void testGetProcessItems() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        NodeRef[] docNodeRefs = this.createTestDocuments(requestContext);
        ProcessInfo processRest = this.startAdhocProcess(requestContext, docNodeRefs);
        Assert.assertNotNull((Object)processRest);
        String newProcessInstanceId = processRest.getId();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject itemsJSON = processesClient.findProcessItems(newProcessInstanceId);
        Assert.assertNotNull((Object)itemsJSON);
        JSONArray entriesJSON = (JSONArray)itemsJSON.get((Object)"entries");
        Assert.assertNotNull((Object)entriesJSON);
        Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
        boolean doc1Found = false;
        boolean doc2Found = false;
        for (Object entryObject : entriesJSON) {
            JSONObject entryObjectJSON = (JSONObject)entryObject;
            JSONObject entryJSON = (JSONObject)entryObjectJSON.get((Object)"entry");
            if (entryJSON.get((Object)"name").equals("Test Doc1")) {
                doc1Found = true;
                Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)entryJSON.get((Object)"id"));
                Assert.assertEquals((Object)"Test Doc1", (Object)entryJSON.get((Object)"name"));
                Assert.assertEquals((Object)"Test Doc1 Title", (Object)entryJSON.get((Object)"title"));
                Assert.assertEquals((Object)"Test Doc1 Description", (Object)entryJSON.get((Object)"description"));
                Assert.assertNotNull((Object)entryJSON.get((Object)"createdAt"));
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)entryJSON.get((Object)"createdBy"));
                Assert.assertNotNull((Object)entryJSON.get((Object)"modifiedAt"));
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)entryJSON.get((Object)"modifiedBy"));
                Assert.assertNotNull((Object)entryJSON.get((Object)"size"));
                Assert.assertNotNull((Object)entryJSON.get((Object)"mimeType"));
                continue;
            }
            doc2Found = true;
            Assert.assertEquals((Object)docNodeRefs[1].getId(), (Object)entryJSON.get((Object)"id"));
            Assert.assertEquals((Object)"Test Doc2", (Object)entryJSON.get((Object)"name"));
            Assert.assertEquals((Object)"Test Doc2 Title", (Object)entryJSON.get((Object)"title"));
            Assert.assertEquals((Object)"Test Doc2 Description", (Object)entryJSON.get((Object)"description"));
            Assert.assertNotNull((Object)entryJSON.get((Object)"createdAt"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)entryJSON.get((Object)"createdBy"));
            Assert.assertNotNull((Object)entryJSON.get((Object)"modifiedAt"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)entryJSON.get((Object)"modifiedBy"));
            Assert.assertNotNull((Object)entryJSON.get((Object)"size"));
            Assert.assertNotNull((Object)entryJSON.get((Object)"mimeType"));
        }
        Assert.assertTrue((boolean)doc1Found);
        Assert.assertTrue((boolean)doc2Found);
        this.cleanupProcessInstance(processRest.getId());
        try {
            processesClient.findProcessItems("fakeid");
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    @Test
    public void testGetProcessItem() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        NodeRef[] docNodeRefs = this.createTestDocuments(requestContext);
        ProcessInfo processRest = this.startAdhocProcess(requestContext, docNodeRefs);
        Assert.assertNotNull((Object)processRest);
        String newProcessInstanceId = processRest.getId();
        WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
        JSONObject itemJSON = processesClient.findProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
        Assert.assertNotNull((Object)itemJSON);
        Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
        Assert.assertEquals((Object)"Test Doc1", (Object)itemJSON.get((Object)"name"));
        Assert.assertEquals((Object)"Test Doc1 Title", (Object)itemJSON.get((Object)"title"));
        Assert.assertEquals((Object)"Test Doc1 Description", (Object)itemJSON.get((Object)"description"));
        Assert.assertNotNull((Object)itemJSON.get((Object)"createdAt"));
        Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)itemJSON.get((Object)"createdBy"));
        Assert.assertNotNull((Object)itemJSON.get((Object)"modifiedAt"));
        Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)itemJSON.get((Object)"modifiedBy"));
        Assert.assertNotNull((Object)itemJSON.get((Object)"size"));
        Assert.assertNotNull((Object)itemJSON.get((Object)"mimeType"));
        this.cleanupProcessInstance(processRest.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddProcessItem() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        NodeRef[] docNodeRefs = this.createTestDocuments(requestContext);
        ProcessInfo processRest = this.startAdhocProcess(requestContext, null);
        try {
            Assert.assertNotNull((Object)processRest);
            String newProcessInstanceId = processRest.getId();
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            JSONObject createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            processesClient.addProcessItem(newProcessInstanceId, createItemObject.toJSONString());
            JSONObject itemJSON = this.publicApiClient.processesClient().findProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            Assert.assertEquals((Object)"Test Doc1", (Object)itemJSON.get((Object)"name"));
            Assert.assertEquals((Object)"Test Doc1 Title", (Object)itemJSON.get((Object)"title"));
            Assert.assertEquals((Object)"Test Doc1 Description", (Object)itemJSON.get((Object)"description"));
            Assert.assertNotNull((Object)itemJSON.get((Object)"createdAt"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)itemJSON.get((Object)"createdBy"));
            Assert.assertNotNull((Object)itemJSON.get((Object)"modifiedAt"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)itemJSON.get((Object)"modifiedBy"));
            Assert.assertNotNull((Object)itemJSON.get((Object)"size"));
            Assert.assertNotNull((Object)itemJSON.get((Object)"mimeType"));
            createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)"blablabla");
            try {
                processesClient.addProcessItem(newProcessInstanceId, createItemObject.toJSONString());
                Assert.fail((String)"not found expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteProcessItem() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        NodeRef[] docNodeRefs = this.createTestDocuments(requestContext);
        ProcessInfo processRest = this.startAdhocProcess(requestContext, docNodeRefs);
        try {
            Assert.assertNotNull((Object)processRest);
            String newProcessInstanceId = processRest.getId();
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            processesClient.deleteProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
            try {
                this.publicApiClient.processesClient().findProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The entity with id: " + docNodeRefs[0].getId() + " was not found", expected.getHttpResponse());
            }
            try {
                processesClient.deleteProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
                Assert.fail((String)"Expected not found");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteProcessItemWithAdmin() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        this.publicApiClient.setRequestContext(adminContext);
        NodeRef[] docNodeRefs = this.createTestDocuments(adminContext);
        ProcessInfo processRest = this.startAdhocProcess(adminContext, docNodeRefs);
        try {
            Assert.assertNotNull((Object)processRest);
            String newProcessInstanceId = processRest.getId();
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            processesClient.deleteProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
            try {
                this.publicApiClient.processesClient().findProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The entity with id: " + docNodeRefs[0].getId() + " was not found", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
        this.publicApiClient.setRequestContext(requestContext);
        docNodeRefs = this.createTestDocuments(requestContext);
        ProcessInfo processRestDefaultUser = this.startAdhocProcess(requestContext, docNodeRefs);
        try {
            Assert.assertNotNull((Object)processRestDefaultUser);
            this.publicApiClient.setRequestContext(adminContext);
            String newProcessInstanceId = processRestDefaultUser.getId();
            WorkflowApiClient.ProcessesClient processesClient = this.publicApiClient.processesClient();
            processesClient.deleteProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
            try {
                this.publicApiClient.processesClient().findProcessItem(newProcessInstanceId, docNodeRefs[0].getId());
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The entity with id: " + docNodeRefs[0].getId() + " was not found", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRestDefaultUser.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRestDefaultUser.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetProcessVariables() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
        tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
        RequestContext otherContext = new RequestContext(anotherNetwork.getId(), tenantAdmin);
        ProcessInfo processRest = this.startAdhocProcess(requestContext, null);
        try {
            Assert.assertNotNull((Object)processRest);
            String processInstanceId = processRest.getId();
            JSONObject processvariables = this.publicApiClient.processesClient().getProcessvariables(processInstanceId);
            Assert.assertNotNull((Object)processvariables);
            this.validateVariablesResponse(processvariables, requestContext.getRunAsUser());
            this.publicApiClient.setRequestContext(adminContext);
            processvariables = this.publicApiClient.processesClient().getProcessvariables(processInstanceId);
            Assert.assertNotNull((Object)processvariables);
            this.validateVariablesResponse(processvariables, requestContext.getRunAsUser());
            this.publicApiClient.setRequestContext(otherContext);
            try {
                processvariables = this.publicApiClient.processesClient().getProcessvariables(processInstanceId);
                Assert.fail((String)"forbidden expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)e.getHttpResponse().getStatusCode());
            }
            try {
                processvariables = this.publicApiClient.processesClient().getProcessvariables("fakeid");
                Assert.fail((String)"not found expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
    }

    protected void validateVariablesResponse(JSONObject processvariables, String user) {
        HashMap<String, JSONObject> variablesByName = new HashMap<String, JSONObject>();
        JSONObject entry = null;
        JSONArray entries = (JSONArray)processvariables.get((Object)"entries");
        Assert.assertNotNull((Object)entries);
        for (int i = 0; i < entries.size(); ++i) {
            entry = (JSONObject)entries.get(i);
            Assert.assertNotNull((Object)entry);
            entry = (JSONObject)entry.get((Object)"entry");
            Assert.assertNotNull((Object)entry);
            variablesByName.put((String)entry.get((Object)"name"), entry);
        }
        JSONObject variable = (JSONObject)variablesByName.get("bpm_description");
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"d:text", (Object)variable.get((Object)"type"));
        Assert.assertNull((Object)variable.get((Object)"value"));
        variable = (JSONObject)variablesByName.get("bpm_percentComplete");
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"d:int", (Object)variable.get((Object)"type"));
        Assert.assertEquals((Object)0L, (Object)variable.get((Object)"value"));
        variable = (JSONObject)variablesByName.get("bpm_sendEMailNotifications");
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"d:boolean", (Object)variable.get((Object)"type"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)variable.get((Object)"value"));
        variable = (JSONObject)variablesByName.get("bpm_package");
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"bpm:workflowPackage", (Object)variable.get((Object)"type"));
        Assert.assertNotNull((Object)variable.get((Object)"value"));
        variable = (JSONObject)variablesByName.get("bpm_assignee");
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"cm:person", (Object)variable.get((Object)"type"));
        Assert.assertEquals((Object)user, (Object)variable.get((Object)"value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateVariablesPresentInModel() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processInstance = this.startAdhocProcess(requestContext, null);
        try {
            JSONArray variablesArray = new JSONArray();
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"bpm_percentComplete");
            variableBody.put((Object)"value", (Object)20);
            variableBody.put((Object)"type", (Object)"d:int");
            variablesArray.add((Object)variableBody);
            variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"bpm_workflowPriority");
            variableBody.put((Object)"value", (Object)50);
            variableBody.put((Object)"type", (Object)"d:int");
            variablesArray.add((Object)variableBody);
            JSONObject result = this.publicApiClient.processesClient().createVariables(processInstance.getId(), variablesArray);
            Assert.assertNotNull((Object)result);
            JSONObject resultObject = (JSONObject)result.get((Object)"list");
            JSONArray resultList = (JSONArray)resultObject.get((Object)"entries");
            Assert.assertEquals((long)2L, (long)resultList.size());
            JSONObject firstResultObject = (JSONObject)((JSONObject)resultList.get(0)).get((Object)"entry");
            Assert.assertEquals((Object)"bpm_percentComplete", (Object)firstResultObject.get((Object)"name"));
            Assert.assertEquals((Object)20L, (Object)firstResultObject.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)firstResultObject.get((Object)"type"));
            Assert.assertEquals((Object)20, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "bpm_percentComplete"));
            JSONObject secondResultObject = (JSONObject)((JSONObject)resultList.get(1)).get((Object)"entry");
            Assert.assertEquals((Object)"bpm_workflowPriority", (Object)secondResultObject.get((Object)"name"));
            Assert.assertEquals((Object)50L, (Object)secondResultObject.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)secondResultObject.get((Object)"type"));
            Assert.assertEquals((Object)50, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "bpm_workflowPriority"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateProcessVariables() throws Exception {
        JSONObject result;
        JSONObject resultEntry;
        JSONObject variableJson;
        String processId;
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        ProcessInfo processRest = this.startAdhocProcess(requestContext, null);
        try {
            Assert.assertNotNull((Object)processRest);
            processId = processRest.getId();
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"newVariable");
            variableJson.put((Object)"value", (Object)1234L);
            variableJson.put((Object)"type", (Object)"d:long");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "newVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)1234L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:long", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)1234L, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "newVariable"));
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"stringVariable");
            variableJson.put((Object)"value", (Object)"This is a string value");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "stringVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"stringVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)"This is a string value", (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:text", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"This is a string value", (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "stringVariable"));
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"newVariable");
            variableJson.put((Object)"value", (Object)4567L);
            variableJson.put((Object)"type", (Object)"d:long");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "newVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)4567L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:long", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)4567L, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "newVariable"));
            JSONObject processvariables = this.publicApiClient.processesClient().getProcessvariables(processId);
            Assert.assertNotNull((Object)processvariables);
            JSONObject newVariableEntry = null;
            JSONArray entries = (JSONArray)processvariables.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            for (int i = 0; i < entries.size(); ++i) {
                JSONObject entry = (JSONObject)entries.get(i);
                Assert.assertNotNull((Object)entry);
                entry = (JSONObject)entry.get((Object)"entry");
                Assert.assertNotNull((Object)entry);
                if (!"newVariable".equals((String)entry.get((Object)"name"))) continue;
                newVariableEntry = entry;
            }
            Assert.assertNotNull(newVariableEntry);
            Assert.assertEquals((Object)4567L, (Object)newVariableEntry.get((Object)"value"));
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"stringVariable");
            variableJson.put((Object)"value", (Object)"Updated string variable");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "stringVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"stringVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)"Updated string variable", (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:text", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"Updated string variable", (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "stringVariable"));
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"newLongVariable");
            variableJson.put((Object)"value", (Object)"text");
            variableJson.put((Object)"type", (Object)"d:long");
            try {
                this.publicApiClient.processesClient().updateVariable(processId, "newLongVariable", variableJson);
                Assert.fail((String)"Expected server error exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"newNoValueVariable");
            variableJson.put((Object)"type", (Object)"d:datetime");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "newNoValueVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newNoValueVariable", (Object)result.get((Object)"name"));
            Assert.assertNotNull((Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:datetime", (Object)result.get((Object)"type"));
            Assert.assertNotNull((Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "newNoValueVariable"));
            this.publicApiClient.setRequestContext(adminContext);
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"newVariable");
            variableJson.put((Object)"value", (Object)1234L);
            variableJson.put((Object)"type", (Object)"d:long");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "newVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)1234L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:long", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)1234L, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "newVariable"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
        processRest = this.startAdhocProcess(adminContext, null);
        try {
            Assert.assertNotNull((Object)processRest);
            processId = processRest.getId();
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"newVariable");
            variableJson.put((Object)"value", (Object)1234L);
            variableJson.put((Object)"type", (Object)"d:long");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "newVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)1234L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:long", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)1234L, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "newVariable"));
            this.publicApiClient.setRequestContext(requestContext);
            try {
                this.publicApiClient.processesClient().updateVariable(processId, "newVariable", variableJson);
                Assert.fail((String)"Expected forbidden exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateInitiatorAndGetProcessVariables() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        final RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        ProcessInfo processRest = this.startAdhocProcess(requestContext, null);
        try {
            Assert.assertNotNull((Object)processRest);
            String processId = processRest.getId();
            final JSONObject variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"initiator");
            variableJson.put((Object)"type", (Object)"d:noderef");
            NodeRef personRef = (NodeRef)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<NodeRef>(){

                public NodeRef doWork() throws Exception {
                    String assignee = adminContext.getRunAsUser();
                    NodeRef personRef = ProcessWorkflowApiTest.this.getPersonNodeRef(assignee).getNodeRef();
                    variableJson.put((Object)"value", (Object)personRef.toString());
                    return personRef;
                }
            }, (String)adminContext.getRunAsUser(), (String)adminContext.getNetworkId());
            JSONObject resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "initiator", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            JSONObject updateInitiatorResult = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"initiator", (Object)updateInitiatorResult.get((Object)"name"));
            Assert.assertEquals((Object)"d:noderef", (Object)updateInitiatorResult.get((Object)"type"));
            Assert.assertNotNull((String)"Variable value should be returned", (Object)updateInitiatorResult.get((Object)"value"));
            Assert.assertEquals((Object)personRef.getId(), (Object)updateInitiatorResult.get((Object)"value"));
            this.publicApiClient.setRequestContext(adminContext);
            resultEntry = this.publicApiClient.processesClient().getProcessvariables(processId);
            Assert.assertNotNull((Object)resultEntry);
            this.validateVariableField(resultEntry, "initiator", adminContext.getRunAsUser());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
    }

    protected void validateVariableField(JSONObject processvariables, String name, String value) {
        JSONObject entry = null;
        JSONArray entries = (JSONArray)processvariables.get((Object)"entries");
        Assert.assertNotNull((Object)entries);
        int i = 0;
        while (!(entry = (JSONObject)((JSONObject)entries.get(i)).get((Object)"entry")).containsValue((Object)name) && ++i < entries.size()) {
        }
        Assert.assertEquals((Object)value, (Object)entry.get((Object)"value"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateProcessVariableWithWrongType() throws Exception {
        final RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processRest = this.startParallelReviewProcess(requestContext);
        try {
            Assert.assertNotNull((Object)processRest);
            String processId = processRest.getId();
            JSONObject variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"wf_requiredApprovePercent");
            variableJson.put((Object)"value", (Object)55.99);
            variableJson.put((Object)"type", (Object)"d:double");
            try {
                this.publicApiClient.processesClient().updateVariable(processId, "wf_requiredApprovePercent", variableJson);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"wf_requiredApprovePercent");
            variableJson.put((Object)"value", (Object)55.99);
            variableJson.put((Object)"type", (Object)"d:int");
            JSONObject resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "wf_requiredApprovePercent", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            JSONObject result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"wf_requiredApprovePercent", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)55L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)55, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "wf_requiredApprovePercent"));
            JSONObject processvariables = this.publicApiClient.processesClient().getProcessvariables(processId);
            Assert.assertNotNull((Object)processvariables);
            HashMap<String, JSONObject> variablesByName = new HashMap<String, JSONObject>();
            JSONObject entry = null;
            JSONArray entries = (JSONArray)processvariables.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            for (int i = 0; i < entries.size(); ++i) {
                entry = (JSONObject)entries.get(i);
                Assert.assertNotNull((Object)entry);
                entry = (JSONObject)entry.get((Object)"entry");
                Assert.assertNotNull((Object)entry);
                variablesByName.put((String)entry.get((Object)"name"), entry);
            }
            JSONObject approvePercentObject = (JSONObject)variablesByName.get("wf_requiredApprovePercent");
            Assert.assertNotNull((Object)approvePercentObject);
            Assert.assertEquals((Object)55L, (Object)approvePercentObject.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)approvePercentObject.get((Object)"type"));
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"testVariable");
            variableJson.put((Object)"value", (Object)"text");
            variableJson.put((Object)"type", (Object)"d:text");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "testVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"testVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)"text", (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:text", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"text", (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "testVariable"));
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"testVariable");
            variableJson.put((Object)"value", (Object)123);
            variableJson.put((Object)"type", (Object)"d:int");
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "testVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"testVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)123L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)123, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processId, "testVariable"));
            final JSONObject updateAssigneesJson = new JSONObject();
            updateAssigneesJson.put((Object)"name", (Object)"bpm_assignees");
            updateAssigneesJson.put((Object)"type", (Object)"d:noderef");
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    JSONArray assigneeArray = new JSONArray();
                    assigneeArray.add((Object)requestContext.getRunAsUser());
                    updateAssigneesJson.put((Object)"value", (Object)assigneeArray);
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            resultEntry = this.publicApiClient.processesClient().updateVariable(processId, "bpm_assignees", updateAssigneesJson);
            Assert.assertNotNull((Object)resultEntry);
            final JSONObject updateAssigneeResult = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"bpm_assignees", (Object)updateAssigneeResult.get((Object)"name"));
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    JSONArray assigneeArray = (JSONArray)updateAssigneeResult.get((Object)"value");
                    Assert.assertNotNull((Object)assigneeArray);
                    Assert.assertEquals((long)1L, (long)assigneeArray.size());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            Assert.assertEquals((Object)"d:noderef", (Object)updateAssigneeResult.get((Object)"type"));
            final JSONObject updateAssigneeJson = new JSONObject();
            updateAssigneeJson.put((Object)"name", (Object)"bpm_assignees");
            updateAssigneeJson.put((Object)"type", (Object)"d:noderef");
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    updateAssigneeJson.put((Object)"value", (Object)requestContext.getRunAsUser());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            try {
                this.publicApiClient.processesClient().updateVariable(processId, "bpm_assignees", updateAssigneeJson);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"bpm_assignees");
            JSONArray assigneeArray = new JSONArray();
            assigneeArray.add((Object)"nonExistingPerson");
            variableJson.put((Object)"value", (Object)assigneeArray);
            variableJson.put((Object)"type", (Object)"d:noderef");
            try {
                this.publicApiClient.processesClient().updateVariable(processId, "bpm_assignees", variableJson);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteProcessVariable() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processRest = this.startAdhocProcess(requestContext, null);
        try {
            Assert.assertNotNull((Object)processRest);
            String processId = processRest.getId();
            this.activitiProcessEngine.getRuntimeService().setVariable(processId, "deleteMe", (Object)"This is a string");
            this.publicApiClient.processesClient().deleteVariable(processId, "deleteMe");
            Assert.assertFalse((boolean)this.activitiProcessEngine.getRuntimeService().hasVariable(processId, "deleteMe"));
            try {
                this.publicApiClient.processesClient().deleteVariable(processId, "deleteMe");
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The entity with id: deleteMe was not found", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
    }

    @Test
    public void testDeleteProcessVariableUnexistingProcess() throws Exception {
        this.initApiClientWithTestUser();
        try {
            this.publicApiClient.processesClient().deleteVariable("unexisting", "deleteMe");
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
            this.assertErrorSummary("The entity with id: unexisting was not found", expected.getHttpResponse());
        }
    }

    protected void completeAdhocTasks(String instanceId, RequestContext requestContext) {
        final Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(instanceId)).singleResult();
        Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)task.getAssignee());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        final Task task2 = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(instanceId)).singleResult();
        Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)task2.getAssignee());
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                ProcessWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task2.getId());
                return null;
            }
        }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
        Assert.assertEquals((long)0L, (long)this.activitiProcessEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(instanceId).count());
        this.cleanupProcessInstance(instanceId);
    }

    protected void cleanupProcessInstance(String ... processInstances) {
        try {
            for (String processInstanceId : processInstances) {
                try {
                    this.activitiProcessEngine.getRuntimeService().deleteProcessInstance(processInstanceId, null);
                }
                catch (Exception e) {
                    this.log("Error while cleaning up process instance", e);
                }
                this.activitiProcessEngine.getHistoryService().deleteHistoricProcessInstance(processInstanceId);
            }
        }
        catch (Throwable t) {
            this.log("Error while cleaning up process instance", t);
        }
    }
}

