/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.Networks;
import org.alfresco.rest.api.model.PersonNetwork;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.exceptions.ApiException;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.jacksonextensions.JacksonHelper;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.ApiWebScript;
import org.alfresco.rest.framework.webscripts.ResourceWebScriptHelper;
import org.springframework.extensions.webscripts.Format;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class NetworkWebScriptGet
extends ApiWebScript
implements ResponseWriter {
    private Networks networks;
    private ResourceWebScriptHelper helper;

    public void setHelper(ResourceWebScriptHelper helper) {
        this.helper = helper;
    }

    public void setNetworks(Networks networks) {
        this.networks = networks;
    }

    @Override
    public void execute(Api api, final WebScriptRequest req, final WebScriptResponse res) throws IOException {
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    res.setContentType(Format.JSON.mimetype() + ";charset=UTF-8");
                    NetworkWebScriptGet.this.assistant.getJsonHelper().withWriter(res.getOutputStream(), new JacksonHelper.Writer(){

                        @Override
                        public void writeContents(JsonGenerator generator, ObjectMapper objectMapper) throws JsonGenerationException, JsonMappingException, IOException {
                            String networkId;
                            String personId = AuthenticationUtil.getFullyAuthenticatedUser();
                            PersonNetwork networkMembership = NetworkWebScriptGet.this.networks.getNetwork(personId, networkId = TenantUtil.getCurrentDomain());
                            if (networkMembership == null) {
                                throw new EntityNotFoundException(networkId);
                            }
                            Object wrapped = NetworkWebScriptGet.this.helper.processAdditionsToTheResponse(res, Api.ALFRESCO_PUBLIC, "networks", Params.valueOf(personId, null, req), networkMembership);
                            objectMapper.writeValue(generator, wrapped);
                        }
                    });
                    return null;
                }
            }, true, true);
        }
        catch (ApiException | WebScriptException apiException) {
            this.renderException((Exception)apiException, res, req, this.assistant);
        }
        catch (RuntimeException runtimeException) {
            this.renderException(runtimeException, res, req, this.assistant);
        }
    }
}

