/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.people;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.People;
import org.alfresco.rest.api.model.AuthCode;
import org.alfresco.rest.api.model.AuthKey;
import org.alfresco.rest.api.model.Client;
import org.alfresco.rest.api.model.PasswordReset;
import org.alfresco.rest.api.model.Person;
import org.alfresco.rest.framework.BinaryProperties;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiNoAuth;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.content.BasicContentInfo;
import org.alfresco.rest.framework.resource.content.BinaryResource;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="people", title="People")
public class PeopleEntityResource
implements EntityResourceAction.ReadById<Person>,
EntityResourceAction.Create<Person>,
EntityResourceAction.Update<Person>,
EntityResourceAction.Read<Person>,
BinaryResourceAction.Read,
BinaryResourceAction.Update<Person>,
BinaryResourceAction.Delete,
InitializingBean {
    private People people;

    public void setPeople(People people) {
        this.people = people;
    }

    public void afterPropertiesSet() {
        PropertyCheck.mandatory((Object)this, (String)"people", (Object)this.people);
    }

    @Override
    @WebApiDescription(title="Get Person Information", description="Get information for the person with id 'personId'")
    @WebApiParam(name="personId", title="The person's username")
    public Person readById(String personId, Parameters parameters) {
        Person person = this.people.getPerson(personId);
        return person;
    }

    @Override
    @WebApiDescription(title="Create person", description="Create a person")
    @WebApiParam(name="persons", title="A single person", description="A single person, multiple people are not supported.", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT, allowMultiple=false, required=true)
    public List<Person> create(List<Person> persons, Parameters parameters) {
        Person p = persons.get(0);
        this.validateDerivedFieldsExistence(p);
        ArrayList<Person> result = new ArrayList<Person>(1);
        result.add(this.people.create(p));
        return result;
    }

    @Override
    @WebApiDescription(title="Update person", description="Update the given person's details")
    public Person update(String personId, Person person, Parameters parameters) {
        if (person.wasSet(ContentModel.PROP_USERNAME)) {
            throw new InvalidArgumentException("Unsupported field: id");
        }
        this.validateDerivedFieldsExistence(person);
        return this.people.update(personId, person);
    }

    private void validateDerivedFieldsExistence(Person person) {
        if (person.wasSet(ContentModel.PROP_USER_STATUS_TIME)) {
            throw new InvalidArgumentException("Unsupported field: statusUpdatedAt");
        }
        if (person.wasSet(Person.PROP_PERSON_AVATAR_ID)) {
            throw new InvalidArgumentException("Unsupported field: avatarId");
        }
        if (person.wasSet(ContentModel.PROP_SIZE_QUOTA)) {
            throw new InvalidArgumentException("Unsupported field: quota");
        }
        if (person.wasSet(ContentModel.PROP_SIZE_CURRENT)) {
            throw new InvalidArgumentException("Unsupported field: quotaUsed");
        }
    }

    @Override
    @WebApiDescription(title="Get List of People", description="Get List of People")
    public CollectionWithPagingInfo<Person> readAll(Parameters params) {
        return this.people.getPeople(params);
    }

    @Deprecated
    @Operation(value="request-password-reset")
    @WebApiDescription(title="Request Password Reset", description="Request password reset", successStatus=202)
    @WebApiNoAuth
    public void requestPasswordReset(String personId, Client client, Parameters parameters, WithResponse withResponse) {
        this.people.requestPasswordReset(personId, client.getClient());
    }

    @Deprecated
    @Operation(value="reset-password")
    @WebApiDescription(title="Reset Password", description="Performs password reset", successStatus=202)
    @WebApiNoAuth
    public void resetPassword(String personId, PasswordReset passwordReset, Parameters parameters, WithResponse withResponse) {
        this.people.resetPassword(personId, passwordReset);
    }

    @Override
    @WebApiDescription(title="Download avatar", description="Download avatar")
    @BinaryProperties(value={"avatar"})
    public BinaryResource readProperty(String personId, Parameters parameters) throws EntityNotFoundException {
        return this.people.downloadAvatarContent(personId, parameters);
    }

    @Override
    @WebApiDescription(title="Upload avatar", description="Upload avatar")
    @BinaryProperties(value={"avatar"})
    public Person updateProperty(String personId, BasicContentInfo contentInfo, InputStream stream, Parameters parameters) {
        return this.people.uploadAvatarContent(personId, contentInfo, stream, parameters);
    }

    @Override
    @WebApiDescription(title="Delete avatar image", description="Delete avatar image")
    @BinaryProperties(value={"avatar"})
    public void deleteProperty(String personId, Parameters parameters) {
        this.people.deleteAvatarContent(personId);
    }

    @Operation(value="deauthorize")
    @WebApiDescription(title="De-authorize user", description="Performs user de-authorization", successStatus=501)
    public void deauthorizeUser(String personId, Void body, Parameters parameters, WithResponse withResponse) {
    }

    @Operation(value="reauthorization-code")
    @WebApiDescription(title="Get the reauthorization code", description="Get the reauthorization code", successStatus=501)
    public AuthCode getReauthorizationCode(String personId, Void body, Parameters parameters, WithResponse withResponse) {
        return null;
    }

    @Operation(value="reauthorize")
    @WebApiDescription(title="Reauthorize user", description="Performs user reauthorization", successStatus=501)
    public void reauthorizeUser(String personId, AuthKey authKey, Parameters parameters, WithResponse withResponse) {
    }
}

