/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest;

import com.google.common.collect.Ordering;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.model.NodeTargetAssoc;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.ContentInfo;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Folder;
import org.alfresco.rest.api.tests.client.data.Node;
import org.alfresco.rest.api.tests.client.data.PathInfo;
import org.alfresco.rest.api.tests.client.data.Rendition;
import org.alfresco.rest.api.tests.util.MultiPartBuilder;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.rest.api.trashcan.TrashcanEntityResource;
import org.alfresco.util.testing.category.IntermittentlyFailingTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class DeletedNodesTest
extends AbstractSingleNetworkSiteTest {
    protected static final String URL_DELETED_NODES = "deleted-nodes";
    private static final String URL_RENDITIONS = "renditions";

    @Override
    public void setup() throws Exception {
        super.setup();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testCreateAndDelete() throws Exception {
        this.setRequestContext(user1);
        Date now = new Date();
        String folder1 = "folder-testCreateAndDelete-" + now.getTime() + "_1";
        Folder createdFolder = this.createFolder(tDocLibNodeId, folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        String f1Id = createdFolder.getId();
        Folder createdFolderNonSite = this.createFolder("-my-", folder1, null);
        Assert.assertNotNull((Object)createdFolderNonSite);
        Document document = this.createEmptyTextFile(f1Id, "d1.txt");
        PublicApiClient.Paging paging = this.getPaging(0, 100);
        HttpResponse response = this.getAll(URL_DELETED_NODES, paging, 200);
        List<Node> nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodes);
        int numOfNodes = nodes.size();
        this.deleteNode(document.getId());
        this.deleteNode(createdFolder.getId());
        this.deleteNode(createdFolderNonSite.getId());
        response = this.getAll(URL_DELETED_NODES, paging, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodes);
        Assert.assertEquals((long)(numOfNodes + 3), (long)nodes.size());
        this.checkDeletedNodes(now, createdFolder, createdFolderNonSite, document, nodes);
        paging = this.getPaging(1, 1);
        response = this.getAll(URL_DELETED_NODES, paging, 200);
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodes);
        Assert.assertEquals((long)1L, (long)nodes.size());
        PublicApiClient.ExpectedPaging expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)(numOfNodes + 3), (long)expectedPaging.getTotalItems().intValue());
        Assert.assertEquals((long)1L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)1L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)1L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertTrue((boolean)expectedPaging.getHasMoreItems());
        Map<String, String> params = Collections.singletonMap("include", "path");
        response = this.getSingle(URL_DELETED_NODES, document.getId(), params, 200);
        Document node = jacksonUtil.parseEntry(response.getJsonResponse(), Document.class);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)user1, (Object)node.getArchivedByUser().getId());
        Assert.assertTrue((boolean)node.getArchivedAt().after(now));
        PathInfo path = node.getPath();
        Assert.assertNull((String)"Path should be null because its parent has been deleted", (Object)path);
        Assert.assertNull((String)"We don't show the parent id for a deleted node", (Object)node.getParentId());
        response = this.getSingle(URL_DELETED_NODES, createdFolder.getId(), params, 200);
        Folder fNode = jacksonUtil.parseEntry(response.getJsonResponse(), Folder.class);
        Assert.assertNotNull((Object)fNode);
        Assert.assertEquals((Object)user1, (Object)fNode.getArchivedByUser().getId());
        Assert.assertTrue((boolean)fNode.getArchivedAt().after(now));
        path = fNode.getPath();
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)("/Company Home/Sites/" + tSiteId + "/documentLibrary"), (Object)path.getName());
        Assert.assertTrue((boolean)path.getIsComplete());
        Assert.assertNull((String)"We don't show the parent id for a deleted node", (Object)fNode.getParentId());
        response = this.getSingle(URL_DELETED_NODES, createdFolderNonSite.getId(), params, 200);
        fNode = jacksonUtil.parseEntry(response.getJsonResponse(), Folder.class);
        Assert.assertNotNull((Object)fNode);
        Assert.assertEquals((Object)user1, (Object)fNode.getArchivedByUser().getId());
        Assert.assertTrue((boolean)fNode.getArchivedAt().after(now));
        path = fNode.getPath();
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((Object)("/Company Home/User Homes/" + user1), (Object)path.getName());
        Assert.assertTrue((boolean)path.getIsComplete());
        this.setRequestContext(user2);
        this.getSingle(URL_DELETED_NODES, createdFolderNonSite.getId(), 403);
        this.setRequestContext(user1);
        this.getSingle(URL_DELETED_NODES, "iddontexist", 404);
        this.setRequestContext(networkAdmin);
        paging = this.getPaging(0, 100);
        response = this.publicApiClient.get(this.getScope(), URL_DELETED_NODES, null, null, null, this.createParams(paging, null));
        this.checkStatus(200, response.getStatusCode());
        nodes = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Node.class);
        Assert.assertNotNull(nodes);
        this.checkDeletedNodes(now, createdFolder, createdFolderNonSite, document, nodes);
    }

    @Test
    public void testCreateAndRestore() throws Exception {
        this.setRequestContext(user1);
        Date now = new Date();
        String folder1 = "folder" + now.getTime() + "_1";
        Folder createdFolder = this.createFolder(tDocLibNodeId, folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        String f1Id = createdFolder.getId();
        Folder createdFolderNonSite = this.createFolder("-my-", folder1, null);
        Assert.assertNotNull((Object)createdFolderNonSite);
        Document document = this.createEmptyTextFile(f1Id, "restoreme.txt");
        this.deleteNode(document.getId());
        Document documentSameName = this.createEmptyTextFile(f1Id, "restoreme.txt");
        this.post("deleted-nodes/" + document.getId() + "/restore", null, null, 409);
        this.deleteNode(documentSameName.getId());
        this.post("deleted-nodes/" + document.getId() + "/restore", null, null, 200);
        this.deleteNode(document.getId());
        NodeTargetAssoc nodeTargetAssoc = new NodeTargetAssoc();
        nodeTargetAssoc.setTargetParentId(f1Id);
        nodeTargetAssoc.setAssocType("cm:contains");
        this.post("deleted-nodes/" + document.getId() + "/restore", RestApiUtil.toJsonAsStringNonNull(nodeTargetAssoc), null, 200);
        this.deleteNode(document.getId());
        nodeTargetAssoc.setTargetParentId("nonexistentTargetNode");
        this.post("deleted-nodes/" + document.getId() + "/restore", RestApiUtil.toJsonAsStringNonNull(nodeTargetAssoc), null, 404);
        nodeTargetAssoc.setTargetParentId(f1Id);
        nodeTargetAssoc.setAssocType("invalidAssociationType");
        this.post("deleted-nodes/" + document.getId() + "/restore", RestApiUtil.toJsonAsStringNonNull(nodeTargetAssoc), null, 400);
        nodeTargetAssoc.setTargetParentId(f1Id);
        nodeTargetAssoc.setAssocType(null);
        this.post("deleted-nodes/" + document.getId() + "/restore", RestApiUtil.toJsonAsStringNonNull(nodeTargetAssoc), null, 400);
        this.setRequestContext(networkAdmin);
        String folderAdmin = "adminsFolder" + now.getTime() + "_1";
        Folder adminCreatedFolder = this.createFolder("-my-", folderAdmin, null);
        Assert.assertNotNull((Object)adminCreatedFolder);
        String adminf1Id = adminCreatedFolder.getId();
        this.setRequestContext(user1);
        nodeTargetAssoc.setTargetParentId(adminf1Id);
        nodeTargetAssoc.setAssocType("cm:contains");
        this.post("deleted-nodes/" + document.getId() + "/restore", RestApiUtil.toJsonAsStringNonNull(nodeTargetAssoc), null, 403);
        this.deleteNode(createdFolder.getId());
        this.post("deleted-nodes/" + documentSameName.getId() + "/restore", null, null, 404);
        this.post("deleted-nodes/nonsense/restore", null, null, 404);
        this.setRequestContext(user2);
        this.post("deleted-nodes/" + createdFolder.getId() + "/restore", null, null, 403);
        this.setRequestContext(user1);
        this.post("deleted-nodes/" + createdFolder.getId() + "/restore", null, null, 200);
    }

    @Test
    public void testCreateAndPurge() throws Exception {
        this.setRequestContext(user1);
        Date now = new Date();
        String folder1 = "folder" + now.getTime() + "_1";
        Folder createdFolder = this.createFolder(tDocLibNodeId, folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        this.deleteNode(createdFolder.getId());
        HttpResponse response = this.getSingle(URL_DELETED_NODES, createdFolder.getId(), 200);
        Folder fNode = jacksonUtil.parseEntry(response.getJsonResponse(), Folder.class);
        Assert.assertNotNull((Object)fNode);
        this.delete(URL_DELETED_NODES, "nonsense", 404);
        this.setRequestContext(user2);
        this.delete(URL_DELETED_NODES, createdFolder.getId(), 403);
        this.setRequestContext(user1);
        this.delete(URL_DELETED_NODES, createdFolder.getId(), 204);
        this.getSingle(URL_DELETED_NODES, createdFolder.getId(), 404);
    }

    @Category(value={IntermittentlyFailingTests.class})
    @Test
    public void testDownloadFileContent() throws Exception {
        this.setRequestContext(user1);
        String fileName = "quick-1.txt";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl("-my-"), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Assert.assertEquals((Object)fileName, (Object)document.getName());
        ContentInfo contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        this.deleteNode(document.getId());
        response = this.getSingle(TrashcanEntityResource.class, contentNodeId + "/content", null, 200);
        String textContent = response.getResponse();
        Assert.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)textContent);
        Map<String, String> responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertEquals((Object)"attachment; filename=\"quick-1.txt\"; filename*=UTF-8''quick-1.txt", (Object)responseHeaders.get("Content-Disposition"));
        String cacheControl = responseHeaders.get("Cache-Control");
        Assert.assertNotNull((Object)cacheControl);
        Assert.assertTrue((boolean)cacheControl.contains("must-revalidate"));
        Assert.assertTrue((boolean)cacheControl.contains("max-age=0"));
        Assert.assertNotNull((Object)responseHeaders.get("Expires"));
        String lastModifiedHeader = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)lastModifiedHeader);
        Map<String, String> headers = Collections.singletonMap("If-Modified-Since", lastModifiedHeader);
        this.getSingle("deleted-nodes/" + contentNodeId + "/content", null, null, headers, 304);
        fileName = "quick.pdf";
        file = this.getResourceFile(fileName);
        byte[] originalBytes = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        reqBody = multiPartBuilder.build();
        response = this.post(this.getNodeChildrenUrl("-my-"), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        this.deleteNode(document.getId());
        contentNodeId = document.getId();
        Assert.assertEquals((Object)fileName, (Object)document.getName());
        contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"application/pdf", (Object)contentInfo.getMimeType());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("attachment", "false");
        response = this.getSingle(TrashcanEntityResource.class, contentNodeId + "/content", params, 200);
        byte[] bytes = response.getResponseAsBytes();
        Assert.assertArrayEquals((byte[])originalBytes, (byte[])bytes);
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertNull((Object)responseHeaders.get("Content-Disposition"));
        Assert.assertNotNull((Object)responseHeaders.get("Cache-Control"));
        Assert.assertNotNull((Object)responseHeaders.get("Expires"));
        lastModifiedHeader = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)lastModifiedHeader);
        headers = Collections.singletonMap("If-Modified-Since", lastModifiedHeader);
        this.getSingle("deleted-nodes/" + contentNodeId + "/content", null, null, headers, 304);
        this.getSingle(TrashcanEntityResource.class, UUID.randomUUID().toString() + "/content", params, 404);
        this.setRequestContext(null);
        this.getSingle(TrashcanEntityResource.class, contentNodeId + "/content", params, 401);
        this.setRequestContext(user2);
        this.getSingle(TrashcanEntityResource.class, contentNodeId + "/content", params, 403);
    }

    @Test
    public void testListRenditions() throws Exception {
        this.setRequestContext(user1);
        Date now = new Date();
        String folder1 = "folder" + now.getTime() + "_1";
        Folder createdFolder = this.createFolder(tDocLibNodeId, folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        String f1Id = createdFolder.getId();
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(f1Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        this.createAndGetRendition(contentNodeId, "doclib");
        this.deleteNode(contentNodeId);
        PublicApiClient.Paging paging = this.getPaging(0, 50);
        response = this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, 200);
        List<Rendition> renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((renditions.size() >= 3 ? 1 : 0) != 0);
        response = this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "doclib", 200);
        Rendition doclibRendition = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)doclibRendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)doclibRendition.getStatus()));
        ContentInfo contentInfo = doclibRendition.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/png", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"PNG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNotNull((Object)contentInfo.getEncoding());
        Assert.assertTrue((contentInfo.getSizeInBytes() > 0L ? 1 : 0) != 0);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("where", "(status='NOT_CREATED')");
        response = this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((renditions.size() >= 2 ? 1 : 0) != 0);
        params.put("where", "(status='CREATED')");
        response = this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((String)"Only 'doclib' rendition should be returned.", (long)1L, (long)renditions.size());
        paging = this.getPaging(0, 2);
        response = this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((long)2L, (long)renditions.size());
        PublicApiClient.ExpectedPaging expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)2L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)0L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)2L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertTrue((expectedPaging.getTotalItems() >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)expectedPaging.getHasMoreItems());
        paging = this.getPaging(1, 3);
        response = this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((long)3L, (long)renditions.size());
        expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)3L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)1L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)3L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertTrue((expectedPaging.getTotalItems() >= 3 ? 1 : 0) != 0);
        response = this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((boolean)Ordering.natural().isOrdered(renditions));
        response = this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((boolean)Ordering.natural().isOrdered(renditions));
        this.getAll(this.getDeletedNodeRenditionsUrl(UUID.randomUUID().toString()), paging, params, 404);
        Document emptyDoc = this.createEmptyTextFile(f1Id, "d1.txt");
        this.getAll(this.getDeletedNodeRenditionsUrl(emptyDoc.getId()), paging, params, 404);
        this.deleteNode(f1Id);
        this.getAll(this.getDeletedNodeRenditionsUrl(f1Id), paging, params, 400);
        params.put("where", "(status='WRONG')");
        this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, params, 400);
        params.put("where", "(id='doclib')");
        this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, params, 400);
        this.setRequestContext(null);
        this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, params, 401);
        this.setRequestContext(user2);
        this.getAll(this.getDeletedNodeRenditionsUrl(contentNodeId), paging, params, 403);
        this.setRequestContext(user1);
        this.getSingle(this.getDeletedNodeRenditionsUrl(UUID.randomUUID().toString()), "doclib", 404);
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "renditionId" + System.currentTimeMillis(), 404);
        this.getSingle(this.getDeletedNodeRenditionsUrl(f1Id), "doclib", 400);
        this.setRequestContext(null);
        this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "doclib", 401);
        this.setRequestContext(user2);
        this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "doclib", 403);
    }

    @Test
    public void testDownloadRendition() throws Exception {
        this.setRequestContext(user1);
        Date now = new Date();
        String folder1 = "folder" + now.getTime() + "_1";
        Folder createdFolder = this.createFolder(tDocLibNodeId, folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        String f1Id = createdFolder.getId();
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(f1Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Rendition rendition = this.createAndGetRendition(contentNodeId, "doclib");
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        this.deleteNode(contentNodeId);
        response = this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "doclib/content", 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        Map<String, String> responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        String contentDisposition = responseHeaders.get("Content-Disposition");
        Assert.assertNotNull((Object)contentDisposition);
        Assert.assertTrue((boolean)contentDisposition.contains("filename=\"doclib\""));
        String contentType = responseHeaders.get("Content-Type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("image/png"));
        HashMap<String, String> params = new HashMap();
        params = Collections.singletonMap("attachment", "false");
        response = this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "doclib/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertNull((Object)responseHeaders.get("Content-Disposition"));
        contentType = responseHeaders.get("Content-Type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("image/png"));
        params = Collections.singletonMap("attachment", "true");
        response = this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "doclib/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        String cacheControl = responseHeaders.get("Cache-Control");
        Assert.assertNotNull((Object)cacheControl);
        Assert.assertFalse((boolean)cacheControl.contains("must-revalidate"));
        Assert.assertTrue((boolean)cacheControl.contains("max-age=31536000"));
        contentDisposition = responseHeaders.get("Content-Disposition");
        Assert.assertNotNull((Object)contentDisposition);
        Assert.assertTrue((boolean)contentDisposition.contains("filename=\"doclib\""));
        contentType = responseHeaders.get("Content-Type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("image/png"));
        String lastModifiedHeader = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)lastModifiedHeader);
        Map<String, String> headers = Collections.singletonMap("If-Modified-Since", lastModifiedHeader);
        this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "doclib/content", params, headers, 304);
        this.deleteNode(f1Id);
        this.getSingle(this.getDeletedNodeRenditionsUrl(f1Id), "doclib/content", 400);
        this.getSingle(this.getDeletedNodeRenditionsUrl(UUID.randomUUID().toString()), "doclib/content", 404);
        this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "renditionId" + System.currentTimeMillis() + "/content", 404);
        params = Collections.singletonMap("placeholder", "true");
        this.getSingle(this.getDeletedNodeRenditionsUrl(contentNodeId), "renditionId" + System.currentTimeMillis() + "/content", params, 404);
    }

    protected void checkDeletedNodes(Date now, Folder createdFolder, Folder createdFolderNonSite, Document document, List<Node> nodes) {
        Node aNode = nodes.get(0);
        Assert.assertNotNull((Object)aNode);
        Assert.assertEquals((String)"This folder was deleted most recently", (Object)createdFolderNonSite.getId(), (Object)aNode.getId());
        Assert.assertEquals((Object)user1, (Object)aNode.getArchivedByUser().getId());
        Assert.assertTrue((boolean)aNode.getArchivedAt().after(now));
        Assert.assertNull((String)"We don't show the parent id for a deleted node", (Object)aNode.getParentId());
        Node folderNode = nodes.get(1);
        Assert.assertNotNull((Object)folderNode);
        Assert.assertEquals((Object)createdFolder.getId(), (Object)folderNode.getId());
        Assert.assertEquals((Object)user1, (Object)folderNode.getArchivedByUser().getId());
        Assert.assertTrue((boolean)folderNode.getArchivedAt().after(now));
        Assert.assertTrue((String)"This folder was deleted before the non-site folder", (boolean)folderNode.getArchivedAt().before(aNode.getArchivedAt()));
        Assert.assertNull((String)"We don't show the parent id for a deleted node", (Object)folderNode.getParentId());
        aNode = nodes.get(2);
        Assert.assertNotNull((Object)aNode);
        Assert.assertEquals((Object)document.getId(), (Object)aNode.getId());
        Assert.assertEquals((Object)user1, (Object)aNode.getArchivedByUser().getId());
        Assert.assertTrue((boolean)aNode.getArchivedAt().after(now));
        Assert.assertNull((String)"We don't show the parent id for a deleted node", (Object)aNode.getParentId());
    }

    @Test
    public void testRequestArchivedContentDirectUrl() throws Exception {
        this.setRequestContext(user1);
        String myNodeId = this.getMyNodeId();
        String fileName = "TestDocumentToArchive.txt";
        Document testDocumentToArchive = new Document();
        testDocumentToArchive.setName(fileName);
        testDocumentToArchive.setNodeType("cm:content");
        HttpResponse response = this.post(this.getNodeChildrenUrl(myNodeId), RestApiUtil.toJsonAsStringNonNull(testDocumentToArchive), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        this.deleteNode(contentNodeId);
        Assert.assertEquals((Object)fileName, (Object)document.getName());
        ContentInfo contentInfo = document.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"text/plain", (Object)contentInfo.getMimeType());
        HttpResponse dauResponse = this.post(this.getRequestArchivedContentDirectUrl(contentNodeId), null, null, null, null, 501);
    }

    @Test
    public void testRequestArchivedRenditionDirectUrl() throws Exception {
        this.setRequestContext(user1);
        Date now = new Date();
        String folder1 = "folder" + now.getTime() + "_1";
        Folder createdFolder = this.createFolder(tDocLibNodeId, folder1, null);
        Assert.assertNotNull((Object)createdFolder);
        String f1Id = createdFolder.getId();
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(f1Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Rendition rendition = this.createAndGetRendition(contentNodeId, "doclib");
        Assert.assertNotNull((Object)rendition);
        String renditionID = rendition.getId();
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        this.deleteNode(contentNodeId);
        HttpResponse dauResponse = this.post(this.getRequestArchivedRenditonContentDirectUrl(contentNodeId, renditionID), null, null, null, null, 501);
    }

    private String addToDocumentLibrary(String name, String nodeType, String userId) throws Exception {
        String parentId = this.getSiteContainerNodeId("-my-", "documentLibrary");
        return this.createNode(parentId, name, nodeType, null).getId();
    }

    private String getDeletedNodeRenditionsUrl(String nodeId) {
        return "deleted-nodes/" + nodeId + "/renditions";
    }
}

