/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.tests.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.model.Comment;
import org.alfresco.rest.api.nodes.NodeCommentsRelation;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.core.OperationResourceMetaData;
import org.alfresco.rest.framework.core.ResourceInspector;
import org.alfresco.rest.framework.core.ResourceInspectorUtil;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tests.api.mocks.Farmer;
import org.alfresco.rest.framework.tests.api.mocks.GoatEntityResource;
import org.alfresco.rest.framework.tests.api.mocks.Grass;
import org.alfresco.rest.framework.tests.api.mocks.GrassEntityResource;
import org.alfresco.rest.framework.tests.api.mocks.MultiPartTestEntityResource;
import org.alfresco.rest.framework.tests.api.mocks.MultiPartTestRelationshipResource;
import org.alfresco.rest.framework.tests.api.mocks.MultiPartTestResponse;
import org.alfresco.rest.framework.tests.api.mocks.Sheep;
import org.alfresco.rest.framework.tests.api.mocks.SheepBaaaahResource;
import org.alfresco.rest.framework.tests.api.mocks.SheepBlackSheepResource;
import org.alfresco.rest.framework.tests.api.mocks.SheepEntityResource;
import org.alfresco.rest.framework.tests.api.mocks.SheepNoActionEntityResource;
import org.alfresco.rest.framework.tests.api.mocks2.FarmersDaughter;
import org.alfresco.rest.framework.tests.api.mocks2.FarmersGrandson;
import org.alfresco.rest.framework.tests.api.mocks2.FarmersSon;
import org.alfresco.rest.framework.tests.api.mocks3.Flock;
import org.alfresco.rest.framework.tests.api.mocks3.FlockEntityResource;
import org.alfresco.rest.framework.tests.api.mocks3.FlocketEntityResource;
import org.alfresco.rest.framework.tests.api.mocks3.GoatRelationshipResource;
import org.alfresco.rest.framework.tests.api.mocks3.GrassEntityResourceNowDeleted;
import org.alfresco.rest.framework.tests.api.mocks3.SheepBlackSheepResourceIsNoMore;
import org.alfresco.rest.framework.tests.api.mocks3.SheepEntityResourceWithDeletedMethods;
import org.alfresco.rest.framework.tests.api.mocks3.SlimGoat;
import org.alfresco.rest.framework.tools.ResponseWriter;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.http.HttpMethod;

public class InspectorTests {
    @Test
    public void testInspectEntity() {
        List metainfo = ResourceInspector.inspect(SheepEntityResource.class);
        Assert.assertTrue((String)"Must be one ResourceMetadata", (metainfo.size() == 1 ? 1 : 0) != 0);
        ResourceMetadata metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        Assert.assertNotNull((String)"SheepEntityResource supports GET", (Object)metaData.getOperation(HttpMethod.GET));
        Assert.assertNotNull((String)"SheepEntityResource supports PUT", (Object)metaData.getOperation(HttpMethod.PUT));
        Assert.assertNotNull((String)"SheepEntityResource supports DELETE", (Object)metaData.getOperation(HttpMethod.DELETE));
        Assert.assertNull((String)"SheepEntityResource does not support POST", (Object)metaData.getOperation(HttpMethod.POST));
        ResourceOperation op = metaData.getOperation(HttpMethod.GET);
        Assert.assertEquals((String)"Sheep ReadALL should return ACCEPTED", (long)202L, (long)op.getSuccessStatus());
        op = metaData.getOperation(HttpMethod.PUT);
        Assert.assertTrue((String)"SheepEntityResource must support Sheep", (boolean)Sheep.class.equals((Object)metaData.getObjectType(op)));
        metainfo = ResourceInspector.inspect(SheepNoActionEntityResource.class);
        Assert.assertTrue((String)"SheepNoActionEntityResource has no actions.", (boolean)metainfo.isEmpty());
        metainfo = ResourceInspector.inspect(GoatEntityResource.class);
        Assert.assertTrue((String)"Must be one ResourceMetadata", (metainfo.size() == 1 ? 1 : 0) != 0);
        metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        Assert.assertNotNull((String)"GoatEntityResource supports GET", (Object)metaData.getOperation(HttpMethod.GET));
        op = metaData.getOperation(HttpMethod.GET);
        List params = op.getParameters();
        Assert.assertTrue((String)"readById method should have 1 url param", (params.size() == 1 ? 1 : 0) != 0);
        metainfo = ResourceInspector.inspect(FlockEntityResource.class);
        Assert.assertTrue((String)"Must be one ResourceMetadata", (metainfo.size() == 1 ? 1 : 0) != 0);
        metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        Assert.assertNotNull((String)"FlockEntityResource supports GET", (Object)metaData.getOperation(HttpMethod.GET));
        Assert.assertNotNull((String)"FlockEntityResource supports PUT", (Object)metaData.getOperation(HttpMethod.PUT));
        Assert.assertNotNull((String)"FlockEntityResource supports DELETE", (Object)metaData.getOperation(HttpMethod.DELETE));
        Assert.assertNull((String)"FlockEntityResource does not support POST", (Object)metaData.getOperation(HttpMethod.POST));
        metainfo = ResourceInspector.inspect(MultiPartTestEntityResource.class);
        Assert.assertTrue((String)"Must be one ResourceMetadata", (metainfo.size() == 1 ? 1 : 0) != 0);
        metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        Assert.assertNotNull((String)"MultiPartTestEntityResource support POST", (Object)metaData.getOperation(HttpMethod.POST));
        Assert.assertNull((String)"MultiPartTestEntityResource does not supports GET", (Object)metaData.getOperation(HttpMethod.GET));
        Assert.assertNull((String)"MultiPartTestEntityResource does not supports PUT", (Object)metaData.getOperation(HttpMethod.PUT));
        Assert.assertNull((String)"MultiPartTestEntityResource does not supports DELETE", (Object)metaData.getOperation(HttpMethod.DELETE));
        op = metaData.getOperation(HttpMethod.POST);
        Assert.assertTrue((String)"MultiPartTestEntityResource must support MultiPartTestResponse", (boolean)MultiPartTestResponse.class.equals((Object)metaData.getObjectType(op)));
        Assert.assertEquals((String)"MultiPartTestEntityResource should return ACCEPTED", (long)202L, (long)op.getSuccessStatus());
    }

    @Test
    public void testInspectRelationship() {
        List metainfo = ResourceInspector.inspect(SheepBlackSheepResource.class);
        Assert.assertTrue((String)"Must be one ResourceMetadata", (metainfo.size() == 1 ? 1 : 0) != 0);
        ResourceMetadata metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        Assert.assertNotNull((String)"SheepBlackSheepResource supports GET", (Object)metaData.getOperation(HttpMethod.GET));
        ResourceOperation op = metaData.getOperation(HttpMethod.GET);
        List params = op.getParameters();
        Assert.assertTrue((String)"readAll method should have 1 url param and 3 query params", (params.size() == 4 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"SheepBlackSheepResource supports PUT", (Object)metaData.getOperation(HttpMethod.PUT));
        op = metaData.getOperation(HttpMethod.PUT);
        params = op.getParameters();
        Assert.assertTrue((String)"update method should have 2 url params and 1 HTTP_OBJECT param ", (params.size() == 3 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"SheepBlackSheepResource supports POST", (Object)metaData.getOperation(HttpMethod.POST));
        op = metaData.getOperation(HttpMethod.POST);
        params = op.getParameters();
        Assert.assertTrue((String)"SheepBlackSheepResource must support Sheep", (boolean)Sheep.class.equals((Object)metaData.getObjectType(op)));
        Assert.assertTrue((String)"create method should have 1 url param and 1 HTTP_OBJECT param ", (params.size() == 2 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)params);
        for (ResourceParameter resourceParameter : params) {
            if (!ResourceParameter.KIND.HTTP_BODY_OBJECT.equals((Object)resourceParameter.getParamType())) continue;
            Assert.assertFalse((boolean)resourceParameter.isAllowMultiple());
        }
        Assert.assertNotNull((String)"SheepBlackSheepResource supports DELETE", (Object)metaData.getOperation(HttpMethod.DELETE));
        op = metaData.getOperation(HttpMethod.DELETE);
        Assert.assertEquals((String)"SheepBlackSheepResource should return STATUS_CONFLICT", (long)409L, (long)op.getSuccessStatus());
        params = op.getParameters();
        Assert.assertTrue((String)"DELETE method on a relations should have 2 url params.", (params.size() == 2 ? 1 : 0) != 0);
        metainfo = ResourceInspector.inspect(MultiPartTestRelationshipResource.class);
        Assert.assertTrue((String)"Must be one ResourceMetadata", (metainfo.size() == 1 ? 1 : 0) != 0);
        metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        Assert.assertNotNull((String)"MultiPartTestRelationshipResource support POST", (Object)metaData.getOperation(HttpMethod.POST));
        Assert.assertNull((String)"MultiPartTestRelationshipResource does not supports GET", (Object)metaData.getOperation(HttpMethod.GET));
        Assert.assertNull((String)"MultiPartTestRelationshipResource does not supports PUT", (Object)metaData.getOperation(HttpMethod.PUT));
        Assert.assertNull((String)"MultiPartTestRelationshipResource does not supports DELETE", (Object)metaData.getOperation(HttpMethod.DELETE));
        op = metaData.getOperation(HttpMethod.POST);
        Assert.assertTrue((String)"MultiPartTestRelationshipResource must support MultiPartTestResponse", (boolean)MultiPartTestResponse.class.equals((Object)metaData.getObjectType(op)));
    }

    @Test
    public void testInspectApi() {
        Api api = ResourceInspector.inspectApi(SheepBlackSheepResource.class);
        Assert.assertNotNull((Object)api);
        Assert.assertEquals((Object)Api.SCOPE.PRIVATE, (Object)api.getScope());
        Assert.assertEquals((long)1L, (long)api.getVersion());
        api = ResourceInspector.inspectApi(String.class);
        Assert.assertNull((Object)api);
        api = ResourceInspector.inspectApi(NodeCommentsRelation.class);
        Assert.assertNotNull((Object)api);
        Assert.assertEquals((Object)Api.SCOPE.PUBLIC, (Object)api.getScope());
        Assert.assertEquals((long)1L, (long)api.getVersion());
    }

    @Test
    public void testNodesCommentsRelation() {
        List metainfo = ResourceInspector.inspect(NodeCommentsRelation.class);
        Assert.assertTrue((String)"Must be one ResourceMetadata", (metainfo.size() == 1 ? 1 : 0) != 0);
        ResourceMetadata metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        ResourceOperation op = metaData.getOperation(HttpMethod.POST);
        Assert.assertTrue((String)"NodeCommentsRelation must support Comment", (boolean)Comment.class.equals((Object)metaData.getObjectType(op)));
    }

    @Test
    public void testUniqueIdAnnotation() {
        String uniqueId = ResourceInspector.findUniqueId((Object)new Grass("34"));
        Assert.assertNull((Object)uniqueId);
        uniqueId = ResourceInspector.findUniqueId((Object)new Farmer("345"));
        Assert.assertNotNull((Object)uniqueId);
        Assert.assertTrue((boolean)"345".equals(uniqueId));
        uniqueId = ResourceInspector.findUniqueId((Object)new FarmersSon("567"));
        Assert.assertNotNull((Object)uniqueId);
        Assert.assertTrue((boolean)"567".equals(uniqueId));
        uniqueId = ResourceInspector.findUniqueId((Object)new FarmersGrandson("12"));
        Assert.assertNotNull((Object)uniqueId);
        Assert.assertTrue((boolean)"12".equals(uniqueId));
        try {
            uniqueId = ResourceInspector.findUniqueId((Object)new FarmersDaughter("21"));
            Assert.fail((String)"Should throw an InvalidArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEmbeddedAnnotation() {
        Map embeds = ResourceInspector.findEmbeddedResources(Farmer.class);
        Assert.assertNotNull((Object)embeds);
        Assert.assertTrue((embeds.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"sheep".equals(((Pair)embeds.get("sheep")).getFirst()));
        Assert.assertTrue((boolean)"goat".equals(((Pair)embeds.get("goat")).getFirst()));
        embeds = ResourceInspector.findEmbeddedResources(FarmersSon.class);
        Assert.assertNotNull((Object)embeds);
        Assert.assertTrue((embeds.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"sheep".equals(((Pair)embeds.get("sheep")).getFirst()));
        Assert.assertTrue((boolean)"goat".equals(((Pair)embeds.get("goat")).getFirst()));
        embeds = ResourceInspector.findEmbeddedResources(FarmersDaughter.class);
        Assert.assertNotNull((Object)embeds);
        Assert.assertTrue((embeds.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"sheep".equals(((Pair)embeds.get("sheep")).getFirst()));
        Assert.assertTrue((boolean)"goat".equals(((Pair)embeds.get("goat")).getFirst()));
        Assert.assertTrue((boolean)"grass".equals(((Pair)embeds.get("specialgrass")).getFirst()));
        embeds = ResourceInspector.findEmbeddedResources(FarmersGrandson.class);
        Assert.assertNotNull((Object)embeds);
        Assert.assertTrue((embeds.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)"sheep".equals(((Pair)embeds.get("sheep")).getFirst()));
        Assert.assertTrue((boolean)"goat".equals(((Pair)embeds.get("grandgoat")).getFirst()));
        embeds = ResourceInspector.findEmbeddedResources(Sheep.class);
        Assert.assertNotNull((Object)embeds);
        Assert.assertTrue((String)"Sheep has no embedded entities", (boolean)embeds.isEmpty());
        embeds = ResourceInspector.findEmbeddedResources(Grass.class);
        Assert.assertNotNull((Object)embeds);
        Assert.assertTrue((String)"Grass has no embedded entities", (boolean)embeds.isEmpty());
        embeds = ResourceInspector.findEmbeddedResources(SlimGoat.class);
        Assert.assertNotNull((Object)embeds);
        Assert.assertTrue((String)"SlimGoat has no embedded entities", (boolean)embeds.isEmpty());
    }

    @Test
    public void testWebDeletedAnnotationOnMethods() {
        Method aMethod = ResourceInspector.findMethod(EntityResourceAction.Read.class, SheepEntityResourceWithDeletedMethods.class);
        Assert.assertNotNull((String)"This method is untouched so should be found.", (Object)aMethod);
        Assert.assertTrue((boolean)"readAll".equals(aMethod.getName()));
        aMethod = ResourceInspector.findMethod(EntityResourceAction.ReadById.class, SheepEntityResourceWithDeletedMethods.class);
        Assert.assertNotNull((String)"This method is overriden but not deleted so should be found.", (Object)aMethod);
        Assert.assertTrue((boolean)"readById".equals(aMethod.getName()));
        aMethod = ResourceInspector.findMethod(EntityResourceAction.Update.class, SheepEntityResourceWithDeletedMethods.class);
        Assert.assertTrue((String)"Update method has been marketed as deleted.", (boolean)ResourceInspector.isDeleted((Method)aMethod));
        aMethod = ResourceInspector.findMethod(EntityResourceAction.Delete.class, SheepEntityResourceWithDeletedMethods.class);
        Assert.assertTrue((String)"Delete method has been marketed as deleted.", (boolean)ResourceInspector.isDeleted((Method)aMethod));
        aMethod = ResourceInspector.findMethod(EntityResourceAction.DeleteSet.class, SheepEntityResourceWithDeletedMethods.class);
        Assert.assertTrue((String)"Delete method has been marketed as deleted.", (boolean)ResourceInspector.isDeleted((Method)aMethod));
    }

    @Test
    public void testInspectOperation() {
        Method aMethod = ResourceInspector.findMethod(EntityResourceAction.Read.class, SheepEntityResource.class);
        ResourceOperation op = ResourceInspector.inspectOperation(SheepEntityResource.class, (Method)aMethod, (HttpMethod)HttpMethod.GET);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)HttpMethod.GET.equals((Object)op.getHttpMethod()));
        Assert.assertTrue((boolean)"Gets all the Sheep".equals(op.getTitle()));
        Assert.assertEquals((String)"Sheep ReadALL should return ACCEPTED", (long)202L, (long)op.getSuccessStatus());
        Assert.assertTrue((boolean)"".equals(op.getDescription()));
        Assert.assertNotNull((Object)op.getParameters());
        Assert.assertTrue((op.getParameters().size() == 7 ? 1 : 0) != 0);
        for (ResourceParameter aParam : op.getParameters()) {
            Assert.assertNotNull((Object)aParam.getName());
            Assert.assertNotNull((Object)aParam.getDescription());
            Assert.assertNotNull((Object)aParam.getTitle());
            switch (aParam.getParamType()) {
                case QUERY_STRING: {
                    if (!"requiredParam".equals(aParam.getName())) break;
                    Assert.assertTrue((boolean)aParam.isRequired());
                    break;
                }
                case URL_PATH: {
                    Assert.assertTrue((boolean)"siteId".equals(aParam.getName()));
                    Assert.assertFalse((boolean)aParam.isRequired());
                    break;
                }
                case HTTP_BODY_OBJECT: {
                    Assert.assertTrue((boolean)"body".equals(aParam.getName()));
                    Assert.assertFalse((boolean)aParam.isRequired());
                    break;
                }
                case HTTP_HEADER: {
                    Assert.assertTrue((boolean)"who".equals(aParam.getName()));
                    Assert.assertFalse((boolean)aParam.isRequired());
                }
            }
        }
        aMethod = ResourceInspector.findMethod(EntityResourceAction.ReadById.class, SheepEntityResource.class);
        op = ResourceInspector.inspectOperation(SheepEntityResource.class, (Method)aMethod, (HttpMethod)HttpMethod.GET);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)op.getTitle().startsWith("Missing @WebApiDescription annotation"));
        aMethod = ResourceInspector.findMethod(EntityResourceAction.ReadById.class, GrassEntityResource.class);
        op = ResourceInspector.inspectOperation(GrassEntityResource.class, (Method)aMethod, (HttpMethod)HttpMethod.GET);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)op.getTitle().startsWith("Gets grass by id"));
        Assert.assertTrue((String)"readById method should have 1 url param", (op.getParameters().size() == 1 ? 1 : 0) != 0);
        ResourceParameter singleParam = (ResourceParameter)op.getParameters().get(0);
        Assert.assertTrue((boolean)ResourceParameter.KIND.URL_PATH.equals((Object)singleParam.getParamType()));
        Assert.assertFalse((String)"URL paths can never suport multiple params, its always FALSE", (boolean)singleParam.isAllowMultiple());
        Assert.assertNotNull((Object)singleParam.getDescription());
        Assert.assertNotNull((Object)singleParam.getTitle());
        Assert.assertNotNull((Object)singleParam.getName());
        Assert.assertTrue((boolean)singleParam.isRequired());
        aMethod = ResourceInspector.findMethod(BinaryResourceAction.Read.class, FlockEntityResource.class);
        op = ResourceInspector.inspectOperation(FlockEntityResource.class, (Method)aMethod, (HttpMethod)HttpMethod.GET);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)op.getTitle().startsWith("Reads a photo as a Stream"));
        aMethod = ResourceInspector.findMethod(BinaryResourceAction.Delete.class, FlockEntityResource.class);
        op = ResourceInspector.inspectOperation(FlockEntityResource.class, (Method)aMethod, (HttpMethod)HttpMethod.DELETE);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)op.getTitle().startsWith("Deletes a photo"));
        aMethod = ResourceInspector.findMethod(BinaryResourceAction.Update.class, FlockEntityResource.class);
        op = ResourceInspector.inspectOperation(FlockEntityResource.class, (Method)aMethod, (HttpMethod)HttpMethod.PUT);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)op.getTitle().startsWith("Updates a photo"));
        aMethod = ResourceInspector.findMethod(BinaryResourceAction.Read.class, SheepBaaaahResource.class);
        op = ResourceInspector.inspectOperation(SheepBaaaahResource.class, (Method)aMethod, (HttpMethod)HttpMethod.GET);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)op.getTitle().startsWith("Reads a photo"));
        aMethod = ResourceInspector.findMethod(BinaryResourceAction.Delete.class, SheepBaaaahResource.class);
        op = ResourceInspector.inspectOperation(SheepBaaaahResource.class, (Method)aMethod, (HttpMethod)HttpMethod.DELETE);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)op.getTitle().startsWith("Deletes a photo"));
        aMethod = ResourceInspector.findMethod(BinaryResourceAction.Update.class, SheepBaaaahResource.class);
        op = ResourceInspector.inspectOperation(SheepBaaaahResource.class, (Method)aMethod, (HttpMethod)HttpMethod.PUT);
        Assert.assertNotNull((Object)op);
        Assert.assertTrue((boolean)op.getTitle().startsWith("Updates a photo"));
    }

    @Test
    public void testInspectBodyParam() {
        Method aMethod = ResourceInspector.findMethod(BinaryResourceAction.Update.class, FlockEntityResource.class);
        ResourceOperation op = ResourceInspector.inspectOperation(FlockEntityResource.class, (Method)aMethod, (HttpMethod)HttpMethod.PUT);
        Assert.assertNotNull((Object)op);
        List params = op.getParameters();
        Assert.assertTrue((params.size() == 2 ? 1 : 0) != 0);
        for (ResourceParameter param : params) {
            if (!ResourceParameter.KIND.HTTP_BODY_OBJECT.equals((Object)param.getParamType())) continue;
            Assert.assertEquals(Flock.class, (Object)param.getDataType());
        }
        aMethod = ResourceInspector.findMethod(RelationshipResourceAction.Create.class, SheepBlackSheepResource.class);
        op = ResourceInspector.inspectOperation(SheepBlackSheepResource.class, (Method)aMethod, (HttpMethod)HttpMethod.POST);
        Assert.assertNotNull((Object)op);
        params = op.getParameters();
        Assert.assertTrue((params.size() == 2 ? 1 : 0) != 0);
        for (ResourceParameter param : params) {
            if (!ResourceParameter.KIND.HTTP_BODY_OBJECT.equals((Object)param.getParamType())) continue;
            Assert.assertEquals(Sheep.class, (Object)param.getDataType());
        }
        aMethod = ResourceInspector.findMethod(EntityResourceAction.Update.class, SheepEntityResourceWithDeletedMethods.class);
        op = ResourceInspector.inspectOperation(SheepEntityResourceWithDeletedMethods.class, (Method)aMethod, (HttpMethod)HttpMethod.POST);
        Assert.assertNotNull((Object)op);
        params = op.getParameters();
        Assert.assertNotNull((Object)params);
        for (ResourceParameter param : params) {
            if (!ResourceParameter.KIND.HTTP_BODY_OBJECT.equals((Object)param.getParamType())) continue;
            Assert.assertEquals(Sheep.class, (Object)param.getDataType());
        }
    }

    @Test
    public void testInspectOperations() throws IllegalAccessException, InstantiationException, Throwable {
        Api api = Api.valueOf((String)"alfrescomock", (String)"private", (String)"1");
        ArrayList metainfo = new ArrayList();
        GrassEntityResource grassEntityResource = new GrassEntityResource();
        ResourceInspector.inspectOperations((Api)api, GrassEntityResource.class, (String)"-root-", metainfo);
        Assert.assertEquals((long)3L, (long)metainfo.size());
        block10: for (ResourceMetadata resourceMetadata : metainfo) {
            Assert.assertEquals((Object)ResourceMetadata.RESOURCE_TYPE.OPERATION, (Object)resourceMetadata.getType());
            OperationResourceMetaData operationResourceMetaData = (OperationResourceMetaData)resourceMetadata;
            Method actionMethod = operationResourceMetaData.getOperationMethod();
            String result = null;
            WithResponse wr = new WithResponse(200, ResponseWriter.DEFAULT_JSON_CONTENT, ResponseWriter.CACHE_NEVER);
            switch (resourceMetadata.getUniqueId()) {
                case "/-root-/{id}/grow": {
                    Assert.assertNotNull((String)"GrassEntityResource supports POST", (Object)resourceMetadata.getOperation(HttpMethod.POST));
                    Assert.assertNull((String)"GrassEntityResource does not support DELETE", (Object)resourceMetadata.getOperation(HttpMethod.DELETE));
                    ResourceOperation op = resourceMetadata.getOperation(HttpMethod.POST);
                    Assert.assertEquals((String)"grow should return ACCEPTED", (long)202L, (long)op.getSuccessStatus());
                    Class paramType = resourceMetadata.getObjectType(op);
                    Object paramObj = paramType.newInstance();
                    result = (String)ResourceInspectorUtil.invokeMethod((Method)actionMethod, (Object)grassEntityResource, (Object[])new Object[]{"xyz", paramObj, Params.valueOf((String)"notUsed", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), wr});
                    Assert.assertEquals((Object)"Growing well", (Object)result);
                    Assert.assertFalse((boolean)operationResourceMetaData.isNoAuth(null));
                    continue block10;
                }
                case "/-root-/{id}/cut": {
                    Assert.assertNotNull((String)"GrassEntityResource supports POST", (Object)resourceMetadata.getOperation(HttpMethod.POST));
                    Assert.assertNull((String)"GrassEntityResource does not support GET", (Object)resourceMetadata.getOperation(HttpMethod.GET));
                    ResourceOperation op = resourceMetadata.getOperation(HttpMethod.POST);
                    Assert.assertNull((Object)resourceMetadata.getObjectType(op));
                    Assert.assertEquals((String)"cut should return ACCEPTED", (long)501L, (long)op.getSuccessStatus());
                    result = (String)ResourceInspectorUtil.invokeMethod((Method)actionMethod, (Object)grassEntityResource, (Object[])new Object[]{"xyz", null, Params.valueOf((String)"notUsed", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), wr});
                    Assert.assertEquals((Object)"All done", (Object)result);
                    Assert.assertFalse((boolean)operationResourceMetaData.isNoAuth(null));
                    continue block10;
                }
                case "/-root-/{id}/cut-noAuth": {
                    Assert.assertNotNull((String)"GrassEntityResource supports POST", (Object)resourceMetadata.getOperation(HttpMethod.POST));
                    ResourceOperation op = resourceMetadata.getOperation(HttpMethod.POST);
                    Assert.assertNull((Object)resourceMetadata.getObjectType(op));
                    Assert.assertEquals((String)"cut should return ACCEPTED", (long)501L, (long)op.getSuccessStatus());
                    result = (String)ResourceInspectorUtil.invokeMethod((Method)actionMethod, (Object)grassEntityResource, (Object[])new Object[]{"xyz", null, Params.valueOf((String)"notUsed", null, (WebScriptRequest)((WebScriptRequest)Mockito.mock(WebScriptRequest.class))), wr});
                    Assert.assertEquals((Object)"All done without Auth", (Object)result);
                    Assert.assertTrue((boolean)operationResourceMetaData.isNoAuth(null));
                    continue block10;
                }
            }
            Assert.fail((String)"Invalid action information.");
        }
    }

    @Test
    public void testInspectRelationshipProperties() {
        List metainfo = ResourceInspector.inspect(GoatRelationshipResource.class);
        Assert.assertTrue((metainfo.size() == 2 ? 1 : 0) != 0);
        block8: for (ResourceMetadata resourceMetadata : metainfo) {
            switch (resourceMetadata.getUniqueId()) {
                case "/goat/{entityId}/herd": {
                    Assert.assertNotNull((String)"GoatRelationshipResource supports GET", (Object)resourceMetadata.getOperation(HttpMethod.GET));
                    continue block8;
                }
                case "/goat/{entityId}/herd/{id}/content": {
                    Assert.assertNotNull((String)"GoatRelationshipResource supports GET", (Object)resourceMetadata.getOperation(HttpMethod.GET));
                    continue block8;
                }
            }
            Assert.fail((String)"Invalid information.");
        }
    }

    @Test
    public void testInspectAddressedProperties() {
        Api api = Api.valueOf((String)"alfrescomock", (String)"private", (String)"1");
        ArrayList metainfo = new ArrayList();
        ResourceInspector.inspectAddressedProperties((Api)api, FlockEntityResource.class, (String)"myroot", metainfo);
        Assert.assertTrue((metainfo.size() == 1 ? 1 : 0) != 0);
        ResourceMetadata metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertEquals((Object)"/myroot/{id}/photo", (Object)metaData.getUniqueId());
        Assert.assertTrue((metaData.getOperations().size() == 3 ? 1 : 0) != 0);
        Assert.assertNotNull((String)"FlockEntityResource supports GET", (Object)metaData.getOperation(HttpMethod.GET));
        Assert.assertNotNull((String)"FlockEntityResource supports PUT", (Object)metaData.getOperation(HttpMethod.PUT));
        Assert.assertNotNull((String)"FlockEntityResource supports DELETE", (Object)metaData.getOperation(HttpMethod.DELETE));
        metainfo.clear();
        ResourceInspector.inspectAddressedProperties((Api)api, FlocketEntityResource.class, (String)"myroot", metainfo);
        Assert.assertTrue((metainfo.size() == 3 ? 1 : 0) != 0);
        for (ResourceMetadata resourceMetadata : metainfo) {
            if ("/myroot/{id}/photo".equals(resourceMetadata.getUniqueId())) {
                Assert.assertNotNull((String)"FlocketEntityResource supports GET", (Object)resourceMetadata.getOperation(HttpMethod.GET));
                Assert.assertNotNull((String)"FlocketEntityResource supports PUT", (Object)resourceMetadata.getOperation(HttpMethod.PUT));
                Assert.assertNotNull((String)"FlocketEntityResource supports DELETE", (Object)resourceMetadata.getOperation(HttpMethod.DELETE));
                continue;
            }
            if ("/myroot/{id}/album".equals(resourceMetadata.getUniqueId())) {
                Assert.assertNotNull((String)"FlocketEntityResource supports GET", (Object)resourceMetadata.getOperation(HttpMethod.GET));
                Assert.assertNotNull((String)"FlocketEntityResource supports PUT", (Object)resourceMetadata.getOperation(HttpMethod.PUT));
                Assert.assertNull((String)"FlocketEntityResource does not support DELETE", (Object)resourceMetadata.getOperation(HttpMethod.DELETE));
                continue;
            }
            if ("/myroot/{id}/madeUpProp".equals(resourceMetadata.getUniqueId())) {
                Assert.assertNotNull((String)"FlocketEntityResource supports GET", (Object)resourceMetadata.getOperation(HttpMethod.GET));
                Assert.assertNull((String)"FlocketEntityResource does not supports PUT", (Object)resourceMetadata.getOperation(HttpMethod.PUT));
                Assert.assertNull((String)"FlocketEntityResource does not support DELETE", (Object)resourceMetadata.getOperation(HttpMethod.DELETE));
                continue;
            }
            Assert.fail((String)"Invalid address property information.");
        }
    }

    @Test
    public void testWebDeletedAnnotationOnClass() {
        List metainfo = ResourceInspector.inspect(GrassEntityResourceNowDeleted.class);
        Assert.assertTrue((String)"Must be at least one ResourceMetadata", (metainfo.size() > 0 ? 1 : 0) != 0);
        ResourceMetadata metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        Assert.assertNull((String)"GrassEntityResourceNowDeleted all methods deleted", (Object)metaData.getOperation(HttpMethod.GET));
        Assert.assertNull((String)"GrassEntityResourceNowDeleted all methods deleted", (Object)metaData.getOperation(HttpMethod.PUT));
        Assert.assertNull((String)"GrassEntityResourceNowDeleted all methods deleted", (Object)metaData.getOperation(HttpMethod.DELETE));
        Assert.assertNull((String)"GrassEntityResourceNowDeleted all methods deleted", (Object)metaData.getOperation(HttpMethod.POST));
        metainfo = ResourceInspector.inspect(SheepBlackSheepResourceIsNoMore.class);
        Assert.assertTrue((String)"Must be at least one ResourceMetadata", (metainfo.size() > 0 ? 1 : 0) != 0);
        metaData = (ResourceMetadata)metainfo.get(0);
        Assert.assertNotNull((Object)metaData);
        Assert.assertNull((String)"SheepBlackSheepResourceIsNoMore all methods deleted", (Object)metaData.getOperation(HttpMethod.GET));
        Assert.assertNull((String)"SheepBlackSheepResourceIsNoMore all methods deleted", (Object)metaData.getOperation(HttpMethod.PUT));
        Assert.assertNull((String)"SheepBlackSheepResourceIsNoMore all methods deleted", (Object)metaData.getOperation(HttpMethod.DELETE));
        Assert.assertNull((String)"SheepBlackSheepResourceIsNoMore all methods deleted", (Object)metaData.getOperation(HttpMethod.POST));
    }

    @Test
    public void testValidSuccessCode() {
        Assert.assertEquals((long)200L, (long)ResourceInspector.validSuccessCode((HttpMethod)HttpMethod.GET, (int)-1));
        Assert.assertEquals((long)201L, (long)ResourceInspector.validSuccessCode((HttpMethod)HttpMethod.POST, (int)-1));
        Assert.assertEquals((long)200L, (long)ResourceInspector.validSuccessCode((HttpMethod)HttpMethod.PUT, (int)-1));
        Assert.assertEquals((long)204L, (long)ResourceInspector.validSuccessCode((HttpMethod)HttpMethod.DELETE, (int)-1));
        Assert.assertEquals((long)202L, (long)ResourceInspector.validSuccessCode((HttpMethod)HttpMethod.GET, (int)202));
        Assert.assertEquals((long)302L, (long)ResourceInspector.validSuccessCode((HttpMethod)HttpMethod.POST, (int)302));
        Assert.assertEquals((long)202L, (long)ResourceInspector.validSuccessCode((HttpMethod)HttpMethod.PUT, (int)202));
        Assert.assertEquals((long)304L, (long)ResourceInspector.validSuccessCode((HttpMethod)HttpMethod.DELETE, (int)304));
    }
}

