/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.archive;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.web.scripts.archive.ArchivedNodesFilter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class NodeTypeFilter
implements ArchivedNodesFilter {
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private List<QName> excludedTypes;

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setExcludedTypes(List<String> excludedTypesStg) {
        this.excludedTypes = new ArrayList<QName>(excludedTypesStg.size());
        for (String s : excludedTypesStg) {
            QName typeQName = QName.createQName((String)s, (NamespacePrefixResolver)this.namespaceService);
            this.excludedTypes.add(typeQName);
        }
    }

    @Override
    public boolean accept(NodeRef nodeRef) {
        boolean typeIsExcluded = this.excludedTypes.contains(this.nodeService.getType(nodeRef));
        return !typeIsExcluded;
    }
}

