/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api;

import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.web.auth.TenantAuthentication;

public class PublicApiTenantAuthentication
implements TenantAuthentication {
    private TenantAdminService tenantAdminService;

    public void setTenantAdminService(TenantAdminService service) {
        this.tenantAdminService = service;
    }

    public boolean tenantExists(final String tenant) {
        if (tenant == null || "".equalsIgnoreCase(tenant)) {
            return true;
        }
        return (Boolean)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                return PublicApiTenantAuthentication.this.tenantAdminService.existsTenant(tenant) && PublicApiTenantAuthentication.this.tenantAdminService.isEnabled();
            }
        });
    }

    @Override
    public boolean authenticateTenant(String username, String networkId) {
        boolean authenticated = false;
        String userNetworkId = this.tenantAdminService.getUserDomain(username);
        if (userNetworkId == null || userNetworkId.equals("")) {
            if (networkId.equalsIgnoreCase("-default-") || networkId.equalsIgnoreCase("-system-")) {
                authenticated = true;
            }
        } else {
            if (networkId.equalsIgnoreCase("-default-")) {
                networkId = userNetworkId;
            }
            if (userNetworkId.equalsIgnoreCase(networkId)) {
                authenticated = this.tenantAdminService.isEnabledTenant(networkId);
            }
        }
        return authenticated;
    }
}

