/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.resource.parameters.where;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.alfresco.rest.framework.resource.parameters.where.InvalidQueryException;
import org.alfresco.rest.framework.resource.parameters.where.QueryHelper;
import org.alfresco.rest.framework.resource.parameters.where.WhereProperty;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BasicQueryWalker
extends QueryHelper.WalkerCallbackAdapter {
    private static final String EQUALS_AND_IN_NOT_ALLOWED_TOGETHER = "Where query error: cannot use '=' (EQUALS) AND 'IN' clauses with same property: %s";
    private static final String MISSING_PROPERTY = "Where query error: property with name: %s not present";
    static final String MISSING_CLAUSE_TYPE = "Where query error: property with name: %s expects clause: %s";
    static final String MISSING_ANY_CLAUSE_OF_TYPE = "Where query error: property with name: %s expects at least one of clauses: %s";
    private static final String PROPERTY_NOT_EXPECTED = "Where query error: property with name: %s is not expected";
    private static final String PROPERTY_NOT_NEGATABLE = "Where query error: property with name: %s cannot be negated";
    private static final String PROPERTY_NAMES_EMPTY = "Cannot verify WHERE query without expected property names";
    private Collection<String> expectedPropertyNames;
    private final Map<String, WhereProperty> properties = new HashMap<String, WhereProperty>();
    protected boolean clausesNegatable = true;
    protected boolean validateStrictly = true;

    public BasicQueryWalker() {
    }

    public BasicQueryWalker(String ... expectedPropertyNames) {
        this();
        this.expectedPropertyNames = Set.of(expectedPropertyNames);
    }

    public BasicQueryWalker(Collection<String> expectedPropertyNames) {
        this();
        this.expectedPropertyNames = expectedPropertyNames;
    }

    public void setClausesNegatable(boolean clausesNegatable) {
        this.clausesNegatable = clausesNegatable;
    }

    public void setValidateStrictly(boolean validateStrictly) {
        this.validateStrictly = validateStrictly;
    }

    @Override
    public void exists(String propertyName, boolean negated) {
        this.verifyPropertyExpectedness(propertyName);
        this.verifyClausesNegatability(negated, propertyName);
        this.addProperties(propertyName, 9, negated, new String[0]);
    }

    @Override
    public void between(String propertyName, String firstValue, String secondValue, boolean negated) {
        this.verifyPropertyExpectedness(propertyName);
        this.verifyClausesNegatability(negated, propertyName);
        this.addProperties(propertyName, 5, negated, firstValue, secondValue);
    }

    @Override
    public void comparison(int type, String propertyName, String propertyValue, boolean negated) {
        this.verifyPropertyExpectedness(propertyName);
        this.verifyClausesNegatability(negated, propertyName);
        if (8 == type && this.isAndSupported() && this.containsProperty(propertyName, 16, negated)) {
            throw new InvalidQueryException((Object)String.format(EQUALS_AND_IN_NOT_ALLOWED_TOGETHER, propertyName));
        }
        this.addProperties(propertyName, type, negated, propertyValue);
    }

    @Override
    public void in(String propertyName, boolean negated, String ... propertyValues) {
        this.verifyPropertyExpectedness(propertyName);
        this.verifyClausesNegatability(negated, propertyName);
        if (this.isAndSupported() && this.containsProperty(propertyName, 8, negated)) {
            throw new InvalidQueryException((Object)String.format(EQUALS_AND_IN_NOT_ALLOWED_TOGETHER, propertyName));
        }
        this.addProperties(propertyName, 16, negated, propertyValues);
    }

    @Override
    public void matches(String propertyName, String propertyValue, boolean negated) {
        this.verifyPropertyExpectedness(propertyName);
        this.verifyClausesNegatability(negated, propertyName);
        this.addProperties(propertyName, 20, negated, propertyValue);
    }

    @Override
    public void and() {
    }

    protected void verifyPropertyExpectedness(String propertyName) {
        if (this.validateStrictly && CollectionUtils.isNotEmpty(this.expectedPropertyNames) && !this.expectedPropertyNames.contains(propertyName)) {
            throw new InvalidQueryException((Object)String.format(PROPERTY_NOT_EXPECTED, propertyName));
        }
        if (this.validateStrictly && CollectionUtils.isEmpty(this.expectedPropertyNames)) {
            throw new IllegalStateException(PROPERTY_NAMES_EMPTY);
        }
    }

    protected void verifyClausesNegatability(boolean negated, String propertyName) {
        if (!this.clausesNegatable && negated) {
            throw new InvalidQueryException((Object)String.format(PROPERTY_NOT_NEGATABLE, propertyName));
        }
    }

    protected boolean isAndSupported() {
        try {
            this.and();
            return true;
        }
        catch (InvalidQueryException ignore) {
            return false;
        }
    }

    protected void addProperties(String propertyName, int clauseType, String ... propertyValues) {
        this.addProperties(propertyName, clauseType, false, propertyValues);
    }

    protected void addProperties(String propertyName, int clauseType, boolean negated, String ... propertyValues) {
        WhereProperty.ClauseType type = WhereProperty.ClauseType.of(clauseType, negated);
        Set<String> propertiesToAdd = Optional.ofNullable(propertyValues).map(Set::of).orElse(Collections.emptySet());
        if (this.containsProperty(propertyName)) {
            this.properties.get(propertyName).addValuesToType(type, propertiesToAdd);
        } else {
            this.properties.put(propertyName, new WhereProperty(propertyName, type, propertiesToAdd, this.validateStrictly));
        }
    }

    protected boolean containsProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    protected boolean containsProperty(String propertyName, int clauseType, boolean negated) {
        return this.properties.containsKey(propertyName) && this.properties.get(propertyName).containsType(clauseType, negated);
    }

    @Override
    public Collection<String> getProperty(String propertyName, int type, boolean negated) {
        return this.getProperty(propertyName).getExpectedValuesFor(type, negated);
    }

    public WhereProperty getProperty(String propertyName) {
        if (this.validateStrictly && !this.containsProperty(propertyName)) {
            throw new InvalidQueryException((Object)String.format(MISSING_PROPERTY, propertyName));
        }
        return this.properties.get(propertyName);
    }

    public List<WhereProperty> getProperties(String ... propertyNames) {
        return Arrays.stream(propertyNames).filter(StringUtils::isNotBlank).distinct().peek(propertyName -> {
            if (this.validateStrictly && !this.containsProperty((String)propertyName)) {
                throw new InvalidQueryException((Object)String.format(MISSING_PROPERTY, propertyName));
            }
        }).map(this.properties::get).collect(Collectors.toList());
    }

    public Map<String, WhereProperty> getPropertiesAsMap(String ... propertyNames) {
        return Arrays.stream(propertyNames).filter(StringUtils::isNotBlank).distinct().peek(propertyName -> {
            if (this.validateStrictly && !this.containsProperty((String)propertyName)) {
                throw new InvalidQueryException((Object)String.format(MISSING_PROPERTY, propertyName));
            }
        }).collect(Collectors.toMap(propertyName -> propertyName, this.properties::get));
    }
}

