/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client;

import org.alfresco.rest.api.tests.client.HttpClientProvider;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;

public final class SharedHttpClientProvider
implements HttpClientProvider {
    private HttpClient client;
    private String alfrescoUrl;

    public SharedHttpClientProvider(String alfrescoUrl, int maxNumberOfConnections) {
        this.setAlfrescoUrl(alfrescoUrl);
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setMaxTotalConnections(maxNumberOfConnections);
        params.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, maxNumberOfConnections);
        this.client = new HttpClient((HttpConnectionManager)manager);
        this.client.getParams().setAuthenticationPreemptive(true);
    }

    private void setAlfrescoUrl(String alfrescoUrl) {
        this.alfrescoUrl = alfrescoUrl;
        if (alfrescoUrl != null && !alfrescoUrl.endsWith("/")) {
            this.alfrescoUrl = alfrescoUrl.concat("/");
        }
    }

    @Override
    public String getFullAlfrescoUrlForPath(String path) {
        if (path.startsWith("/")) {
            return this.alfrescoUrl.concat(path.substring(1, path.length()));
        }
        return this.alfrescoUrl.concat(path);
    }

    @Override
    public HttpClient getHttpClient() {
        return this.client;
    }
}

