/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.alfresco.repo.web.scripts.BufferedRequest;
import org.alfresco.repo.web.scripts.BufferedResponse;
import org.alfresco.repo.web.scripts.TempOutputStream;
import org.alfresco.rest.framework.Api;
import org.alfresco.rest.framework.tools.ApiAssistant;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.AbstractWebScript;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public abstract class ApiWebScript
extends AbstractWebScript {
    private static Log logger = LogFactory.getLog(ApiWebScript.class);
    protected ApiAssistant assistant;
    protected boolean encryptTempFiles = false;
    protected String tempDirectoryName = null;
    protected int memoryThreshold = 0x400000;
    protected long maxContentSize = 0x100000000L;
    protected Supplier<TempOutputStream> streamFactory = null;
    protected TransactionService transactionService;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setAssistant(ApiAssistant assistant) {
        this.assistant = assistant;
    }

    public void setTempDirectoryName(String tempDirectoryName) {
        this.tempDirectoryName = tempDirectoryName;
    }

    public void setEncryptTempFiles(boolean encryptTempFiles) {
        this.encryptTempFiles = encryptTempFiles;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public void setMaxContentSize(long maxContentSize) {
        this.maxContentSize = maxContentSize;
    }

    public void setStreamFactory(Supplier<TempOutputStream> streamFactory) {
        this.streamFactory = streamFactory;
    }

    public void init() {
        File tempDirectory = TempFileProvider.getTempDir((String)this.tempDirectoryName);
        this.streamFactory = TempOutputStream.factory(tempDirectory, this.memoryThreshold, this.maxContentSize, false);
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        Api api = ApiAssistant.determineApi(templateVars);
        try (BufferedRequest bufferedReq = this.getRequest(req);
             BufferedResponse bufferedRes = this.getResponse(res);){
            this.execute(api, (WebScriptRequest)bufferedReq, (WebScriptResponse)bufferedRes);
            if (bufferedRes != null) {
                bufferedRes.writeResponse();
            }
        }
    }

    protected BufferedRequest getRequest(WebScriptRequest req) {
        return new BufferedRequest(req, this.streamFactory);
    }

    protected BufferedResponse getResponse(WebScriptResponse resp) {
        return new BufferedResponse(resp, this.memoryThreshold, this.streamFactory);
    }

    public abstract void execute(Api var1, WebScriptRequest var2, WebScriptResponse var3) throws IOException;
}

