/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.mapper.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.IntStream;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.rest.api.impl.mapper.rules.RestRuleCompositeConditionModelMapper;
import org.alfresco.rest.api.model.mapper.RestModelMapper;
import org.alfresco.rest.api.model.rules.CompositeCondition;
import org.alfresco.rest.api.model.rules.ConditionOperator;
import org.alfresco.rest.api.model.rules.SimpleCondition;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.action.ActionCondition;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Experimental
public class RestRuleCompositeConditionModelMapperTest {
    @Mock
    private RestModelMapper<SimpleCondition, ActionCondition> simpleConditionMapperMock;
    @InjectMocks
    private RestRuleCompositeConditionModelMapper objectUnderTest;

    @Test
    public void testToRestModel() {
        List<ActionCondition> actionConditions = List.of(RestRuleCompositeConditionModelMapperTest.createActionCondition("value1"), RestRuleCompositeConditionModelMapperTest.createActionCondition("value3"), RestRuleCompositeConditionModelMapperTest.createActionCondition("value2", true));
        List<SimpleCondition> simpleConditions = List.of(RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value1"), RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value3"), RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value2"));
        CompositeCondition expectedCompositeCondition = RestRuleCompositeConditionModelMapperTest.createCompositeCondition(List.of(RestRuleCompositeConditionModelMapperTest.createCompositeCondition(false, simpleConditions.subList(0, 2)), RestRuleCompositeConditionModelMapperTest.createCompositeCondition(true, simpleConditions.subList(2, 3))));
        BDDMockito.given((Object)this.simpleConditionMapperMock.toRestModels(actionConditions.subList(2, 3))).willReturn(simpleConditions.subList(2, 3));
        BDDMockito.given((Object)this.simpleConditionMapperMock.toRestModels(actionConditions.subList(0, 2))).willReturn(simpleConditions.subList(0, 2));
        CompositeCondition actualCompositeCondition = this.objectUnderTest.toRestModel(actionConditions);
        ((ObjectAssert)Assertions.assertThat((Object)actualCompositeCondition).isNotNull()).usingRecursiveComparison().isEqualTo((Object)expectedCompositeCondition);
    }

    @Test
    public void testToRestModel_fromEmptyList() {
        List actionConditions = Collections.emptyList();
        CompositeCondition actualCompositeCondition = this.objectUnderTest.toRestModel(actionConditions);
        Assertions.assertThat((Object)actualCompositeCondition).isNull();
    }

    @Test
    public void testToRestModel_fromNullValue() {
        CompositeCondition actualCompositeCondition = this.objectUnderTest.toRestModel((Collection)null);
        Assertions.assertThat((Object)actualCompositeCondition).isNull();
    }

    @Test
    public void testToRestModel_fromListContainingNullsOnly() {
        ArrayList<Object> actionConditions = new ArrayList<Object>();
        actionConditions.add(null);
        actionConditions.add(null);
        CompositeCondition actualCompositeCondition = this.objectUnderTest.toRestModel(actionConditions);
        Assertions.assertThat((Object)actualCompositeCondition).isNull();
    }

    @Test
    public void testToRestModel_fromNoCondition() {
        ArrayList<ActionConditionImpl> actionConditions = new ArrayList<ActionConditionImpl>();
        ActionConditionImpl noCondition = new ActionConditionImpl("fake-id", "no-condition");
        actionConditions.add(noCondition);
        CompositeCondition actualCompositeCondition = this.objectUnderTest.toRestModel(actionConditions);
        Assertions.assertThat((Object)actualCompositeCondition).isNull();
    }

    @Test
    public void testToServiceModels() {
        List<SimpleCondition> simpleConditions = List.of(RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value1"), RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value3"), RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value2"));
        CompositeCondition compositeCondition = RestRuleCompositeConditionModelMapperTest.createCompositeCondition(List.of(RestRuleCompositeConditionModelMapperTest.createCompositeCondition(false, simpleConditions.subList(0, 2)), RestRuleCompositeConditionModelMapperTest.createCompositeCondition(true, simpleConditions.subList(2, 3))));
        List<ActionCondition> actionConditions = List.of(RestRuleCompositeConditionModelMapperTest.createActionCondition("value1"), RestRuleCompositeConditionModelMapperTest.createActionCondition("value3"), RestRuleCompositeConditionModelMapperTest.createActionCondition("value2", true));
        IntStream.rangeClosed(0, 2).forEach(i -> BDDMockito.given((Object)((ActionCondition)this.simpleConditionMapperMock.toServiceModel((Object)((SimpleCondition)simpleConditions.get(i))))).willReturn((Object)((ActionCondition)actionConditions.get(i))));
        List actualActionConditions = this.objectUnderTest.toServiceModels(compositeCondition);
        Assertions.assertThat((List)actualActionConditions).isEqualTo(actionConditions);
    }

    @Test
    public void testToServiceModels_simpleNonInvertedConditionsOnly() {
        List<SimpleCondition> simpleConditions = List.of(RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value1"), RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value2"), RestRuleCompositeConditionModelMapperTest.createSimpleCondition("value3"));
        CompositeCondition compositeCondition = RestRuleCompositeConditionModelMapperTest.createCompositeCondition(false, simpleConditions);
        List<ActionCondition> actionConditions = List.of(RestRuleCompositeConditionModelMapperTest.createActionCondition("value1"), RestRuleCompositeConditionModelMapperTest.createActionCondition("value2"), RestRuleCompositeConditionModelMapperTest.createActionCondition("value3"));
        IntStream.rangeClosed(0, 2).forEach(i -> BDDMockito.given((Object)((ActionCondition)this.simpleConditionMapperMock.toServiceModel((Object)((SimpleCondition)simpleConditions.get(i))))).willReturn((Object)((ActionCondition)actionConditions.get(i))));
        List actualActionConditions = this.objectUnderTest.toServiceModels(compositeCondition);
        Assertions.assertThat((List)actualActionConditions).isEqualTo(actionConditions);
    }

    @Test
    public void testToServiceModels_nullSimpleConditions() {
        CompositeCondition compositeCondition = RestRuleCompositeConditionModelMapperTest.createCompositeCondition(false, null);
        List actualActionConditions = this.objectUnderTest.toServiceModels(compositeCondition);
        ((ListAssert)Assertions.assertThat((List)actualActionConditions).isNotNull()).isEmpty();
    }

    @Test
    public void testToServiceModels_emptyCompositeCondition() {
        CompositeCondition compositeCondition = CompositeCondition.builder().create();
        List actualActionConditions = this.objectUnderTest.toServiceModels(compositeCondition);
        ((ListAssert)Assertions.assertThat((List)actualActionConditions).isNotNull()).isEmpty();
    }

    @Test
    public void testToServiceModels_nullCompositeCondition() {
        CompositeCondition compositeCondition = null;
        List actualActionConditions = this.objectUnderTest.toServiceModels(compositeCondition);
        ((ListAssert)Assertions.assertThat((List)actualActionConditions).isNotNull()).isEmpty();
    }

    private static ActionCondition createActionCondition(String value) {
        return RestRuleCompositeConditionModelMapperTest.createActionCondition(value, false);
    }

    private static ActionCondition createActionCondition(String value, boolean inverted) {
        ActionConditionImpl actionCondition = new ActionConditionImpl("fake-id", "compare-property-value");
        actionCondition.setInvertCondition(inverted);
        HashMap<String, String> parameterValues = new HashMap<String, String>();
        parameterValues.put("content-property", "content-property");
        parameterValues.put("operation", "operation");
        parameterValues.put("value", value);
        actionCondition.setParameterValues(parameterValues);
        return actionCondition;
    }

    private static SimpleCondition createSimpleCondition(String value) {
        return SimpleCondition.builder().field("content-property").comparator("operation").parameter(value).create();
    }

    private static CompositeCondition createCompositeCondition(List<CompositeCondition> compositeConditions) {
        return RestRuleCompositeConditionModelMapperTest.createCompositeCondition(false, ConditionOperator.AND, compositeConditions, null);
    }

    private static CompositeCondition createCompositeCondition(boolean inverted, List<SimpleCondition> simpleConditions) {
        return RestRuleCompositeConditionModelMapperTest.createCompositeCondition(inverted, ConditionOperator.AND, null, simpleConditions);
    }

    private static CompositeCondition createCompositeCondition(boolean inverted, ConditionOperator conditionOperator, List<CompositeCondition> compositeConditions, List<SimpleCondition> simpleConditions) {
        return CompositeCondition.builder().inverted(inverted).booleanMode(conditionOperator).compositeConditions(compositeConditions).simpleConditions(simpleConditions).create();
    }
}

