/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.UserTransaction;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.LockMethod;
import org.alfresco.repo.webdav.PutMethod;
import org.alfresco.repo.webdav.UnlockMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Category(value={LuceneTests.class})
public class WebDAVonContentUpdateTest {
    private static ApplicationContext ctx;
    private static final String TEST_DATA_FILE_NAME = "filewithdata.txt";
    private static final String DAV_LOCK_INFO_XML = "davLockInfoAdmin.xml";
    private byte[] testDataFile;
    private byte[] davLockInfoFile;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private WebDAVMethod method;
    private UserTransaction txn = null;
    private SearchService searchService;
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private WebDAVHelper webDAVHelper;
    private LockService lockService;
    private PolicyComponent policyComponent;
    private Repository repositoryHelper;
    private NodeRef companyHomeNodeRef;
    private StoreRef storeRef = new StoreRef("workspace", "SpacesStore");
    private boolean flag;
    private int counter = 0;
    private NamespaceService namespaceService;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/remote-api-context.xml"});
    }

    @Before
    public void setUp() throws Exception {
        this.searchService = (SearchService)ctx.getBean("SearchService", SearchService.class);
        this.fileFolderService = (FileFolderService)ctx.getBean("FileFolderService", FileFolderService.class);
        this.nodeService = (NodeService)ctx.getBean("NodeService", NodeService.class);
        this.transactionService = (TransactionService)ctx.getBean("transactionService", TransactionService.class);
        this.webDAVHelper = (WebDAVHelper)ctx.getBean("webDAVHelper", WebDAVHelper.class);
        this.lockService = (LockService)ctx.getBean("LockService", LockService.class);
        this.policyComponent = (PolicyComponent)ctx.getBean("policyComponent", PolicyComponent.class);
        this.namespaceService = (NamespaceService)ctx.getBean("namespaceService", NamespaceService.class);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.repositoryHelper = (Repository)ctx.getBean("repositoryHelper");
        this.companyHomeNodeRef = this.repositoryHelper.getCompanyHome();
        InputStream testDataIS = this.getClass().getClassLoader().getResourceAsStream(TEST_DATA_FILE_NAME);
        InputStream davLockInfoIS = this.getClass().getClassLoader().getResourceAsStream(DAV_LOCK_INFO_XML);
        this.testDataFile = IOUtils.toByteArray((InputStream)testDataIS);
        this.davLockInfoFile = IOUtils.toByteArray((InputStream)davLockInfoIS);
        testDataIS.close();
        davLockInfoIS.close();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
    }

    @After
    public void tearDown() throws Exception {
        this.method = null;
        this.request = null;
        this.response = null;
        this.testDataFile = null;
        this.davLockInfoFile = null;
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void doOnContentUpdate(NodeRef nodeRef, boolean newContent) {
        this.flag = true;
        ++this.counter;
    }

    @Test
    public void testUploadNewContentFiresContentUpdatePolicies() throws Exception {
        this.flag = false;
        this.counter = 0;
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour((Object)this, "doOnContentUpdate"));
        String fileName = "file-" + GUID.generate();
        NodeRef fileNoderef = null;
        try {
            this.executeMethod("LOCK", fileName, this.davLockInfoFile, null);
            List refs = this.searchService.selectNodes(this.nodeService.getRootNode(this.storeRef), "/app:company_home/cm:" + fileName, null, (NamespacePrefixResolver)this.namespaceService, false);
            fileNoderef = (NodeRef)refs.get(0);
            Assert.assertEquals((String)"File should be locked", (Object)LockStatus.LOCK_OWNER, (Object)this.lockService.getLockStatus(fileNoderef));
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to lock a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        String lockToken = fileNoderef.getId() + ":" + AuthenticationUtil.getAdminUserName();
        String lockHeaderValue = "(<opaquelocktoken:" + lockToken + ">)";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("If", lockHeaderValue);
        try {
            this.executeMethod("PUT", fileName, this.testDataFile, headers);
            Assert.assertTrue((String)"File does not exist.", (boolean)this.nodeService.exists(fileNoderef));
            Assert.assertEquals((String)"Filename is not correct", (Object)fileName, (Object)this.nodeService.getProperty(fileNoderef, ContentModel.PROP_NAME));
            Assert.assertTrue((String)("Expected return status is 204, but returned is " + this.response.getStatus()), (204 == this.response.getStatus() ? 1 : 0) != 0);
            Assert.assertTrue((String)"File should have NO_CONTENT aspect", (boolean)this.nodeService.hasAspect(fileNoderef, ContentModel.ASPECT_NO_CONTENT));
            InputStream updatedFileIS = this.fileFolderService.getReader(fileNoderef).getContentInputStream();
            byte[] updatedFile = IOUtils.toByteArray((InputStream)updatedFileIS);
            updatedFileIS.close();
            Assert.assertTrue((String)"The content has to be equal", (boolean)ArrayUtils.isEquals((Object)this.testDataFile, (Object)updatedFile));
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to upload a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        this.txn.commit();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        headers = new HashMap();
        headers.put("Lock-Token", "<opaquelocktoken:" + lockToken + ">");
        try {
            this.executeMethod("UNLOCK", fileName, null, headers);
            Assert.assertTrue((String)("Expected return status is 204, but returned is " + this.response.getStatus()), (204 == this.response.getStatus() ? 1 : 0) != 0);
            Assert.assertFalse((String)"File should not have NO_CONTENT aspect", (boolean)this.nodeService.hasAspect(fileNoderef, ContentModel.ASPECT_NO_CONTENT));
            Assert.assertEquals((String)"File should be unlocked", (Object)LockStatus.NO_LOCK, (Object)this.lockService.getLockStatus(fileNoderef));
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to unlock a file: " + (e.getCause() != null ? e.getCause().getMessage() : e.getMessage())));
        }
        Assert.assertTrue((String)"onContentUpdate policies were not triggered", (boolean)this.flag);
        Assert.assertEquals((String)"onContentUpdate policies should be triggered only once", (long)this.counter, (long)1L);
        if (fileNoderef != null) {
            this.nodeService.deleteNode(fileNoderef);
        }
    }

    private void executeMethod(String methodName, String fileName, byte[] content, Map<String, String> headers) throws Exception {
        if (methodName == "PUT") {
            this.method = new PutMethod();
        } else if (methodName == "LOCK") {
            this.method = new LockMethod();
        } else if (methodName == "UNLOCK") {
            this.method = new UnlockMethod();
        }
        if (this.method != null) {
            this.request = new MockHttpServletRequest(methodName, "/alfresco/webdav/" + fileName);
            this.response = new MockHttpServletResponse();
            this.request.setServerPort(8080);
            this.request.setServletPath("/webdav");
            if (content != null) {
                this.request.setContent(content);
            }
            if (headers != null && !headers.isEmpty()) {
                for (String key : headers.keySet()) {
                    this.request.addHeader(key, (Object)headers.get(key));
                }
            }
            this.method.setDetails((HttpServletRequest)this.request, (HttpServletResponse)this.response, this.webDAVHelper, this.companyHomeNodeRef);
            this.method.execute();
        }
    }
}

