/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.content.ContentRestoreParams;
import org.alfresco.rest.api.impl.ContentStorageInformationImpl;
import org.alfresco.rest.api.model.ArchiveContentRequest;
import org.alfresco.rest.api.model.ContentStorageInfo;
import org.alfresco.rest.api.model.RestoreArchivedContentRequest;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.RestoreInProgressException;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContentStorageInformationImplTest {
    private static final String DUMMY_NODE_ID = "dummy-node-id";
    private static final String CONTENT_PROP_NAME = "cm:content";
    private static final String STANDARD_PRIORITY = "Standard";
    private static final NodeRef DUMMY_NODE_REF = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "dummy-node-id");
    @Mock
    private ContentService contentService;
    @Mock
    private NamespaceService namespaceService;
    @InjectMocks
    private ContentStorageInformationImpl objectUnderTest;

    @Test
    public void shouldReturnStorageInfoResponseWithNonEmptyStorageProps() {
        Map<String, String> storageProps = Map.of("x-amz-storage-class", "INTELLIGENT_TIERING", "x-alf-archived", "false");
        Mockito.when((Object)this.contentService.getStorageProperties((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any())).thenReturn(storageProps);
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        Mockito.when((Object)this.namespaceService.getPrefixes("http://www.alfresco.org/model/content/1.0")).thenReturn(List.of("cm"));
        ContentStorageInfo storageInfo = this.objectUnderTest.getStorageInfo(DUMMY_NODE_REF, CONTENT_PROP_NAME, null);
        Assert.assertEquals(storageProps, (Object)storageInfo.getStorageProperties());
        Assert.assertEquals((Object)CONTENT_PROP_NAME, (Object)storageInfo.getId());
    }

    @Test
    public void shouldReturnStorageInfoResponseWithEmptyStorageProps() {
        Mockito.when((Object)this.contentService.getStorageProperties((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any())).thenCallRealMethod();
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        Mockito.when((Object)this.namespaceService.getPrefixes("http://www.alfresco.org/model/content/1.0")).thenReturn(List.of("cm"));
        ContentStorageInfo storageInfo = this.objectUnderTest.getStorageInfo(DUMMY_NODE_REF, CONTENT_PROP_NAME, null);
        Assert.assertEquals(Collections.emptyMap(), (Object)storageInfo.getStorageProperties());
        Assert.assertEquals((Object)CONTENT_PROP_NAME, (Object)storageInfo.getId());
    }

    @Test
    public void shouldSucceedOnArchiveContent() {
        Map archiveProps = Collections.emptyMap();
        ArchiveContentRequest archiveParamsRequest = new ArchiveContentRequest();
        archiveParamsRequest.setArchiveParams(archiveProps);
        boolean expectedResult = true;
        Mockito.when((Object)this.contentService.requestSendContentToArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(archiveProps))).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        boolean requestArchiveContent = this.objectUnderTest.requestArchiveContent(DUMMY_NODE_REF, CONTENT_PROP_NAME, archiveParamsRequest);
        Assert.assertEquals((Object)true, (Object)requestArchiveContent);
    }

    @Test
    public void shouldSucceedOnArchiveContentWhenNoRequestBody() {
        Map archiveProps = Collections.emptyMap();
        boolean expectedResult = true;
        Mockito.when((Object)this.contentService.requestSendContentToArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(archiveProps))).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        boolean requestArchiveContent = this.objectUnderTest.requestArchiveContent(DUMMY_NODE_REF, CONTENT_PROP_NAME, null);
        Assert.assertEquals((Object)true, (Object)requestArchiveContent);
    }

    @Test
    public void shouldNotSucceedOnArchiveContent() {
        Map archiveProps = Collections.emptyMap();
        ArchiveContentRequest archiveParamsRequest = new ArchiveContentRequest();
        archiveParamsRequest.setArchiveParams(archiveProps);
        boolean expectedResult = false;
        Mockito.when((Object)this.contentService.requestSendContentToArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(archiveProps))).thenReturn((Object)false);
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        boolean requestArchiveContent = this.objectUnderTest.requestArchiveContent(DUMMY_NODE_REF, CONTENT_PROP_NAME, archiveParamsRequest);
        Assert.assertEquals((Object)false, (Object)requestArchiveContent);
    }

    @Test
    public void shouldThrowExceptionOnArchiveContent() {
        Map archiveProps = Collections.emptyMap();
        ArchiveContentRequest archiveParamsRequest = new ArchiveContentRequest();
        archiveParamsRequest.setArchiveParams(archiveProps);
        Mockito.when((Object)this.contentService.requestSendContentToArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(archiveProps))).thenCallRealMethod();
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.objectUnderTest.requestArchiveContent(DUMMY_NODE_REF, CONTENT_PROP_NAME, archiveParamsRequest));
    }

    @Test
    public void shouldSucceedOnRestoreContentFromArchive() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), STANDARD_PRIORITY);
        RestoreArchivedContentRequest restoreArchivedContentRequest = new RestoreArchivedContentRequest();
        restoreArchivedContentRequest.setRestorePriority(STANDARD_PRIORITY);
        boolean expectedResult = true;
        Mockito.when((Object)this.contentService.requestRestoreContentFromArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(restoreParams))).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        boolean requestArchiveContent = this.objectUnderTest.requestRestoreContentFromArchive(DUMMY_NODE_REF, CONTENT_PROP_NAME, restoreArchivedContentRequest);
        Assert.assertEquals((Object)true, (Object)requestArchiveContent);
    }

    @Test
    public void shouldSucceedOnRestoreContentFromArchiveWhenNoRequestBody() {
        boolean expectedResult = true;
        Mockito.when((Object)this.contentService.requestRestoreContentFromArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(Collections.emptyMap()))).thenReturn((Object)true);
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        boolean requestArchiveContent = this.objectUnderTest.requestRestoreContentFromArchive(DUMMY_NODE_REF, CONTENT_PROP_NAME, null);
        Assert.assertEquals((Object)true, (Object)requestArchiveContent);
    }

    @Test
    public void shouldNotSucceedOnRestoreContentFromArchive() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), STANDARD_PRIORITY);
        RestoreArchivedContentRequest restoreArchivedContentRequest = new RestoreArchivedContentRequest();
        restoreArchivedContentRequest.setRestorePriority(STANDARD_PRIORITY);
        boolean expectedResult = false;
        Mockito.when((Object)this.contentService.requestRestoreContentFromArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(restoreParams))).thenReturn((Object)false);
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        boolean requestArchiveContent = this.objectUnderTest.requestRestoreContentFromArchive(DUMMY_NODE_REF, CONTENT_PROP_NAME, restoreArchivedContentRequest);
        Assert.assertEquals((Object)false, (Object)requestArchiveContent);
    }

    @Test
    public void shouldThrowExceptionRestoreContentFromArchive() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), STANDARD_PRIORITY);
        RestoreArchivedContentRequest restoreArchivedContentRequest = new RestoreArchivedContentRequest();
        restoreArchivedContentRequest.setRestorePriority(STANDARD_PRIORITY);
        Mockito.when((Object)this.contentService.requestRestoreContentFromArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(restoreParams))).thenCallRealMethod();
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        Assert.assertThrows(UnsupportedOperationException.class, () -> this.objectUnderTest.requestRestoreContentFromArchive(DUMMY_NODE_REF, CONTENT_PROP_NAME, restoreArchivedContentRequest));
    }

    @Test
    public void shouldThrowRestoreInProgressExceptionRestoreContentFromArchive() {
        Map<String, String> restoreParams = Map.of(ContentRestoreParams.RESTORE_PRIORITY.name(), STANDARD_PRIORITY);
        RestoreArchivedContentRequest restoreArchivedContentRequest = new RestoreArchivedContentRequest();
        restoreArchivedContentRequest.setRestorePriority(STANDARD_PRIORITY);
        Mockito.when((Object)this.contentService.requestRestoreContentFromArchive((NodeRef)ArgumentMatchers.eq((Object)DUMMY_NODE_REF), (QName)ArgumentMatchers.any(QName.class), (Map)ArgumentMatchers.eq(restoreParams))).thenThrow(new Throwable[]{new RestoreInProgressException("Error")});
        Mockito.when((Object)this.namespaceService.getNamespaceURI("cm")).thenReturn((Object)"http://www.alfresco.org/model/content/1.0");
        Assert.assertThrows(org.alfresco.rest.framework.core.exceptions.RestoreInProgressException.class, () -> this.objectUnderTest.requestRestoreContentFromArchive(DUMMY_NODE_REF, CONTENT_PROP_NAME, restoreArchivedContentRequest));
    }
}

