/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.nodes;

import org.alfresco.rest.api.ContentStorageInformation;
import org.alfresco.rest.api.model.ArchiveContentRequest;
import org.alfresco.rest.api.model.ContentStorageInfo;
import org.alfresco.rest.api.model.RestoreArchivedContentRequest;
import org.alfresco.rest.api.nodes.NodeVersionsRelation;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="storage-info", entityResource=NodeVersionsRelation.class, title="Node Version's content storage information")
public class NodeVersionsStorageInfoRelation
implements RelationshipResourceAction.ReadById<ContentStorageInfo>,
InitializingBean {
    private final ContentStorageInformation storageInformation;
    private NodeVersionsRelation nodeVersions;

    public NodeVersionsStorageInfoRelation(ContentStorageInformation storageInformation, NodeVersionsRelation nodeVersions) {
        this.storageInformation = storageInformation;
        this.nodeVersions = nodeVersions;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"storageInformation", (Object)this.storageInformation);
        PropertyCheck.mandatory((Object)this, (String)"nodeVersions", (Object)this.nodeVersions);
    }

    @Override
    @WebApiDescription(title="Get storage properties", description="Retrieves storage properties for given node version content", successStatus=200)
    public ContentStorageInfo readById(String nodeId, String versionId, Parameters parameters) throws RelationshipResourceNotFoundException {
        String contentPropQNameId = parameters.getRelationship2Id();
        NodeRef versionNodeRef = this.findVersionNodeRef(nodeId, versionId);
        return this.storageInformation.getStorageInfo(versionNodeRef, contentPropQNameId, parameters);
    }

    @Operation(value="archive")
    @WebApiParam(name="archiveContentRequest", title="Request for archive version content", description="Optional parameters for archive version content", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request send version content to archive", description="Submits a request to send version content to archive", successStatus=200)
    public void requestArchiveContent(String nodeId, String versionId, ArchiveContentRequest archiveContentRequest, Parameters parameters, WithResponse withResponse) {
        String contentPropQNameId = parameters.getRelationship2Id();
        NodeRef versionNodeRef = this.findVersionNodeRef(nodeId, versionId);
        boolean result = this.storageInformation.requestArchiveContent(versionNodeRef, contentPropQNameId, archiveContentRequest);
        if (result) {
            withResponse.setStatus(200);
        } else {
            withResponse.setStatus(501);
        }
    }

    @Operation(value="archive-restore")
    @WebApiParam(name="restoreArchivedContentRequest", title="Request for restore version content from archive", description="Optional parameters for restore version content from archive", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT)
    @WebApiDescription(title="Request restore version content from archive", description="Submits a request to restore version content from archive", successStatus=202)
    public void requestRestoreContentFromArchive(String nodeId, String versionId, RestoreArchivedContentRequest restoreArchivedContentRequest, Parameters parameters, WithResponse withResponse) {
        String contentPropQNameId = parameters.getRelationship2Id();
        NodeRef versionNodeRef = this.findVersionNodeRef(nodeId, versionId);
        boolean result = this.storageInformation.requestRestoreContentFromArchive(versionNodeRef, contentPropQNameId, restoreArchivedContentRequest);
        if (result) {
            withResponse.setStatus(202);
        } else {
            withResponse.setStatus(501);
        }
    }

    private NodeRef findVersionNodeRef(String nodeId, String versionId) {
        Version version = this.nodeVersions.findVersion(nodeId, versionId);
        if (version == null) {
            throw new EntityNotFoundException(nodeId + "-" + versionId);
        }
        return version.getFrozenStateNodeRef();
    }
}

