/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl;

import org.alfresco.repo.content.directurl.SystemWideDirectUrlConfig;
import org.alfresco.rest.api.impl.directurl.RestApiDirectUrlConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RestApiDirectUrlConfigUnitTest {
    private static final Boolean ENABLED = Boolean.TRUE;
    private static final Boolean DISABLED = Boolean.FALSE;
    private static final Long DEFAULT_EXPIRY_TIME_IN_SECS = 20L;
    private RestApiDirectUrlConfig restApiDirectUrlConfig;

    @Before
    public void setup() {
        this.restApiDirectUrlConfig = new RestApiDirectUrlConfig();
        SystemWideDirectUrlConfig sysConfig = new SystemWideDirectUrlConfig();
        sysConfig.setEnabled(ENABLED);
        sysConfig.setDefaultExpiryTimeInSec(Long.valueOf(30L));
        sysConfig.setMaxExpiryTimeInSec(Long.valueOf(300L));
        this.restApiDirectUrlConfig.setSystemWideDirectUrlConfig(sysConfig);
    }

    @Test
    public void testValidConfig_RemainsEnabled() {
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected REST API direct URLs to be enabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
        this.restApiDirectUrlConfig.validate();
        Assert.assertTrue((String)"Expected REST API direct URLs to be enabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
    }

    @Test
    public void testValidConfig_RemainsDisabled() {
        this.setupDirectAccessConfig(DISABLED, DEFAULT_EXPIRY_TIME_IN_SECS);
        Assert.assertFalse((String)"Expected REST API direct URLs to be disabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
        this.restApiDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected REST API direct URLs to be disabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
    }

    @Test
    public void testValidConfig_DefaultExpiryTimeMissing() {
        this.setupDirectAccessConfig(ENABLED, null);
        Assert.assertNull((String)"Expected REST API default expiry time to be null", (Object)this.restApiDirectUrlConfig.getDefaultExpiryTimeInSec());
        this.restApiDirectUrlConfig.validate();
        Long expectedDefaultExpiryTime = this.restApiDirectUrlConfig.getSysWideDefaultExpiryTimeInSec();
        Assert.assertEquals((String)"Expected REST API default expiry time to be set to the system-wide default", (Object)expectedDefaultExpiryTime, (Object)this.restApiDirectUrlConfig.getDefaultExpiryTimeInSec());
        Assert.assertTrue((String)"Expected REST API direct URLs to be enabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeZero() {
        this.setupDirectAccessConfig(ENABLED, 0L);
        Assert.assertTrue((String)"Expected REST API direct URLs to be enabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
        this.restApiDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected REST API direct URLs to be disabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeNegative() {
        this.setupDirectAccessConfig(ENABLED, -1L);
        Assert.assertTrue((String)"Expected REST API direct URLs to be enabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
        this.restApiDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected REST API direct URLs to be disabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeExceedsSystemMax() {
        Long systemMax = this.restApiDirectUrlConfig.getSysWideMaxExpiryTimeInSec();
        this.setupDirectAccessConfig(ENABLED, systemMax + 1L);
        Assert.assertTrue((String)"Expected REST API direct URLs to be enabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
        this.restApiDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected REST API direct URLs to be disabled", (boolean)this.restApiDirectUrlConfig.isEnabled());
    }

    private void setupDirectAccessConfig(Boolean isEnabled, Long defaultExpiryTime) {
        this.restApiDirectUrlConfig.setEnabled(isEnabled);
        this.restApiDirectUrlConfig.setDefaultExpiryTimeInSec(defaultExpiryTime);
    }
}

