/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.util.Date;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.rest.api.model.AssocChild;
import org.alfresco.rest.api.model.AssocTarget;
import org.alfresco.rest.api.model.ClassDefinition;
import org.alfresco.rest.api.model.NodePermissions;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.Association;
import org.alfresco.rest.api.tests.client.data.ContentInfo;
import org.alfresco.rest.api.tests.client.data.PathInfo;
import org.alfresco.rest.api.tests.client.data.SearchResultEntry;
import org.alfresco.rest.api.tests.client.data.UserInfo;
import org.junit.Assert;

public class Node {
    protected String id;
    protected String name;
    protected Date createdAt;
    protected Date modifiedAt;
    protected UserInfo createdByUser;
    protected UserInfo modifiedByUser;
    protected Date archivedAt;
    protected UserInfo archivedByUser;
    protected String versionComment;
    protected Boolean isFolder;
    protected Boolean isFile;
    protected Boolean isLink;
    protected Boolean isLocked;
    protected String parentId;
    protected PathInfo path;
    protected String nodeType;
    protected List<String> aspectNames;
    protected Map<String, Object> properties;
    protected ContentInfo contentInfo;
    protected List<String> allowableOperations;
    protected NodePermissions nodePermissions;
    protected ClassDefinition definition;
    protected String relativePath;
    protected List<AssocChild> secondaryChildren;
    protected List<AssocTarget> targets;
    protected SearchResultEntry search;
    protected Boolean isFavorite;
    protected Association association;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public UserInfo getCreatedByUser() {
        return this.createdByUser;
    }

    public void setCreatedByUser(UserInfo createdByUser) {
        this.createdByUser = createdByUser;
    }

    public UserInfo getModifiedByUser() {
        return this.modifiedByUser;
    }

    public void setModifiedByUser(UserInfo modifiedByUser) {
        this.modifiedByUser = modifiedByUser;
    }

    public Date getArchivedAt() {
        return this.archivedAt;
    }

    public void setArchivedAt(Date archivedAt) {
        this.archivedAt = archivedAt;
    }

    public UserInfo getArchivedByUser() {
        return this.archivedByUser;
    }

    public void setArchivedByUser(UserInfo archivedByUser) {
        this.archivedByUser = archivedByUser;
    }

    public String getVersionComment() {
        return this.versionComment;
    }

    public void setVersionComment(String versionComment) {
        this.versionComment = versionComment;
    }

    public Boolean getIsFolder() {
        return this.isFolder;
    }

    public void setIsFolder(Boolean isFolder) {
        this.isFolder = isFolder;
    }

    public Boolean getIsFile() {
        return this.isFile;
    }

    public void setIsFile(Boolean isFile) {
        this.isFile = isFile;
    }

    public Boolean getIsLink() {
        return this.isLink;
    }

    public void setIsLink(Boolean link) {
        this.isLink = link;
    }

    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean locked) {
        this.isLocked = locked;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public PathInfo getPath() {
        return this.path;
    }

    public void setPath(PathInfo path) {
        this.path = path;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public List<String> getAspectNames() {
        return this.aspectNames;
    }

    public void setAspectNames(List<String> aspectNames) {
        this.aspectNames = aspectNames;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setContent(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    public ContentInfo getContent() {
        return this.contentInfo;
    }

    public List<String> getAllowableOperations() {
        return this.allowableOperations;
    }

    public void setAllowableOperations(List<String> allowableOperations) {
        this.allowableOperations = allowableOperations;
    }

    public NodePermissions getPermissions() {
        return this.nodePermissions;
    }

    public void setPermissions(NodePermissions nodePermissions) {
        this.nodePermissions = nodePermissions;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    public List<AssocChild> getSecondaryChildren() {
        return this.secondaryChildren;
    }

    public void setSecondaryChildren(List<AssocChild> secondaryChildren) {
        this.secondaryChildren = secondaryChildren;
    }

    public List<AssocTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(List<AssocTarget> targets) {
        this.targets = targets;
    }

    public ClassDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(ClassDefinition definition) {
        this.definition = definition;
    }

    public Association getAssociation() {
        return this.association;
    }

    public void setAssociation(Association association) {
        this.association = association;
    }

    public SearchResultEntry getSearch() {
        return this.search;
    }

    public void setSearch(SearchResultEntry search) {
        this.search = search;
    }

    public Boolean getIsFavorite() {
        return this.isFavorite;
    }

    public void setIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
    }

    public void expected(Object o) {
        Node other = (Node)o;
        if (this.id != null) {
            AssertUtil.assertEquals("id", this.id, other.getId());
        } else {
            Assert.assertNotNull((Object)other.id);
        }
        AssertUtil.assertEquals("parentId", this.parentId, other.getParentId());
        AssertUtil.assertEquals("name", this.name, other.getName());
        AssertUtil.assertEquals("nodeType", this.nodeType, other.getNodeType());
        if (this.createdAt != null) {
            AssertUtil.assertEquals("createdAt", this.createdAt, other.getCreatedAt());
        } else {
            Assert.assertNotNull((Object)other.createdAt);
        }
        if (this.createdByUser != null) {
            this.createdByUser.expected(other.getCreatedByUser());
        } else {
            Assert.assertNotNull((Object)other.createdByUser);
        }
        if (this.modifiedAt != null) {
            Assert.assertTrue((this.modifiedAt.before(other.getModifiedAt()) || this.modifiedAt.equals(other.getModifiedAt()) ? 1 : 0) != 0);
        } else {
            Assert.assertNotNull((Object)other.modifiedAt);
        }
        if (this.modifiedByUser != null) {
            this.modifiedByUser.expected(other.getModifiedByUser());
        } else {
            Assert.assertNotNull((Object)other.modifiedByUser);
        }
        if (this.aspectNames != null) {
            Assert.assertNotNull(other.getAspectNames());
            TestCase.assertEquals((String)("Expected: " + String.valueOf(this.aspectNames) + ", actual: " + String.valueOf(other.getAspectNames())), (int)this.aspectNames.size(), (int)other.getAspectNames().size());
            for (String string : this.aspectNames) {
                Assert.assertTrue((boolean)other.getAspectNames().contains(string));
            }
        } else {
            Assert.assertNull(other.getAspectNames());
        }
        if (this.properties != null) {
            Assert.assertNotNull(other.getProperties());
            TestCase.assertEquals((int)this.properties.size(), (int)other.getProperties().size());
            for (Map.Entry entry : this.properties.entrySet()) {
                Object otherObj = other.getProperties().get(entry.getKey());
                TestCase.assertEquals(entry.getValue(), (Object)otherObj);
            }
        } else {
            Assert.assertNull(other.getProperties());
        }
        AssertUtil.assertEquals("isFolder", this.isFolder, other.getIsFolder());
        AssertUtil.assertEquals("isFile", this.isFile, other.getIsFile());
        AssertUtil.assertEquals("isLink", this.isLink, other.getIsLink());
        AssertUtil.assertEquals("isLocked", this.isLocked, other.getIsLocked());
        if (this.path != null) {
            this.path.expected(other.getPath());
        } else {
            Assert.assertNull((Object)other.getPath());
        }
        if (this.contentInfo != null) {
            this.contentInfo.expected(other.getContent());
        } else {
            Assert.assertNull((Object)other.getContent());
        }
        if (this.search != null) {
            this.search.expected(other.getSearch());
        } else {
            Assert.assertNull((Object)other.getSearch());
        }
        if (this.allowableOperations != null) {
            Assert.assertNotNull(other.getAllowableOperations());
            TestCase.assertEquals((String)("Expected: " + String.valueOf(this.allowableOperations) + ", actual: " + String.valueOf(other.getAllowableOperations())), (int)this.allowableOperations.size(), (int)other.getAllowableOperations().size());
            for (String string : this.allowableOperations) {
                Assert.assertTrue((boolean)other.getAllowableOperations().contains(string));
            }
        } else {
            Assert.assertNull(other.getAllowableOperations());
        }
        if (this.relativePath != null) {
            TestCase.assertEquals((String)this.relativePath, (String)other.getRelativePath());
        } else {
            Assert.assertNull((Object)other.getRelativePath());
        }
    }
}

