/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.function.Supplier;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.web.scripts.TempOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.StringBuilderWriter;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Runtime;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.extensions.webscripts.WrappingWebScriptResponse;
import org.springframework.util.FileCopyUtils;

public class BufferedResponse
implements WrappingWebScriptResponse,
AutoCloseable {
    protected static final Log logger = LogFactory.getLog(BufferedResponse.class);
    private final Supplier<TempOutputStream> streamFactory;
    private final WebScriptResponse res;
    private final int bufferSize;
    private TempOutputStream outputStream;
    private StringBuilderWriter outputWriter;

    public BufferedResponse(WebScriptResponse res, int bufferSize, Supplier<TempOutputStream> streamFactory) {
        this.res = res;
        this.bufferSize = bufferSize;
        this.streamFactory = streamFactory;
    }

    public WebScriptResponse getNext() {
        return this.res;
    }

    public void addHeader(String name, String value) {
        this.res.addHeader(name, value);
    }

    public String encodeScriptUrl(String url) {
        return this.res.encodeScriptUrl(url);
    }

    public String getEncodeScriptUrlFunction(String name) {
        return this.res.getEncodeScriptUrlFunction(name);
    }

    public String encodeResourceUrl(String url) {
        return this.res.encodeResourceUrl(url);
    }

    public String getEncodeResourceUrlFunction(String name) {
        return this.res.getEncodeResourceUrlFunction(name);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream != null) {
            return this.outputStream;
        }
        if (this.outputWriter != null) {
            throw new AlfrescoRuntimeException("Already buffering output writer");
        }
        this.outputStream = this.streamFactory.get();
        return this.outputStream;
    }

    public Runtime getRuntime() {
        return this.res.getRuntime();
    }

    public Writer getWriter() throws IOException {
        if (this.outputWriter != null) {
            return this.outputWriter;
        }
        if (this.outputStream != null) {
            throw new AlfrescoRuntimeException("Already buffering output stream");
        }
        this.outputWriter = new StringBuilderWriter(this.bufferSize);
        return this.outputWriter;
    }

    public void reset() {
        if (this.outputStream != null) {
            this.outputStream = null;
        } else if (this.outputWriter != null) {
            this.outputWriter = null;
        }
        this.res.reset();
    }

    public void reset(String preserveHeadersPattern) {
        if (this.outputStream != null) {
            this.outputStream = null;
        } else if (this.outputWriter != null) {
            this.outputWriter = null;
        }
        this.res.reset(preserveHeadersPattern);
    }

    public void setCache(Cache cache) {
        this.res.setCache(cache);
    }

    public void setContentType(String contentType) {
        this.res.setContentType(contentType);
    }

    public void setContentEncoding(String contentEncoding) {
        this.res.setContentEncoding(contentEncoding);
    }

    public void setHeader(String name, String value) {
        this.res.setHeader(name, value);
    }

    public void setStatus(int status) {
        this.res.setStatus(status);
    }

    public void writeResponse() {
        try {
            if (logger.isDebugEnabled() && this.outputStream != null) {
                logger.debug((Object)("Writing Transactional response: size=" + this.outputStream.getLength()));
            }
            if (this.outputWriter != null) {
                this.outputWriter.flush();
                this.res.getWriter().write(this.outputWriter.toString());
            } else if (this.outputStream != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Writing Transactional response: size=" + this.outputStream.getLength()));
                }
                FileCopyUtils.copy((InputStream)this.outputStream.toNewInputStream(), (OutputStream)this.res.getOutputStream());
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to commit buffered response", (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.outputStream != null) {
            try {
                this.outputStream.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outputStream = null;
        }
    }
}

