/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.jscript.ScriptUtils;
import org.alfresco.repo.web.scripts.RepositoryContainer;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.WebScript;

public class WebScriptUtils
extends ScriptUtils {
    protected RepositoryContainer repositoryContainer;

    public void setRepositoryContainer(RepositoryContainer repositoryContainer) {
        this.repositoryContainer = repositoryContainer;
    }

    public Object[] findWebScripts(String family) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (WebScript webscript : this.repositoryContainer.getRegistry().getWebScripts()) {
            this.addScriptDescription(family, values, webscript);
        }
        return values.toArray(new Object[0]);
    }

    public Object[] findWebScriptsForCurrentUser(String family) {
        ArrayList<Object> values = new ArrayList<Object>();
        boolean isAdminOrSystemUser = this.repositoryContainer.isAdminOrSystemUser();
        for (WebScript webscript : this.repositoryContainer.getRegistry().getWebScripts()) {
            Description.RequiredAuthentication required = webscript.getDescription().getRequiredAuthentication();
            if (Description.RequiredAuthentication.admin == required && !isAdminOrSystemUser) continue;
            this.addScriptDescription(family, values, webscript);
        }
        return values.toArray(new Object[0]);
    }

    private void addScriptDescription(String family, List<Object> values, WebScript webscript) {
        if (family != null) {
            Set families = webscript.getDescription().getFamilys();
            if (families != null && families.contains(family)) {
                values.add(webscript.getDescription());
            }
        } else {
            values.add(webscript.getDescription());
        }
    }

    public String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "Unknown";
        }
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "Unknown";
        }
    }

    public RepoUsage getRestrictions() {
        return this.services.getRepoAdminService().getRestrictions();
    }

    public RepoUsage getUsage() {
        return this.services.getRepoAdminService().getUsage();
    }

    public List<StoreRef> getStores() {
        return this.services.getNodeService().getStores();
    }
}

