/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.search;

import java.io.IOException;
import org.alfresco.rest.api.search.SerializerTestHelper;
import org.alfresco.rest.api.search.model.SearchSQLQuery;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SearchSQLParseTest {
    private static SerializerTestHelper helper;

    @BeforeClass
    public static void setupTests() throws Exception {
        helper = new SerializerTestHelper();
    }

    @Test
    public void testSQLDeserializeQuery() throws IOException {
        String query = "{\"stmt\": \"select cm_name from alfresco\"}";
        SearchSQLQuery searchQuery = this.parse(query);
        Assert.assertEquals((Object)"select cm_name from alfresco", (Object)searchQuery.getStmt());
    }

    @Test
    public void testSQLDeserializeSelectQuery() throws IOException {
        String query = "{\"stmt\": \"select SITE from alfresco\"}";
        SearchSQLQuery searchQuery = this.parse(query);
        Assert.assertEquals((Object)"select SITE from alfresco", (Object)searchQuery.getStmt());
    }

    private SearchSQLQuery parse(String json) throws IOException {
        return (SearchSQLQuery)helper.searchSQLQueryFromJson(json, SearchSQLQuery.class);
    }
}

