/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.validator.actions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.rest.api.Actions;
import org.alfresco.rest.api.Nodes;
import org.alfresco.rest.api.impl.validator.actions.ActionNodeParameterValidator;
import org.alfresco.rest.api.model.ActionDefinition;
import org.alfresco.rest.api.model.rules.Action;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespaceService;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ActionNodeParameterValidatorTest {
    private static final String READ_RIGHTS_REQUIRED_DEFINITION_ID = "link-category";
    private static final String CATEGORY_NODE_REF_PARAM = (String)((List)ActionNodeParameterValidator.REQUIRE_READ_PERMISSION_PARAMS.get("link-category")).get(0);
    private static final String DESTINATION_FOLDER_PARAM = "destination-folder";
    private static final String NODE_ID = "node-id";
    private static final String COPY_ACTION = "copy";
    @Mock
    private Actions actionsMock;
    @Mock
    private NamespaceService namespaceServiceMock;
    @Mock
    private Nodes nodesMock;
    @Mock
    private PermissionService permissionServiceMock;
    @InjectMocks
    private ActionNodeParameterValidator objectUnderTest;

    @Test
    public void testProperPermissionsForReadRights() {
        Action action = new Action();
        action.setActionDefinitionId(READ_RIGHTS_REQUIRED_DEFINITION_ID);
        action.setParams(Map.of(CATEGORY_NODE_REF_PARAM, NODE_ID));
        ActionDefinition.ParameterDefinition parameterDef = new ActionDefinition.ParameterDefinition(CATEGORY_NODE_REF_PARAM, DataTypeDefinition.NODE_REF.toPrefixString(), false, true, null, null);
        ActionDefinition actionDefinition = new ActionDefinition(COPY_ACTION, COPY_ACTION, null, null, null, false, false, List.of(parameterDef));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById(READ_RIGHTS_REQUIRED_DEFINITION_ID)).willReturn((Object)actionDefinition);
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI())).willReturn(List.of(""));
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, NODE_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(NODE_ID)).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission(nodeRef)).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.nodesMock.nodeMatches(nodeRef, Set.of(ContentModel.TYPE_CATEGORY), Collections.emptySet())).willReturn((Object)true);
        this.objectUnderTest.validate(action);
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById(READ_RIGHTS_REQUIRED_DEFINITION_ID);
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceServiceMock).should()).getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI());
        BDDMockito.then((Object)this.namespaceServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(NODE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(nodeRef, Set.of(ContentModel.TYPE_CATEGORY), Collections.emptySet());
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(nodeRef);
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testNotEnoughPermissionsForReadRights() {
        Action action = new Action();
        action.setActionDefinitionId(COPY_ACTION);
        action.setParams(Map.of(DESTINATION_FOLDER_PARAM, NODE_ID));
        ActionDefinition.ParameterDefinition parameterDef = new ActionDefinition.ParameterDefinition(DESTINATION_FOLDER_PARAM, DataTypeDefinition.NODE_REF.toPrefixString(), false, true, null, null);
        ActionDefinition actionDefinition = new ActionDefinition(COPY_ACTION, COPY_ACTION, null, null, null, false, false, List.of(parameterDef));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById(COPY_ACTION)).willReturn((Object)actionDefinition);
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI())).willReturn(List.of(""));
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, NODE_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(NODE_ID)).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission(nodeRef)).willReturn((Object)AccessStatus.DENIED);
        Assertions.assertThatExceptionOfType(EntityNotFoundException.class).isThrownBy(() -> this.objectUnderTest.validate(action));
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById(COPY_ACTION);
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceServiceMock).should()).getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI());
        BDDMockito.then((Object)this.namespaceServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(NODE_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(nodeRef);
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testValidateForNodeNotFound() {
        Action action = new Action();
        action.setActionDefinitionId(COPY_ACTION);
        action.setParams(Map.of(DESTINATION_FOLDER_PARAM, NODE_ID));
        ActionDefinition.ParameterDefinition parameterDef = new ActionDefinition.ParameterDefinition(DESTINATION_FOLDER_PARAM, DataTypeDefinition.NODE_REF.toPrefixString(), false, true, null, null);
        ActionDefinition actionDefinition = new ActionDefinition(COPY_ACTION, COPY_ACTION, null, null, null, false, false, List.of(parameterDef));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById(COPY_ACTION)).willReturn((Object)actionDefinition);
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI())).willReturn(List.of(""));
        BDDMockito.given((Object)this.nodesMock.validateNode(NODE_ID)).willThrow(EntityNotFoundException.class);
        Assertions.assertThatExceptionOfType(EntityNotFoundException.class).isThrownBy(() -> this.objectUnderTest.validate(action));
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById(COPY_ACTION);
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceServiceMock).should()).getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI());
        BDDMockito.then((Object)this.namespaceServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(NODE_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testProperPermissionsForWriteRights() {
        Action action = new Action();
        action.setActionDefinitionId(COPY_ACTION);
        action.setParams(Map.of(DESTINATION_FOLDER_PARAM, NODE_ID));
        ActionDefinition.ParameterDefinition parameterDef = new ActionDefinition.ParameterDefinition(DESTINATION_FOLDER_PARAM, DataTypeDefinition.NODE_REF.toPrefixString(), false, true, null, null);
        ActionDefinition actionDefinition = new ActionDefinition(COPY_ACTION, COPY_ACTION, null, null, null, false, false, List.of(parameterDef));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById(COPY_ACTION)).willReturn((Object)actionDefinition);
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI())).willReturn(List.of(""));
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, NODE_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(NODE_ID)).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission(nodeRef)).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.permissionServiceMock.hasPermission(nodeRef, "Write")).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.nodesMock.nodeMatches(nodeRef, Set.of(ContentModel.TYPE_FOLDER), Collections.emptySet())).willReturn((Object)true);
        this.objectUnderTest.validate(action);
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById(COPY_ACTION);
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceServiceMock).should()).getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI());
        BDDMockito.then((Object)this.namespaceServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(NODE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(nodeRef, Set.of(ContentModel.TYPE_FOLDER), Collections.emptySet());
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(nodeRef);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasPermission(nodeRef, "Write");
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testNotEnoughPermissionsForWriteRights() {
        Action action = new Action();
        action.setActionDefinitionId(COPY_ACTION);
        action.setParams(Map.of(DESTINATION_FOLDER_PARAM, NODE_ID));
        ActionDefinition.ParameterDefinition parameterDef = new ActionDefinition.ParameterDefinition(DESTINATION_FOLDER_PARAM, DataTypeDefinition.NODE_REF.toPrefixString(), false, true, null, null);
        ActionDefinition actionDefinition = new ActionDefinition(COPY_ACTION, COPY_ACTION, null, null, null, false, false, List.of(parameterDef));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById(COPY_ACTION)).willReturn((Object)actionDefinition);
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI())).willReturn(List.of(""));
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, NODE_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(NODE_ID)).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission(nodeRef)).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.permissionServiceMock.hasPermission(nodeRef, "Write")).willReturn((Object)AccessStatus.DENIED);
        Assertions.assertThatExceptionOfType(PermissionDeniedException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining("No proper permissions for node: node-id");
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById(COPY_ACTION);
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceServiceMock).should()).getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI());
        BDDMockito.then((Object)this.namespaceServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(NODE_ID);
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(nodeRef);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasPermission(nodeRef, "Write");
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testNoValidationExecutedForNonNodeRefParam() {
        Action action = new Action();
        action.setActionDefinitionId(COPY_ACTION);
        String dummyParam = "dummyParam";
        action.setParams(Map.of("dummyParam", "dummyValue"));
        ActionDefinition.ParameterDefinition parameterDef = new ActionDefinition.ParameterDefinition("dummyParam", DataTypeDefinition.TEXT.toPrefixString(), false, true, null, null);
        ActionDefinition actionDefinition = new ActionDefinition(COPY_ACTION, COPY_ACTION, null, null, null, false, false, List.of(parameterDef));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById(COPY_ACTION)).willReturn((Object)actionDefinition);
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI())).willReturn(List.of(""));
        this.objectUnderTest.validate(action);
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById(COPY_ACTION);
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceServiceMock).should()).getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI());
        BDDMockito.then((Object)this.namespaceServiceMock).shouldHaveNoMoreInteractions();
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoInteractions();
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoInteractions();
    }

    @Test
    public void testWrongTypeOfNodeWhenFolderExpected() {
        Action action = new Action();
        action.setActionDefinitionId(COPY_ACTION);
        action.setParams(Map.of(DESTINATION_FOLDER_PARAM, NODE_ID));
        ActionDefinition.ParameterDefinition parameterDef = new ActionDefinition.ParameterDefinition(DESTINATION_FOLDER_PARAM, DataTypeDefinition.NODE_REF.toPrefixString(), false, true, null, null);
        ActionDefinition actionDefinition = new ActionDefinition(COPY_ACTION, COPY_ACTION, null, null, null, false, false, List.of(parameterDef));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById(COPY_ACTION)).willReturn((Object)actionDefinition);
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI())).willReturn(List.of(""));
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, NODE_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(NODE_ID)).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission(nodeRef)).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.permissionServiceMock.hasPermission(nodeRef, "Write")).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.nodesMock.nodeMatches(nodeRef, Set.of(ContentModel.TYPE_FOLDER), Collections.emptySet())).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining("Node is not a folder node-id");
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById(COPY_ACTION);
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceServiceMock).should()).getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI());
        BDDMockito.then((Object)this.namespaceServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(NODE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(nodeRef, Set.of(ContentModel.TYPE_FOLDER), Collections.emptySet());
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(nodeRef);
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasPermission(nodeRef, "Write");
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testWrongTypeOfNodeWhenCategoryExpected() {
        Action action = new Action();
        action.setActionDefinitionId(READ_RIGHTS_REQUIRED_DEFINITION_ID);
        action.setParams(Map.of(CATEGORY_NODE_REF_PARAM, NODE_ID));
        ActionDefinition.ParameterDefinition parameterDef = new ActionDefinition.ParameterDefinition(CATEGORY_NODE_REF_PARAM, DataTypeDefinition.NODE_REF.toPrefixString(), false, true, null, null);
        ActionDefinition actionDefinition = new ActionDefinition(READ_RIGHTS_REQUIRED_DEFINITION_ID, READ_RIGHTS_REQUIRED_DEFINITION_ID, null, null, null, false, false, List.of(parameterDef));
        BDDMockito.given((Object)this.actionsMock.getRuleActionDefinitionById(READ_RIGHTS_REQUIRED_DEFINITION_ID)).willReturn((Object)actionDefinition);
        BDDMockito.given((Object)this.namespaceServiceMock.getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI())).willReturn(List.of(""));
        NodeRef nodeRef = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, NODE_ID);
        BDDMockito.given((Object)this.nodesMock.validateNode(NODE_ID)).willReturn((Object)nodeRef);
        BDDMockito.given((Object)this.permissionServiceMock.hasReadPermission(nodeRef)).willReturn((Object)AccessStatus.ALLOWED);
        BDDMockito.given((Object)this.nodesMock.nodeMatches(nodeRef, Set.of(ContentModel.TYPE_CATEGORY), Collections.emptySet())).willReturn((Object)false);
        Assertions.assertThatExceptionOfType(InvalidArgumentException.class).isThrownBy(() -> this.objectUnderTest.validate(action)).withMessageContaining("Node is not a category node-id");
        ((Actions)BDDMockito.then((Object)this.actionsMock).should()).getRuleActionDefinitionById(READ_RIGHTS_REQUIRED_DEFINITION_ID);
        BDDMockito.then((Object)this.actionsMock).shouldHaveNoMoreInteractions();
        ((NamespaceService)BDDMockito.then((Object)this.namespaceServiceMock).should()).getPrefixes(DataTypeDefinition.NODE_REF.getNamespaceURI());
        BDDMockito.then((Object)this.namespaceServiceMock).shouldHaveNoMoreInteractions();
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).validateNode(NODE_ID);
        ((Nodes)BDDMockito.then((Object)this.nodesMock).should()).nodeMatches(nodeRef, Set.of(ContentModel.TYPE_CATEGORY), Collections.emptySet());
        BDDMockito.then((Object)this.nodesMock).shouldHaveNoMoreInteractions();
        ((PermissionService)BDDMockito.then((Object)this.permissionServiceMock).should()).hasReadPermission(nodeRef);
        BDDMockito.then((Object)this.permissionServiceMock).shouldHaveNoMoreInteractions();
    }

    @Test
    public void testGetDefinitionIds() {
        List<String> expectedIds = List.of(COPY_ACTION, "move", "check-out", "import", READ_RIGHTS_REQUIRED_DEFINITION_ID, "simple-workflow", "transform", "transform-image");
        List actualIds = this.objectUnderTest.getActionDefinitionIds();
        Assert.assertEquals(expectedIds, (Object)actualIds);
    }

    @Test
    public void testHasProperPriority() {
        int expectedPriority = -2147483647;
        int actualPriority = this.objectUnderTest.getPriority();
        Assert.assertEquals((long)-2147483647L, (long)actualPriority);
    }
}

