/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.util.List;
import org.junit.Assert;

public class PathInfo {
    private String name;
    private Boolean isComplete;
    private String relativePath;
    private List<ElementInfo> elements;

    public PathInfo() {
    }

    public PathInfo(String name, Boolean isComplete, List<ElementInfo> elements) {
        this.name = name;
        this.isComplete = isComplete;
        this.elements = elements;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsComplete() {
        return this.isComplete;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public List<ElementInfo> getElements() {
        return this.elements;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(120);
        sb.append("PathInfo [name=").append(this.name).append(", isComplete=").append(this.isComplete).append(", elements=").append(this.elements).append(']');
        return sb.toString();
    }

    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof PathInfo));
        PathInfo other = (PathInfo)o;
        Assert.assertEquals((Object)this.getIsComplete(), (Object)other.getIsComplete());
        Assert.assertEquals((Object)this.getName(), (Object)other.getName());
        int idx = 0;
        for (ElementInfo element : this.elements) {
            ElementInfo otherElement = other.getElements().get(idx);
            Assert.assertEquals((String)("Expected: " + element.getId() + ", actual: " + otherElement.getId()), (Object)element.getId(), (Object)otherElement.getId());
            Assert.assertEquals((String)("Expected: " + element.getName() + ", actual: " + otherElement.getName()), (Object)element.getName(), (Object)otherElement.getName());
            ++idx;
        }
    }

    public static class ElementInfo {
        private String id;
        private String name;
        private String nodeType;
        private List<String> aspectNames;

        public ElementInfo() {
        }

        public ElementInfo(String id, String name) {
            this(id, name, null, null);
        }

        public ElementInfo(String id, String name, String nodeType, List<String> aspectNames) {
            this.id = id;
            this.name = name;
            this.nodeType = nodeType;
            this.aspectNames = aspectNames;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public List<String> getAspectNames() {
            return this.aspectNames;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("PathElement [id=").append(this.id).append(", name=").append(this.name).append(", nodeType=").append(this.nodeType).append(", aspectNames=").append(this.aspectNames).append(']');
            return sb.toString();
        }

        public void expected(Object o) {
            Assert.assertTrue((boolean)(o instanceof ElementInfo));
            ElementInfo other = (ElementInfo)o;
            Assert.assertEquals((Object)this.id, (Object)other.getName());
            Assert.assertEquals((Object)this.name, (Object)other.getName());
            Assert.assertEquals((Object)this.nodeType, (Object)other.getNodeType());
        }
    }
}

