/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.config;

import java.util.Iterator;
import org.alfresco.repo.web.scripts.config.OpenSearchConfigElement;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class OpenSearchElementReader
implements ConfigElementReader {
    public static final String ELEMENT_OPENSEARCH = "opensearch";
    public static final String ELEMENT_ENGINES = "engines";
    public static final String ELEMENT_ENGINE = "engine";
    public static final String ELEMENT_URL = "url";
    public static final String ELEMENT_PROXY = "proxy";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_LABEL_ID = "label-id";
    public static final String ATTR_PROXY = "proxy";

    public ConfigElement parse(Element element) {
        OpenSearchConfigElement configElement = null;
        if (element != null) {
            Element urlElem;
            String elementName = element.getName();
            if (!elementName.equals(ELEMENT_OPENSEARCH)) {
                throw new ConfigException("OpenSearchElementReader can only parse opensearchelements, the element passed was '" + elementName + "'");
            }
            configElement = new OpenSearchConfigElement();
            Element pluginsElem = element.element(ELEMENT_ENGINES);
            if (pluginsElem != null) {
                Iterator engines = pluginsElem.elementIterator(ELEMENT_ENGINE);
                while (engines.hasNext()) {
                    Element engineElem = (Element)engines.next();
                    String label = engineElem.attributeValue(ATTR_LABEL);
                    String labelId = engineElem.attributeValue(ATTR_LABEL_ID);
                    String proxy = engineElem.attributeValue("proxy");
                    OpenSearchConfigElement.EngineConfig engineCfg = new OpenSearchConfigElement.EngineConfig(label, labelId, proxy);
                    Iterator urlsConfig = engineElem.elementIterator(ELEMENT_URL);
                    while (urlsConfig.hasNext()) {
                        Element urlConfig = (Element)urlsConfig.next();
                        String type = urlConfig.attributeValue(ATTR_TYPE);
                        String url = urlConfig.getTextTrim();
                        engineCfg.addUrl(type, url);
                    }
                    configElement.addEngine(engineCfg);
                }
            }
            String url = null;
            Element proxyElem = element.element("proxy");
            if (proxyElem != null && (urlElem = proxyElem.element(ELEMENT_URL)) != null) {
                url = urlElem.getTextTrim();
                OpenSearchConfigElement.ProxyConfig proxyCfg = new OpenSearchConfigElement.ProxyConfig(url);
                configElement.setProxy(proxyCfg);
            }
        }
        return configElement;
    }
}

