/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.comments;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.web.scripts.comments.AbstractCommentsWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CommentDelete
extends AbstractCommentsWebScript {
    private static Log logger = LogFactory.getLog(CommentDelete.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> executeImpl(NodeRef nodeRef, WebScriptRequest req, Status status, Cache cache) {
        NodeRef topicNodeRef;
        String pageParams = req.getParameter("pageParams");
        JSONObject jsonPageParams = this.parseJSONFromString(pageParams);
        String parentNodeRefStr = this.getOrNull(jsonPageParams, "nodeRef");
        NodeRef parentNodeRef = null;
        if (parentNodeRefStr != null) {
            parentNodeRef = new NodeRef(this.getOrNull(jsonPageParams, "nodeRef"));
        }
        if (parentNodeRef == null) {
            topicNodeRef = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
            if (topicNodeRef == null || !this.nodeService.getType(topicNodeRef).equals((Object)ForumModel.TYPE_TOPIC)) {
                throw new IllegalArgumentException("The NodeRef specified is not a child of the topic.");
            }
            NodeRef forumNodeRef = this.nodeService.getPrimaryParent(topicNodeRef).getParentRef();
            if (forumNodeRef == null || !this.nodeService.getType(forumNodeRef).equals((Object)ForumModel.TYPE_FORUM)) {
                throw new IllegalArgumentException("The NodeRef specified doesn't belong to a correct structure of forums.");
            }
            parentNodeRef = this.nodeService.getPrimaryParent(forumNodeRef).getParentRef();
        }
        if (parentNodeRef != null) {
            this.behaviourFilter.disableBehaviour(parentNodeRef, ContentModel.ASPECT_AUDITABLE);
        }
        try {
            this.deleteComment(nodeRef);
            if (this.nodeService.exists(nodeRef)) {
                status.setCode(500, "Unable to delete node: " + String.valueOf(nodeRef));
                topicNodeRef = null;
                return topicNodeRef;
            }
            Map<String, Object> model = this.generateModel(nodeRef);
            this.postActivity(null, req, parentNodeRef, "org.alfresco.comments.comment-deleted");
            status.setCode(200);
            Map<String, Object> map = model;
            return map;
        }
        finally {
            if (parentNodeRef != null) {
                this.behaviourFilter.enableBehaviour(parentNodeRef, ContentModel.ASPECT_AUDITABLE);
            }
        }
    }

    private void deleteComment(NodeRef commentNodeRef) {
        QName nodeType = this.nodeService.getType(commentNodeRef);
        if (!nodeType.equals((Object)ForumModel.TYPE_POST)) {
            throw new IllegalArgumentException("Node to delete is not a comment node.");
        }
        this.nodeService.deleteNode(commentNodeRef);
    }

    private Map<String, Object> generateModel(NodeRef commentNodeRef) {
        HashMap<String, Object> model = new HashMap<String, Object>(2, 1.0f);
        model.put("message", "Node " + String.valueOf(commentNodeRef) + " deleted");
        return model;
    }
}

