/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.downloads;

import java.util.Collections;
import java.util.List;
import org.alfresco.rest.api.Downloads;
import org.alfresco.rest.api.model.Download;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.ResourceParameter;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="downloads", title="Downloads")
public class DownloadsEntityResource
implements EntityResourceAction.Create<Download>,
EntityResourceAction.ReadById<Download>,
EntityResourceAction.Delete,
InitializingBean {
    private Downloads downloads;

    public void setDownloads(Downloads downloads) {
        this.downloads = downloads;
    }

    public void afterPropertiesSet() {
        ParameterCheck.mandatory((String)"downloads", (Object)this.downloads);
    }

    @Override
    @WebApiDescription(title="Create download", description="Create a download node whose content will be a zip which is being created asynchronously.", successStatus=202)
    @WebApiParam(name="entity", title="Download request", description="Download request which contains the node ids for the zip elements.", kind=ResourceParameter.KIND.HTTP_BODY_OBJECT, allowMultiple=false)
    public List<Download> create(List<Download> entity, Parameters parameters) {
        Download downloadNode = this.downloads.createDownloadNode(entity.get(0));
        return Collections.singletonList(downloadNode);
    }

    @Override
    @WebApiDescription(title="Get download information", description="Get information about the progress of the zip creation.")
    @WebApiParam(name="nodeId", title="Download nodeId")
    public Download readById(String nodeId, Parameters parameters) throws EntityNotFoundException {
        return this.downloads.getDownloadStatus(nodeId);
    }

    @Override
    @WebApiDescription(title="Cancel download", description="Stop the zip creation if still in progress.", successStatus=202)
    public void delete(String nodeId, Parameters parameters) {
        this.downloads.cancel(nodeId);
    }
}

