/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.impl.rules;

import java.util.Collections;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.rest.api.RuleSettings;
import org.alfresco.rest.api.impl.rules.NodeValidator;
import org.alfresco.rest.api.model.rules.RuleSetting;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.service.Experimental;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

@Experimental
public class RuleSettingsImpl
implements RuleSettings {
    private NodeValidator validator;
    private NodeService nodeService;

    @Override
    public RuleSetting getRuleSetting(String folderId, String ruleSettingKey) {
        NodeRef folderNode = this.validator.validateFolderNode(folderId, false);
        switch (ruleSettingKey) {
            case "-isInheritanceEnabled-": {
                return this.getIsInheritanceEnabled(folderNode);
            }
        }
        throw new NotFoundException("Unrecognised rule setting key " + ruleSettingKey);
    }

    private RuleSetting getIsInheritanceEnabled(NodeRef folderNode) {
        boolean inheritanceDisabled = this.nodeService.hasAspect(folderNode, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        return RuleSetting.builder().key("-isInheritanceEnabled-").value(!inheritanceDisabled).create();
    }

    @Override
    public RuleSetting setRuleSetting(String folderId, RuleSetting ruleSetting) {
        NodeRef folderNode = this.validator.validateFolderNode(folderId, true);
        switch (ruleSetting.getKey()) {
            case "-isInheritanceEnabled-": {
                return this.updateIsInheritanceEnabled(folderNode, ruleSetting.getValue());
            }
        }
        throw new NotFoundException("Unrecognised rule setting key " + ruleSetting.getKey());
    }

    private RuleSetting updateIsInheritanceEnabled(NodeRef folderNode, Object value) {
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Rule setting -isInheritanceEnabled- requires a boolean value.");
        }
        if (((Boolean)value).booleanValue()) {
            this.nodeService.removeAspect(folderNode, RuleModel.ASPECT_IGNORE_INHERITED_RULES);
        } else {
            this.nodeService.addAspect(folderNode, RuleModel.ASPECT_IGNORE_INHERITED_RULES, Collections.emptyMap());
        }
        return RuleSetting.builder().key("-isInheritanceEnabled-").value(value).create();
    }

    public void setValidator(NodeValidator validator) {
        this.validator = validator;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

