/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.framework.webscripts;

import java.util.Map;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.core.ResourceMetadata;
import org.alfresco.rest.framework.core.ResourceOperation;
import org.alfresco.rest.framework.core.ResourceWithMetadata;
import org.alfresco.rest.framework.core.exceptions.DeletedResourceException;
import org.alfresco.rest.framework.core.exceptions.UnsupportedResourceOperationException;
import org.alfresco.rest.framework.resource.actions.interfaces.BinaryResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceBinaryAction;
import org.alfresco.rest.framework.resource.parameters.Params;
import org.alfresco.rest.framework.tools.RecognizedParamsExtractor;
import org.alfresco.rest.framework.webscripts.AbstractResourceWebScript;
import org.alfresco.rest.framework.webscripts.ParamsExtractor;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.http.HttpMethod;

public class ResourceWebScriptDelete
extends AbstractResourceWebScript
implements ParamsExtractor,
RecognizedParamsExtractor {
    public ResourceWebScriptDelete() {
        this.setHttpMethod(HttpMethod.DELETE);
        this.setParamsExtractor(this);
    }

    @Override
    public Params extractParams(ResourceMetadata resourceMeta, WebScriptRequest req) {
        Map<String, String> resourceVars = this.locator.parseTemplateVars(req.getServiceMatch().getTemplateVars());
        String entityId = resourceVars.get("entityId");
        String relationshipId = resourceVars.get("relationshipId");
        String relationship2Id = resourceVars.get("relationship2Id");
        Params.RecognizedParams params = this.getRecognizedParams(req);
        switch (resourceMeta.getType()) {
            case ENTITY: {
                return Params.valueOf(params, entityId, relationshipId, req);
            }
            case RELATIONSHIP: {
                if (StringUtils.isNotBlank((CharSequence)relationship2Id)) {
                    return Params.valueOf(false, entityId, relationshipId, relationship2Id, null, null, null, params, null, req);
                }
                return Params.valueOf(params, entityId, relationshipId, req);
            }
            case PROPERTY: {
                String resourceName = resourceVars.get("relationResource");
                String propertyName = resourceVars.get("property");
                if (!StringUtils.isNotBlank((CharSequence)entityId) || !StringUtils.isNotBlank((CharSequence)resourceName)) break;
                if (StringUtils.isNotBlank((CharSequence)propertyName)) {
                    return Params.valueOf(entityId, relationshipId, null, null, propertyName, params, null, req);
                }
                return Params.valueOf(entityId, null, null, null, resourceName, params, null, req);
            }
        }
        throw new UnsupportedResourceOperationException("DELETE not supported for Actions");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object executeAction(ResourceWithMetadata resource, Params params, WithResponse withResponse) {
        switch (2.$SwitchMap$org$alfresco$rest$framework$core$ResourceMetadata$RESOURCE_TYPE[resource.getMetaData().getType().ordinal()]) {
            case 1: {
                if (!StringUtils.isNotBlank((CharSequence)params.getEntityId())) ** GOTO lbl17
                if (EntityResourceAction.DeleteWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.DeleteWithResponse.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    entityDeleter = (EntityResourceAction.DeleteWithResponse)resource.getResource();
                    entityDeleter.delete(params.getEntityId(), params, withResponse);
                    return null;
                }
                if (EntityResourceAction.Delete.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.Delete.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    entityDeleter = (EntityResourceAction.Delete)resource.getResource();
                    entityDeleter.delete(params.getEntityId(), params);
                    return null;
                }
                ** GOTO lbl29
lbl17:
                // 1 sources

                if (EntityResourceAction.DeleteSetWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.DeleteSetWithResponse.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    entityDeleter = (EntityResourceAction.DeleteSetWithResponse)resource.getResource();
                    entityDeleter.deleteSet(params, withResponse);
                    return null;
                }
                if (EntityResourceAction.DeleteSet.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(EntityResourceAction.DeleteSet.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    entityDeleter = (EntityResourceAction.DeleteSet)resource.getResource();
                    entityDeleter.deleteSet(params);
                    return null;
                }
            }
lbl29:
            // 4 sources

            case 2: {
                if (!StringUtils.isNotBlank((CharSequence)params.getRelationshipId())) ** GOTO lbl44
                if (RelationshipResourceAction.DeleteWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.DeleteWithResponse.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    relationDeleter = (RelationshipResourceAction.DeleteWithResponse)resource.getResource();
                    relationDeleter.delete(params.getEntityId(), params.getRelationshipId(), params, withResponse);
                    return null;
                }
                if (RelationshipResourceAction.Delete.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.Delete.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    relationDeleter = (RelationshipResourceAction.Delete)resource.getResource();
                    relationDeleter.delete(params.getEntityId(), params.getRelationshipId(), params);
                    return null;
                }
                ** GOTO lbl56
lbl44:
                // 1 sources

                if (RelationshipResourceAction.DeleteSetWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.DeleteSetWithResponse.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    relationDeleter = (RelationshipResourceAction.DeleteSetWithResponse)resource.getResource();
                    relationDeleter.deleteSet(params.getEntityId(), params, withResponse);
                    return null;
                }
                if (RelationshipResourceAction.DeleteSet.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceAction.Delete.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    relationDeleter = (RelationshipResourceAction.DeleteSet)resource.getResource();
                    relationDeleter.deleteSet(params.getEntityId(), params);
                    return null;
                }
            }
lbl56:
            // 4 sources

            case 3: {
                if (BinaryResourceAction.DeleteWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(BinaryResourceAction.DeleteWithResponse.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    binDeleter = (BinaryResourceAction.DeleteWithResponse)resource.getResource();
                    binDeleter.deleteProperty(params.getEntityId(), params, withResponse);
                    return null;
                }
                if (BinaryResourceAction.Delete.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(BinaryResourceAction.Delete.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    binDeleter = (BinaryResourceAction.Delete)resource.getResource();
                    binDeleter.deleteProperty(params.getEntityId(), params);
                    return null;
                }
                if (RelationshipResourceBinaryAction.DeleteWithResponse.class.isAssignableFrom(resource.getResource().getClass())) {
                    if (resource.getMetaData().isDeleted(RelationshipResourceBinaryAction.DeleteWithResponse.class)) {
                        throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                    }
                    binDeleter = (RelationshipResourceBinaryAction.DeleteWithResponse)resource.getResource();
                    binDeleter.deleteProperty(params.getEntityId(), params.getRelationshipId(), params, withResponse);
                    return null;
                }
                if (!RelationshipResourceBinaryAction.Delete.class.isAssignableFrom(resource.getResource().getClass())) break;
                if (resource.getMetaData().isDeleted(RelationshipResourceBinaryAction.Delete.class)) {
                    throw new DeletedResourceException("(DELETE) " + resource.getMetaData().getUniqueId());
                }
                binDeleter = (RelationshipResourceBinaryAction.Delete)resource.getResource();
                binDeleter.deleteProperty(params.getEntityId(), params.getRelationshipId(), params);
                return null;
            }
        }
        throw new UnsupportedResourceOperationException("DELETE not supported for Actions");
    }

    @Override
    public Void execute(final ResourceWithMetadata resource, final Params params, WebScriptResponse res, boolean isReadOnly) {
        ResourceOperation operation = resource.getMetaData().getOperation(HttpMethod.DELETE);
        final WithResponse callBack = new WithResponse(operation.getSuccessStatus(), DEFAULT_JSON_CONTENT, CACHE_NEVER);
        RetryingTransactionHelper transHelper = this.getTransactionHelper(resource.getMetaData().getApi().getName());
        transHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ResourceWebScriptDelete.this.executeAction(resource, params, callBack);
                return null;
            }
        }, false, true);
        this.setResponse(res, callBack);
        return null;
    }
}

