/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import org.alfresco.repo.webdav.LockInfo;
import org.alfresco.repo.webdav.LockInfoImpl;
import org.junit.Assert;
import org.junit.Test;

public class LockInfoImplTest {
    @Test
    public void canSetTimeoutSeconds() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutSeconds(7);
        Assert.assertEquals((long)86407000L, (long)lockInfo.getExpires().getTime());
    }

    @Test
    public void canSetTimeoutSecondsToInfinity() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutSeconds(-1);
        Assert.assertNull((Object)lockInfo.getExpires());
    }

    @Test
    public void canSetTimeoutMinutes() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutMinutes(5);
        Assert.assertEquals((long)86700000L, (long)lockInfo.getExpires().getTime());
    }

    @Test
    public void canSetTimeoutMinutesToInfinity() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutMinutes(-1);
        Assert.assertNull((Object)lockInfo.getExpires());
    }

    @Test
    public void canGetRemainingTimeoutSeconds() {
        LockInfoImplEx lockInfo = new LockInfoImplEx();
        lockInfo.setTimeoutSeconds(7);
        Assert.assertEquals((long)7L, (long)lockInfo.getRemainingTimeoutSeconds());
    }

    @Test(expected=IllegalStateException.class)
    public void cannotChangeSharedLockToExclusive() {
        LockInfoImpl lockInfo = new LockInfoImpl();
        lockInfo.addSharedLockToken("shared-token");
        lockInfo.setExclusiveLockToken("token");
    }

    @Test(expected=IllegalStateException.class)
    public void cannotChangeExclusiveLockToShared() {
        LockInfoImpl lockInfo = new LockInfoImpl();
        lockInfo.setExclusiveLockToken("token");
        lockInfo.addSharedLockToken("shared-token");
    }

    public void canSetShared() {
        LockInfoImpl lockInfo = new LockInfoImpl();
        lockInfo.setExclusiveLockToken("exc-token");
        Assert.assertEquals((Object)"exc-token", (Object)lockInfo.getExclusiveLockToken());
    }

    public void canSetExclusive() {
        LockInfoImpl lockInfo = new LockInfoImpl();
        lockInfo.addSharedLockToken("shared1");
        lockInfo.addSharedLockToken("shared2");
        Assert.assertEquals((long)2L, (long)lockInfo.getSharedLockTokens().size());
        Assert.assertTrue((boolean)lockInfo.getSharedLockTokens().contains("shared1"));
        Assert.assertTrue((boolean)lockInfo.getSharedLockTokens().contains("shared2"));
    }

    @Test
    public void canGenerateJSON() throws JsonParseException, JsonMappingException, IOException {
        LockInfoImpl lockInfo = new LockInfoImpl();
        lockInfo.setExclusiveLockToken("opaque-lock-token");
        lockInfo.setDepth("infinity");
        lockInfo.setScope("exclusive");
        String json = lockInfo.toJSON();
        ObjectMapper objectMapper = new ObjectMapper();
        Assert.assertTrue((String)"ADDINFO_WEBDAV_MARKER", (boolean)json.startsWith("WebDAV_LockInfo"));
        json = json.substring("WebDAV_LockInfo".length() + 1);
        LockInfoImpl parsed = (LockInfoImpl)objectMapper.readValue(json, LockInfoImpl.class);
        Assert.assertEquals((Object)"opaque-lock-token", (Object)parsed.getExclusiveLockToken());
        Assert.assertEquals((Object)"infinity", (Object)parsed.getDepth());
        Assert.assertEquals((Object)"exclusive", (Object)parsed.getScope());
        lockInfo = new LockInfoImpl();
        lockInfo.addSharedLockToken("opaque-lock-token-1");
        lockInfo.addSharedLockToken("opaque-lock-token-2");
        lockInfo.addSharedLockToken("opaque-lock-token-3");
        lockInfo.setDepth("0");
        lockInfo.setScope("shared");
        json = lockInfo.toJSON();
        Assert.assertTrue((String)"ADDINFO_WEBDAV_MARKER", (boolean)json.startsWith("WebDAV_LockInfo"));
        json = json.substring("WebDAV_LockInfo".length() + 1);
        parsed = (LockInfoImpl)objectMapper.readValue(json, LockInfoImpl.class);
        TreeSet sortedTokens = new TreeSet(parsed.getSharedLockTokens());
        Iterator tokenIt = sortedTokens.iterator();
        Assert.assertEquals((Object)"opaque-lock-token-1", tokenIt.next());
        Assert.assertEquals((Object)"opaque-lock-token-2", tokenIt.next());
        Assert.assertEquals((Object)"opaque-lock-token-3", tokenIt.next());
        Assert.assertEquals((Object)"0", (Object)parsed.getDepth());
        Assert.assertEquals((Object)"shared", (Object)parsed.getScope());
    }

    @Test
    public void canParseJSON() throws JsonParseException, JsonMappingException, IOException {
        LockInfoImpl lockInfo = new LockInfoImpl();
        lockInfo.setExclusiveLockToken("opaque-lock-token");
        lockInfo.setDepth("infinity");
        lockInfo.setScope("exclusive");
        String json = lockInfo.toJSON();
        LockInfo parsed = LockInfoImpl.fromJSON((String)json);
        Assert.assertEquals((Object)"opaque-lock-token", (Object)parsed.getExclusiveLockToken());
        Assert.assertEquals((Object)"infinity", (Object)parsed.getDepth());
        Assert.assertEquals((Object)"exclusive", (Object)parsed.getScope());
        lockInfo = new LockInfoImpl();
        lockInfo.addSharedLockToken("opaque-lock-token-1");
        lockInfo.addSharedLockToken("opaque-lock-token-2");
        lockInfo.addSharedLockToken("opaque-lock-token-3");
        lockInfo.setDepth("0");
        lockInfo.setScope("shared");
        json = lockInfo.toJSON();
        parsed = LockInfoImpl.fromJSON((String)json);
        TreeSet sortedTokens = new TreeSet(parsed.getSharedLockTokens());
        Iterator tokenIt = sortedTokens.iterator();
        Assert.assertEquals((Object)"opaque-lock-token-1", tokenIt.next());
        Assert.assertEquals((Object)"opaque-lock-token-2", tokenIt.next());
        Assert.assertEquals((Object)"opaque-lock-token-3", tokenIt.next());
        Assert.assertEquals((Object)"0", (Object)parsed.getDepth());
        Assert.assertEquals((Object)"shared", (Object)parsed.getScope());
    }

    public static class LockInfoImplEx
    extends LockInfoImpl {
        public static final Date DATE_NOW = new Date(86400000L);
        private static final long serialVersionUID = 1669378516554195322L;

        protected Date dateNow() {
            return DATE_NOW;
        }
    }
}

