/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs.blog;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.BlogIntegrationModel;
import org.alfresco.repo.web.scripts.blogs.AbstractBlogWebScript;
import org.alfresco.repo.web.scripts.blogs.BlogLibJs;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.namespace.QName;
import org.json.simple.JSONObject;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class BlogPut
extends AbstractBlogWebScript {
    @Override
    protected Map<String, Object> executeImpl(SiteInfo site, NodeRef containerNodeRef, BlogPostInfo blog, WebScriptRequest req, JSONObject json, Status status, Cache cache) {
        if (blog != null) {
            throw new WebScriptException(400, "Blog post should not be updated via this web script.");
        }
        if (site != null && containerNodeRef == null) {
            containerNodeRef = this.siteService.createContainer(site.getShortName(), "blog", null, null);
        }
        this.updateBlog(containerNodeRef, json);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("item", containerNodeRef);
        return model;
    }

    private void updateBlog(NodeRef node, JSONObject json) {
        Map<QName, Serializable> arr = BlogLibJs.getBlogPropertiesArray(json);
        if (this.nodeService.hasAspect(node, BlogIntegrationModel.ASPECT_BLOG_DETAILS)) {
            Map properties = this.nodeService.getProperties(node);
            properties.putAll(arr);
            this.nodeService.setProperties(node, properties);
        } else {
            this.nodeService.addAspect(node, BlogIntegrationModel.ASPECT_BLOG_DETAILS, arr);
        }
    }
}

