/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.rest.api.tests.EnterpriseTestApi;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Comment;
import org.alfresco.rest.api.tests.client.data.Tag;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LuceneTests.class, RedundantTests.class})
public class TestTags
extends EnterpriseTestApi {
    @Test
    @Category(value={LuceneTests.class, RedundantTests.class})
    public void testTags() throws Exception {
        Tag tag;
        Tag tag2;
        Iterator<RepoService.TestNetwork> networksIt = this.getTestFixture().getNetworksIt();
        Assert.assertTrue((boolean)networksIt.hasNext());
        final RepoService.TestNetwork network1 = networksIt.next();
        Assert.assertTrue((boolean)networksIt.hasNext());
        final RepoService.TestNetwork network2 = networksIt.next();
        final ArrayList people = new ArrayList(3);
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network1.createUser();
                people.add(person);
                person = network1.createUser();
                people.add(person);
                return null;
            }
        }, (String)network1.getId());
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestPerson person = network2.createUser();
                people.add(person);
                return null;
            }
        }, (String)network2.getId());
        RepoService.TestPerson person1 = (RepoService.TestPerson)people.get(0);
        RepoService.TestPerson person2 = (RepoService.TestPerson)people.get(1);
        RepoService.TestPerson person3 = (RepoService.TestPerson)people.get(2);
        final ArrayList nodes = new ArrayList();
        final ArrayList sites = new ArrayList();
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

            public Void doWork() throws Exception {
                RepoService.TestSite site = network1.createSite(SiteVisibility.PRIVATE);
                sites.add(site);
                NodeRef nodeRef = TestTags.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc", "Test Content");
                nodes.add(nodeRef);
                nodeRef = TestTags.this.repoService.createDocument(site.getContainerNodeRef("documentLibrary"), "Test Doc 1", "Test Content 1");
                nodes.add(nodeRef);
                return null;
            }
        }, (String)person1.getId(), (String)network1.getId());
        final NodeRef nodeRef1 = (NodeRef)nodes.get(0);
        final NodeRef nodeRef2 = (NodeRef)nodes.get(1);
        PublicApiClient.Nodes nodesProxy = this.publicApiClient.nodes();
        PublicApiClient.Comments commentsProxy = this.publicApiClient.comments();
        PublicApiClient.Tags tagsProxy = this.publicApiClient.tags();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag("tag 1"));
        tags.add(new Tag("tag 9"));
        tags.add(new Tag("other tag 3"));
        tags.add(new Tag("my tag 1"));
        tags.add(new Tag("tag 5"));
        try {
            Comment comment = new Comment("Test Comment", "Test Comment");
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            Comment newComment = commentsProxy.createNodeComment(nodeRef1.getId(), comment);
            Tag[] tag3 = new Tag("testTag");
            nodesProxy.createNodeTag(newComment.getId(), (Tag)tag3);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            tag2 = new Tag("testTag");
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            Tag newTag = nodesProxy.createNodeTag(nodeRef1.getId(), tag2);
            nodesProxy.createNodeTag(newTag.getId(), tag2);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        Tag[] multiByteTags = new Tag[]{new Tag("\u67e5\u770b\u5168\u90e8"), new Tag("\u67e5\u770b\u5168\u91e8"), new Tag("%^&%&$^\u221a\u00c7\u00ac\u00a3@")};
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        HashMap<String, Tag> createdTags = new HashMap<String, Tag>();
        for (Tag tag4 : multiByteTags) {
            Tag ret = nodesProxy.createNodeTag(nodeRef2.getId(), tag4);
            createdTags.put(ret.getId(), ret);
        }
        int skipCount = 0;
        int maxItems = Integer.MAX_VALUE;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<Tag> resp = nodesProxy.getNodeTags(nodeRef2.getId(), this.createParams(paging, null));
        List<Tag> retTags = resp.getList();
        Assert.assertEquals((long)createdTags.size(), (long)retTags.size());
        for (Tag tag5 : retTags) {
            String tagId = tag5.getId();
            Tag expectedTag = (Tag)createdTags.get(tagId);
            expectedTag.expected(tag5);
        }
        try {
            Tag tag6 = new Tag("");
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.createNodeTag(nodeRef2.getId(), tag6);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        ArrayList tagUpdates = new ArrayList(createdTags.values());
        ((Tag)tagUpdates.get(0)).setTag("\u4e00\u4e01\u4e02\u4e10");
        ((Tag)tagUpdates.get(1)).setTag("\u4e00\u4e01\u4e12\u4e11");
        ((Tag)tagUpdates.get(2)).setTag("\u4e00\u4e01\u4e12\u4e12");
        HashMap<String, Tag> updatedTags = new HashMap<String, Tag>();
        for (Tag tag7 : tagUpdates) {
            Tag ret = tagsProxy.update(tag7);
            Assert.assertNotNull((Object)ret.getId());
            Assert.assertNotNull((Object)ret.getTag());
            updatedTags.put(ret.getId(), ret);
        }
        List expectedNodeTags = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Tag>>(){

            public List<Tag> doWork() throws Exception {
                List<Tag> tags = TestTags.this.repoService.getTags(nodeRef2);
                return tags;
            }
        }, (String)person1.getId(), (String)network1.getId());
        skipCount = 0;
        maxItems = tagUpdates.size();
        paging = this.getPaging(skipCount, maxItems, tagUpdates.size(), tagUpdates.size());
        resp = nodesProxy.getNodeTags(nodeRef2.getId(), this.createParams(paging, null));
        this.checkList(expectedNodeTags.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        ArrayList<Tag> createdTags2 = new ArrayList<Tag>();
        for (Tag tag8 : tags) {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            Tag ret = nodesProxy.createNodeTag(nodeRef1.getId(), tag8);
            Assert.assertEquals((Object)tag8.getTag(), (Object)ret.getTag());
            Assert.assertNotNull((Object)ret.getId());
            createdTags2.add(ret);
        }
        try {
            Tag tag9 = new Tag(((Tag)createdTags2.get(0)).getId(), "");
            tagsProxy.update(tag9);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)400L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.createNodeTag(GUID.generate(), (Tag)tags.get(0));
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        List expectedNodeTags2 = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Tag>>(){

            public List<Tag> doWork() throws Exception {
                List<Tag> tags = TestTags.this.repoService.getTags(nodeRef1);
                return tags;
            }
        }, (String)person1.getId(), (String)network1.getId());
        skipCount = 0;
        maxItems = 2;
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        paging = this.getPaging(skipCount, maxItems, expectedNodeTags2.size(), expectedNodeTags2.size());
        resp = nodesProxy.getNodeTags(nodeRef1.getId(), this.createParams(paging, null));
        this.checkList(expectedNodeTags2.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        skipCount = 2;
        maxItems = Integer.MAX_VALUE;
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        paging = this.getPaging(skipCount, maxItems, expectedNodeTags2.size(), expectedNodeTags2.size());
        resp = nodesProxy.getNodeTags(nodeRef1.getId(), this.createParams(paging, null));
        this.checkList(expectedNodeTags2.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
        try {
            skipCount = 0;
            maxItems = 2;
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            paging = this.getPaging(skipCount, maxItems, expectedNodeTags2.size(), expectedNodeTags2.size());
            PublicApiClient.ListResponse<Tag> allTags = nodesProxy.getNodeTags("invalidNode", this.createParams(paging, null));
            this.checkList(expectedNodeTags2.subList(skipCount, paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), allTags);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = 0;
            maxItems = 2;
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person3.getId()));
            PublicApiClient.Paging expectedPaging = this.getPaging(skipCount, maxItems, expectedNodeTags2.size(), expectedNodeTags2.size());
            nodesProxy.getNodeTags(nodeRef1.getId(), this.createParams(expectedPaging, null));
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            skipCount = 0;
            maxItems = 2;
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person2.getId()));
            paging = this.getPaging(skipCount, maxItems, expectedNodeTags2.size(), expectedNodeTags2.size());
            resp = nodesProxy.getNodeTags(nodeRef1.getId(), this.createParams(paging, null));
            this.checkList(expectedNodeTags2.subList(skipCount, skipCount + paging.getExpectedPaging().getCount()), paging.getExpectedPaging(), resp);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
        List expectedNetworkTags = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Tag>>(){

            public List<Tag> doWork() throws Exception {
                List<Tag> tags = TestTags.this.repoService.getTags();
                return tags;
            }
        }, (String)person1.getId(), (String)network1.getId());
        int skipCount2 = 0;
        int maxItems2 = 2;
        PublicApiClient.Paging paging2 = this.getPaging(skipCount2, maxItems2, expectedNetworkTags.size(), null);
        PublicApiClient.ListResponse<Tag> allTags = tagsProxy.getTags(this.createParams(paging2, null));
        this.checkList(expectedNetworkTags.subList(skipCount2, skipCount2 + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), allTags);
        skipCount2 = 2;
        maxItems2 = Integer.MAX_VALUE;
        paging2 = this.getPaging(skipCount2, maxItems2, expectedNetworkTags.size(), null);
        allTags = tagsProxy.getTags(this.createParams(paging2, null));
        this.checkList(expectedNetworkTags.subList(skipCount2, skipCount2 + paging2.getExpectedPaging().getCount()), paging2.getExpectedPaging(), allTags);
        tag2 = (Tag)tags.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        nodesProxy.createNodeTag(nodeRef1.getId(), tag2);
        try {
            tag2 = (Tag)tags.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.createNodeTag(GUID.generate(), tag2);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        int skipCount3 = 0;
        int maxItems3 = 2;
        PublicApiClient.Paging paging3 = this.getPaging(skipCount3, maxItems3);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        PublicApiClient.ListResponse<Tag> allTags2 = tagsProxy.getTags(this.createParams(paging3, null));
        Assert.assertTrue((allTags2.getList().size() > 0 ? 1 : 0) != 0);
        Tag tag10 = allTags2.getList().get(0);
        String newTagValue = GUID.generate();
        Tag newTag = new Tag(tag10.getId(), newTagValue);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        Tag ret = tagsProxy.update(newTag);
        Assert.assertEquals((Object)newTagValue, (Object)ret.getTag());
        try {
            Tag unknownTag = new Tag(GUID.generate(), GUID.generate());
            tagsProxy.update(unknownTag);
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        List networkTags = (List)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<List<Tag>>(){

            public List<Tag> doWork() throws Exception {
                List<Tag> tags = TestTags.this.repoService.getTags();
                return tags;
            }
        }, (String)person1.getId(), (String)network1.getId());
        Assert.assertTrue((networkTags.size() > 0 ? 1 : 0) != 0);
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.update("nodes", nodeRef1.getId(), "tags", null, null, "Unable to PUT node tags");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.remove("nodes", nodeRef1.getId(), "tags", null, "Unable to DELETE node tags");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            tag = (Tag)networkTags.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.update("nodes", nodeRef1.getId(), "tags", tag.getId(), null, "Unable to PUT node tag");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            tag = (Tag)networkTags.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.create("tags", null, null, null, tag.toJSON().toString(), "Unable to POST to tags");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            tag = (Tag)networkTags.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.update("tags", null, null, null, tag.toJSON().toString(), "Unable to PUT tags");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.remove("tags", null, null, null, "Unable to DELETE tags");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            tag = (Tag)networkTags.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.create("tags", tag.getId(), null, null, tag.toJSON().toString(), "Unable to POST to a tag");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            tag = (Tag)networkTags.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.remove("tags", tag.getId(), null, null, "Unable to DELETE a tag");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
        tag = (Tag)networkTags.get(0);
        this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
        nodesProxy.removeNodeTag(nodeRef1.getId(), tag.getId());
        PublicApiClient.ListResponse<Tag> resp2 = nodesProxy.getNodeTags(nodeRef1.getId(), this.createParams(this.getPaging(0, Integer.MAX_VALUE), null));
        List<Tag> nodeTags = resp2.getList();
        Assert.assertTrue((!nodeTags.contains(tag) ? 1 : 0) != 0);
        try {
            tag = (Tag)networkTags.get(0);
            this.publicApiClient.setRequestContext(new RequestContext(network1.getId(), person1.getId()));
            nodesProxy.getSingle("nodes", nodeRef1.getId(), "tags", tag.getId(), "Unable to GET node tag");
            Assert.fail();
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)405L, (long)e.getHttpResponse().getStatusCode());
        }
    }
}

